package com.ulcjava.base.shared.internal;


	/**
	* An multi-purpose object container for ULC. <p/> An <code>Anything</code>
	* objectprovides a convenient way to wrap data that should be
exchanged between
	* a ULC client and a ULC server. An <code>Anything</code> object always
	* containseither <code>null</code> or a single
(arbitrary) object only.
	* However,this class provides special support and convenience methods if the
	* contained object is a map (of type
<code>java.util.Map</code>) or if the
	* contained object is a list (of type <code>java.util.List</code>). <p/> At
	* creation, an
<code>Anything</code> object can be configured to contain
	* <code>null</code> or any other object. Using the support and
	* convenience
methods from below the <code>Anything</code> object can mutate to
	* contain a list or a map, but only in case the contained object
	* was
<code>null</code> before. As soon as the <code>Anything</code> object
	* contains a non-<code>null</code> value, the reference to the
related
	* containedobject cannot change anymore. <p/> List-related support and
	* convenience methods implicitly create a contained list, if
the contained
	* object was <code>null</code> before. They throw an exception, if the
	* <code>Anything</code> object contains a (non-<code>null</code>)
object, which
	* is not of type <code>java.util.List</code> <p/> Map-related support and
	* convenience methods implicitly create a contained
map, if the contained
	* objectwas <code>null</code> before. They throw an exception if the
	* <code>Anything</code> object contains a
(non-<code>null</code>) object, which
	* is not of type <code>java.util.Map</code>
	*
	* @ulc.extension		
	**/
 public  final class Anything extends java.lang.Object implements java.io.Serializable
{

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object is <code>null</code>.
	*
	* @deprecated		Use {@link #toObject()} <code>== null</code> to determine the type of the contained object is <code>null</code>.
	**/
	 public  final  static int NULL = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type
<code>java.lang.Boolean</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int BOOLEAN = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type
<code>java.lang.Long</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int LONG = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type
<code>java.lang.Double</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int DOUBLE = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type
<code>java.lang.String</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int STRING = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type <code>byte[]</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int BYTES = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type
<code>java.util.List</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int VECTOR = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has the type
<code>java.lang.Integer</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int INT = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object is <code>java.lang.Float</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int FLOAT = 0;

	/**
	* Describes the type of object contained in an <code>Anything</code> object. In
	* this case the object has a type other than the types
indicated by the
	* constants <code>NULL</code>, <code>BOOLEAN</code>, <code>LONG</code>,
	* <code>DOUBLE</code>,
<code>STRING</code>, <code>BYTES</code>,
	* <code>VECTOR</code>, <code>INT</code> and <code>FLOAT</code>.
	*
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public  final  static int OTHER = 0;


	/**
	* Creates an <code>Anything</code> object with <code>null</code> as its contents.
	*
	**/
	 public Anything()
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with an object as its contents.
	*
	* @param object 		 the contents object
	**/
	 public Anything(java.lang.Object object)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Short</code>
	* object as its contents.
	*
	* @param s 		 the <code>short</code> value to be wrapped
	**/
	 public Anything(short s)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Integer</code>
	* object as its contents.
	*
	* @param i 		 the <code>int</code> value to be wrapped
	**/
	 public Anything(int i)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Long</code>
	* object as its contents.
	*
	* @param l 		 the <code>long</code> value to be wrapped
	**/
	 public Anything(long l)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Float</code>
	* object as its contents.
	*
	* @param f 		 the <code>float</code> value to be wrapped
	**/
	 public Anything(float f)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Double</code>
	* object as its contents.
	*
	* @param d 		 the <code>double</code> value to be wrapped
	**/
	 public Anything(double d)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Boolean</code>
	* object as its contents.
	*
	* @param b 		 the <code>boolean</code> value to be wrapped
	**/
	 public Anything(boolean b)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a
	* <code>java.lang.Character</code>object as its contents.
	*
	* @param c 		 the <code>char</code> value to be wrapped
	**/
	 public Anything(char c)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.lang.Byte</code>
	* object as its contents.
	*
	* @param b 		 the <code>byte</code> value to be wrapped
	**/
	 public Anything(byte b)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.util.List</code>
	* object as its contents. The related list contains the
array elements which
	* arepassed in to this constructor. The resulting list preserves the order of
	* the elements as given by the
parameter array.
	*
	* @param strings 		 the strings that will be put into the list
	* @deprecated		Use the constructor {@link #Anything(Object)} if you want to avoid the copying of the array into a list. The following
construct ensures that {@link #Anything(Object)} is called: <code>new Anything((Object) strings)</code>
	**/
	 public Anything(java.lang.String[] strings)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.util.List</code>
	* object as its contents. The related list contains the
array elements which
	* arepassed in to this constructor. The resulting list preserves the order of
	* the elements as given by the
parameter array.
	*
	* @param ints 		 the integers that will be put into the list after wrapping them in <code>java.lang.Integer</code> objects
	* @deprecated		Use the constructor {@link #Anything(Object)} if you want to avoid the copying of the array into a list. The following
construct ensures that {@link #Anything(Object)} is called: <code>new Anything((Object) ints)</code>
	**/
	 public Anything(int[] ints)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.util.List</code>
	* object as its contents. The related list contains the
array elements which
	* arepassed in to this constructor. The resulting list preserves the order of
	* the elements as given by the
parameter array.
	*
	* @param doubles 		 the doubles that will be put into the list after wrapping them in <code>java.lang.Double</code> objects
	* @deprecated		Use the constructor {@link #Anything(Object)} if you want to avoid the copying of the array into a list. The following
construct ensures that {@link #Anything(Object)} is called: <code>new Anything((Object) doubles)</code>
	**/
	 public Anything(double[] doubles)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.util.List</code>
	* object as its contents. The related list contains
<code>java.util.List</code>
	* objects, which in turn contain the array elements of the second array
	* dimension of the two-dimensional
array which is passed in to this
	* constructor.The resulting nested lists preserve the order of the elements as
	* given by the parameter
array.
	*
	* @param ints 		 the two-dimension array of ints that will put the list after wrapping each <code>int</code> in a
<code>java.lang.Integer</code> object
	* @deprecated		Use the constructor {@link #Anything(Object)} if you want to avoid the copying of the array into a list. The following
construct ensures that {@link #Anything(Object)} is called: <code>new Anything((Object) ints)</code>
	**/
	 public Anything(int[][] ints)
	{
		 super();
	}


	/**
	* Creates an <code>Anything</code> object with a <code>java.util.List</code>
	* object as its contents. The related list is a flat
copy of the list passed in
	* to this constructor.
	*
	* @param l 		 the list to be copied
	* @deprecated		Use the constructor {@link #Anything(Object)} if you want to avoid the copying of the list. The following construct
ensures that {@link #Anything(Object)} is called: <code>new Anything((Object) l)</code>
	**/
	 public Anything(java.util.List l)
	{
		 super();
	}


	/**
	* Tries to append a value to the end of a <code>java.util.List</code> object.
	* Thelatter is assumed to be contained in this
<code>Anything</code> object.
	* Theactual value is wrapped in <code>Anything</code> argument and will be
	* retrieved from there for
the append operation without copying.
	*
	* @param value 		 the value to be appended wrapped in an <code>Anything</code> object
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>.
	* @deprecated		Use {@link #append(Object)} instead.
	**/
	 public void append(com.ulcjava.base.shared.internal.Anything value)
	{
	}


	/**
	* Tries to append a value to the end of a <code>java.util.List</code> object.
	* Thelatter is assumed to be contained in this
<code>Anything</code> object.
	* Thevalue will be appended without copying.
	*
	* @param o 		 the value to be appended
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>.
	**/
	 public void append(java.lang.Object o)
	{
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* an <code>int</code> value and returns the result.
Returns the argument
	* <code>dflt</code> if the conversion fails. <p/> In detail the conversion
	* worksas follows: <list>
<li>If the contained object is an object of type
	* <code>java.lang.Number</code>, then the
	* method
<code>java.lang.Number.intValue()</code> is used for the
	* conversion.
<li>If the contained object is an object of type
	* <code>java.lang.Character</code>, then the
	* method
<code>java.lang.Character.charValue()</code> is used. The result is
	* casted to <code>int</code> and returned.
<li>If the contained object is an
	* object of type <code>java.lang.String</code>, then the method tries a
	* conversion using
<code>java.lang.Integer.parseInt()</code>.
<li>Otherwise, or
	* if any of the previous conversion attempts fails, <code>dflt</code> is
	* returned. </list>
	*
	* @param dflt 		 the default value to be returned, if the conversion attempts fail
	* @return		the result of the conversion
	* @deprecated		Use {@link #toInt()} instead.
	**/
	 public int asInt(int dflt)
	{
		return 0;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* a<code>long</code> value and returns the result.
Returns the argument
	* <code>dflt</code> if the conversion fails. <p/> In detail the conversion
	* worksas follows: <list>
<li>If the contained object is an object of type
	* <code>java.lang.Number</code>, then the
	* method
<code>java.lang.Number.longValue()</code> is used for the
	* conversion.
<li>If the contained object is an object of type
	* <code>java.lang.String</code>, then the method tries a conversion
	* using
<code>java.lang.Long.parseLong()</code>.
<li>Otherwise, or if any of
	* theprevious conversions attempts fails, <code>dflt</code> is returned. </list>
	*
	* @param dflt 		 the default value to be returned, if the conversion attempts fail
	* @return		the result of the conversion
	* @deprecated		Use {@link #toLong()} instead.
	**/
	 public long asLong(long dflt)
	{
		return 0L;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* a<code>float</code> value and returns the result.
Returns the argument
	* <code>dflt</code> if the conversion fails. <p/> In detail the conversion
	* worksas follows: <list>
<li>If the contained object is an object of type
	* <code>java.lang.Number</code>, then the
	* method
<code>java.lang.Number.floatValue()</code> is used for the
	* conversion.
<li>If the contained object is an object of type
	* <code>java.lang.String</code>, then the method tries a conversion
	* using
<code>java.lang.Float.parseFloat()</code>.
<li>Otherwise, or if any of
	* the previous conversions attempts fails, <code>dflt</code> is returned. </list>
	*
	* @param dflt 		 the default value to be returned, if the conversion attempts fail
	* @return		the result of the conversion
	* @deprecated		Use {@link #toFloat()} instead.
	**/
	 public float asFloat(float dflt)
	{
		return 0.0f;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* a<code>double</code> value and returns the result.
Returns the argument
	* <code>dflt</code> if the conversion fails. <p/> In detail the conversion
	* worksas follows: <list>
<li>If the contained object is an object of type
	* <code>java.lang.Number</code>, then the
	* method
<code>java.lang.Number.doubleValue()</code> is used for the
	* conversion.<li>If the contained object is an object of type
	* <code>java.lang.String</code>, then the method tries a conversion
	* using
<code>java.lang.Double.parseDouble()</code>.
<li>Otherwise, or if any
	* ofthe previous conversions attempts fails, <code>dflt</code> is returned.
	* </list>
	*
	* @param dflt 		 the default value to be returned,, if the conversion attempts fail
	* @return		the result of the conversion
	* @deprecated		Use {@link #toDouble()} instead.
	**/
	 public double asDouble(double dflt)
	{
		return 0.0d;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* a<code>boolean</code> value and returns the
result. Returns the argument
	* <code>dflt</code> if the conversion fails. <p/> In detail the conversion
	* worksas follows: <list>
<li>If the contained object is an object of type
	* <code>java.lang.Boolean</code>, then the
	* method
<code>java.lang.Boolean.booleanValue()</code> is used for the
	* conversion.
<li>If the contained object is an object of type
	* <code>java.lang.Number</code>, then the method returns <code>true</code>
	* in
case the related number is 0 and <code>false</code>
	* otherwise.
<li>Otherwise, or if any of the previous conversions attempts
	* fails, <code>dflt</code> is returned. </list>
	*
	* @param dflt 		 the default value to be returned, if the conversion attempts fail
	* @return		the result of the conversion
	* @deprecated		Use {@link #toBoolean()} instead.
	**/
	 public boolean asBoolean(boolean dflt)
	{
		return false;
	}


	/**
	* Converts the object contained in this <code>Anything</code> object to a
	* <code>byte[]</code> array and returns the result. <p/> In
detail the
	* conversion works as follows: <list>
<li>If the contained object is
	* <code>null</code> or of type <code>byte[]</code>, then the object is returned
	* as is.
<li>Otherwise, <code>toString().getBytes()</code> is called on the
	* contained object and the result is returned. </list>
	*
	* @return		the result of the conversion
	* @deprecated		Use {@link #toObject()} instead.
	**/
	 public byte[] asBytes()
	{
		return null;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* an <code>int[]</code> array and returns the result.
<p/> In detail the
	* conversion works as follows: <list>
<li>If the contained object is an object
	* of type <code>java.util.List</code>, then the method creates an
	* <code>int[]</code>
array with the same size as the contained list. For the
	* i-th element of the list, <code>asInt(dflt)</code> is called with
	* the
parameter <code>dflt</code> as given by this method. The result is
	* assigned to the i-th position of the created <code>int[]</code>
array. This
	* isdone for all elements in the list and eventually the <code>int[]</code>
	* array is returned.
<li>Otherwise, an exception is thrown. </list>
	*
	* @param dflt 		 the default value to be used by {@link #asInt(int)} as part of the conversion process
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @deprecated		
	**/
	 public int[] asIntArray(int dflt)
	{
		return null;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* an <code>int[][]</code> array and returns the
result. <p/> In detail the
	* conversion works as follows: <list>
<li>If the contained object is an object
	* of type <code>java.util.List</code>, then the method creates an
	* <code>int[][]</code>
array with the same first-dimension-size as the
	* containedlist. For the i-th element of the list, the conversion process of
	* themethod {@link #asIntArray(int)} is applied with the <code>int</code>
	* argument <code>dflt</code> as given by this method. The
result is assigned to
	* the i-th position (in the first dimension) of the created
	* <code>int[][]</code>array. This is done for all
elements of the list and
	* eventually the <code>int[][]</code> array is returned.
<li>An exception is
	* thrown, if the object contained in this <code>Anything</code> object is not
	* oftype
<code>java.util.List</code> or if the converion of any of the list
	* elements fails. </list>
	*
	* @param dflt 		 the default value to be used for the conversion of the list elements.
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code> or if the conversion of any of the related list elements fails
	* @deprecated		
	**/
	 public int[][] asIntSquareArray(int dflt)
	{
		return null;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* a<code>double[]</code> array and returns the
result. <p/> In detail the
	* conversion works as follows: <list>
<li>If the contained object is an object
	* of type <code>java.util.List</code>, then the method creates a
	* <code>double[]</code>
array with the same size as the contained list. For the
	* i-th element of the list, <code>asDouble(dflt)</code> is called with
	* the
parameter <code>dflt</code> as given by this method. The result is
	* assigned to the i-th position of the created
<code>double[]</code> array.
	* Thisis done for all elements in the list and eventually the
	* <code>double[]</code> array is
returned.
<li>Otherwise, an exception is
	* thrown. </list>
	*
	* @param dflt 		 the default value to be used by {@link #asDouble(double)} as part of the conversion process.
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @deprecated		
	**/
	 public double[] asDoubleArray(double dflt)
	{
		return null;
	}


	/**
	* Tries to convert the object contained in this <code>Anything</code> object to
	* astring value and returns the result. Returns the
argument <code>dflt</code>
	* if the conversion fails. <p/> In detail the conversion works as follows:
	* <list>
<li>If the contained object is an object of type
	* <code>java.lang.String</code>, then the object is returned.
<li>If the
	* contained object is an object of type <code>java.lang.Number</code>, then the
	* method <code>toString()</code> is used
for the conversion.
<li>If the
	* contained object is an object of type <code>byte[]</code>, then <code>new
	* java.lang.String(byte[])</code> is used
for the conversion.
<li>Otherwise,
	* <code>dflt</code> is returned. </list>
	*
	* @param dflt 		 the default value to be returned, if the conversion attempts do not apply
	* @return		the result of the conversion
	* @deprecated		
	**/
	 public java.lang.String asString(java.lang.String dflt)
	{
		return null;
	}


	/**
	* Wraps an object in an <code>Anything</code> object. The wrapping works as
	* follows: <list>
<li>If the contained object is an object of type
	* <code>Anything</code>, then the object is returned as is.
<li>If the
	* containedobject is an object of type <code>java.util.List</code>, then the
	* method returns the result of
<code>new
	* Anything((List)o)</code>.
<li>Otherwise, the method returns the result of
	* <code>new Anything((Object)o)</code>. </list>
	*
	* @param o 		 the object to be wrapped
	* @return		the <code>Anything</code> object wrapping <code>o</code>
	* @deprecated		Use {@link #Anything(Object)} instead. Notice that {@link #Anything(Object)} does not create a copy of a list if the
passed in object is of type <code>java.util.List</code>.
	**/
	 public  static com.ulcjava.base.shared.internal.Anything fromObject(java.lang.Object o)
	{
		return null;
	}


	/**
	* Tries to return the i-th element of a list or array contained in this
	* <code>Anything</code> object. The related element will be
wrapped in an
	* <code>Anything</code> object before it is returned. In detail the process
	* works as follows: <list>
<li>If the contained object is not an array or an
	* object of type <code>java.util.List</code>, then an exception is
	* thrown.
<li>Otherwise the i-th element of the list or array is retrieved and
	* wrapped in an <code>Anything</code> object. This may throw
	* an
<code>IndexOutOfBoundsException</code>, if the i-th element does not
	* exist.</list>
<p>
</p>
The i-th element <code>e</code> is wrapped in an
	* <code>Anything</code> object as follows: <list>
<li> If the element
	* <code>e</code> is of type <code>String[]</code>, then the result of <code>new
	* Anything((String[])e)</code>
is returned.
<li> If the element <code>e</code>
	* is of type <code>int[]</code>, then the result of <code>new
	* Anything((int[])e)</code> is
returned.
<li> If the element <code>e</code> is
	* of type <code>double[]</code>, then the result of <code>new
	* Anything((double[])e)</code>
is returned.
<li> If the element <code>e</code>
	* is of type <code>int[][]</code>, then the result of <code>new
	* Anything((int[][])e)</code>
is returned.
<li> If the element <code>e</code>
	* isof type <code>Anything</code>, then <code>e</code> is returned as is.
<li>
	* Otherwise <code>new Anything((Object)e)</code> is returned. </list>
	*
	* @param i 		 the i-th element to be retrieved from the contained list
	* @return		the i-th element wrapped in an <code>Anything</code> object
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not an array or of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an i-th element
	* @deprecated		Use {@link #getObject(int)} instead.
	**/
	 public com.ulcjava.base.shared.internal.Anything get(int i)
	{
		return null;
	}


	/**
	* Returns the object contained in this <code>Anything</code> object as is
	* (without conversion, copying or wrapping).
	*
	* @return		the contained object
	**/
	 public java.lang.Object toObject()
	{
		return null;
	}


	/**
	* Tries to return the value associated with a key from a map, which is contained
	* in this <code>Anything</code> object. If the
contained object is not an
	* objectof type <code>java.util.Map</code>, then an exception is thrown.
	* Otherwise,
<code>java.util.Map.get(key)</code> is applied to the map an the
	* result is returned.
	*
	* @param key 		 the key for which the associated value is to be retrieved
	* @return		the value associated with the key or <code>null</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public java.lang.Object getObject(java.lang.String key)
	{
		return null;
	}


	/**
	* Tries to return the value associated with a key from a map, which is contained
	* in this <code>Anything</code> object. If the
contained object is not an
	* objectof type <code>java.util.Map</code>, then an exception is thrown.
	* Otherwise, it is checked if a
value is associated with the given key and if
	* not <code>dflt</code> is returned. If an associated value exists, this value
	* is
returned as is.
	*
	* @param key 		 the key for which the associated value is to be retrieved
	* @param dflt 		 the value to be returned if no value is associated with the key
	* @return		the value associated with the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>.
	**/
	 public java.lang.Object getObject(java.lang.String key, java.lang.Object dflt)
	{
		return null;
	}


	/**
	* Tries to return the i-th element of a list or array contained in this
	* <code>Anything</code> object. In detail the process works as
follows:
	* <list>
<li>If the contained object is an array, then
	* <code>java.lang.Array.get(Object, int)</code> is used to access the i-th
	* element of
the array.
<li>If the contained object is not an object of type
	* <code>java.util.List</code>, then an exception is thrown.
<li>Otherwise the
	* i-th element of the list is retrieved and returned. This may throw an
	* <code>IndexOutOfBoundsException</code>,
if the i-th element does not exist.
	* </list>
	*
	* @param i 		 the i-th element to be retrieved from the contained list
	* @return		the i-th element wrapped in an <code>Anything</code> object
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code> and not an array
	* @throws		IndexOutOfBoundsException if the contained list does not contain an i-th element.
	**/
	 public java.lang.Object getObject(int i)
	{
		return null;
	}


	/**
	* A convenience method to access a <code>short</code> value of a
	* <code>java.lang.Short</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Short)toObject()).shortValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Short</code>
	**/
	 public short toShort()
	{
		return 0;
	}


	/**
	* A convenience method to access a <code>short</code> value of a
	* <code>java.lang.Short</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Short)getObject(key)).shortValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Short</code>
	**/
	 public short getShort(java.lang.String key)
	{
		return 0;
	}


	/**
	* A convenience method to access a <code>short</code> value of a
	* <code>java.lang.Short</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Short</code>
	* @return		the result of <code>((Short)getObject(key)).shortValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Short</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public short getShort(java.lang.String key, short dflt)
	{
		return 0;
	}


	/**
	* A convenience method to retrieve a <code>short</code> value of a
	* <code>java.lang.Short</code> object contained as an element in
	* a
<code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Short)getObject(index)).shortValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Short</code>
	**/
	 public short getShort(int index)
	{
		return 0;
	}


	/**
	* A convenience method to access an <code>int</code> value of a
	* <code>java.lang.Integer</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Integer)toObject()).intValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Integer</code>
	**/
	 public int toInt()
	{
		return 0;
	}


	/**
	* A convenience method to access an <code>int</code> value of a
	* <code>java.lang.Integer</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Integer)getObject(key)).intValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Integer</code>
	**/
	 public int getInt(java.lang.String key)
	{
		return 0;
	}


	/**
	* A convenience method to access an <code>int</code> value of a
	* <code>java.lang.Integer</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Integer</code>
	* @return		the result of <code>((Integer)getObject(key)).intValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Integer</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public int getInt(java.lang.String key, int dflt)
	{
		return 0;
	}


	/**
	* A convenience method to retrieve an <code>int</code> value of a
	* <code>java.lang.Integer</code> object contained as an element in
a
	* <code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Integer)getObject(index)).intValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Integer</code>
	**/
	 public int getInt(int index)
	{
		return 0;
	}


	/**
	* A convenience method to access a <code>long</code> value of a
	* <code>java.lang.Long</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Long)toObject()).longValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Long</code>
	**/
	 public long toLong()
	{
		return 0L;
	}


	/**
	* A convenience method to access a <code>long</code> value of a
	* <code>java.lang.Long</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Long)getObject(key)).longValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Long</code>
	**/
	 public long getLong(java.lang.String key)
	{
		return 0L;
	}


	/**
	* A convenience method to access a <code>long</code> value of a
	* <code>java.lang.Long</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Long</code>
	* @return		the result of <code>((Long)getObject(key)).longValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Long</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public long getLong(java.lang.String key, long dflt)
	{
		return 0L;
	}


	/**
	* A convenience method to retrieve a <code>long</code> value of a
	* <code>java.lang.Long</code> object contained as an element in
	* a
<code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Long)getObject(index)).longValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Long</code>
	**/
	 public long getLong(int index)
	{
		return 0L;
	}


	/**
	* A convenience method to access a <code>float</code> value of a
	* <code>java.lang.Float</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Float)toObject()).floatValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Float</code>
	**/
	 public float toFloat()
	{
		return 0.0f;
	}


	/**
	* A convenience method to access an <code>float</code> value of a
	* <code>java.lang.Float</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Float)getObject(key)).floatValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Float</code>
	**/
	 public float getFloat(java.lang.String key)
	{
		return 0.0f;
	}


	/**
	* A convenience method to access a <code>float</code> value of a
	* <code>java.lang.Float</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Float</code>
	* @return		the result of <code>((Float)getObject(key)).floatValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Float</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public float getFloat(java.lang.String key, float dflt)
	{
		return 0.0f;
	}


	/**
	* A convenience method to retrieve a <code>float</code> value of a
	* <code>java.lang.Float</code> object contained as an element in
	* a
<code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Float)getObject(index)).floatValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Float</code>
	**/
	 public float getFloat(int index)
	{
		return 0.0f;
	}


	/**
	* A convenience method to access a <code>double</code> value of a
	* <code>java.lang.Double</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Double)toObject()).doubleValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Double</code>
	**/
	 public double toDouble()
	{
		return 0.0d;
	}


	/**
	* A convenience method to access a <code>double</code> value of a
	* <code>java.lang.Double</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Double)getObject(key)).doubleValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Double</code>
	**/
	 public double getDouble(java.lang.String key)
	{
		return 0.0d;
	}


	/**
	* A convenience method to access a <code>double</code> value of a
	* <code>java.lang.Double</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Double</code>
	* @return		the result of <code>((Double)getObject(key)).doubleValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Double</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public double getDouble(java.lang.String key, double dflt)
	{
		return 0.0d;
	}


	/**
	* A convenience method to retrieve a <code>double</code> value of a
	* <code>java.lang.Double</code> object contained as an element in
a
	* <code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Double)getObject(index)).doubleValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Double</code>
	**/
	 public double getDouble(int index)
	{
		return 0.0d;
	}


	/**
	* A convenience method to access a <code>boolean</code> value of a
	* <code>java.lang.Boolean</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Boolean)toObject()).booleanValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Boolean</code>
	**/
	 public boolean toBoolean()
	{
		return false;
	}


	/**
	* A convenience method to access an <code>boolean</code> value of a
	* <code>java.lang.Boolean</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Boolean)getObject(key)).booleanValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Boolean</code>
	**/
	 public boolean getBoolean(java.lang.String key)
	{
		return false;
	}


	/**
	* A convenience method to access a <code>boolean</code> value of a
	* <code>java.lang.Boolean</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Boolean</code>
	* @return		the result of <code>((Boolean)getObject(key)).booleanValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Boolean</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public boolean getBoolean(java.lang.String key, boolean dflt)
	{
		return false;
	}


	/**
	* A convenience method to retrieve a <code>boolean</code> value of a
	* <code>java.lang.Boolean</code> object contained as an element
in a
	* <code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Boolean)getObject(index)).booleanValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Boolean</code>
	**/
	 public boolean getBoolean(int index)
	{
		return false;
	}


	/**
	* A convenience method to access a <code>char</code> value of a
	* <code>java.lang.Character</code> object contained in
	* this
<code>Anything</code> object.
	*
	* @return		the result of <code>((Character)toObject()).charValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Character</code>
	**/
	 public char toChar()
	{
		return 'a';
	}


	/**
	* A convenience method to access an <code>char</code> value of a
	* <code>java.lang.Character</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Character)getObject(key)).charValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type
<code>java.lang.Character</code>
	**/
	 public char getChar(java.lang.String key)
	{
		return 'a';
	}


	/**
	* A convenience method to access a <code>char</code> value of a
	* <code>java.lang.Character</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Character</code>
	* @return		the result of <code>((Character)getObject(key)).charValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Character</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public char getChar(java.lang.String key, char dflt)
	{
		return 'a';
	}


	/**
	* A convenience method to retrieve a <code>char</code> value of a
	* <code>java.lang.Character</code> object contained as an element
in a
	* <code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Character)getObject(index)).charValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Character</code>
	**/
	 public char getChar(int index)
	{
		return 'a';
	}


	/**
	* A convenience method to access a <code>byte</code> value of a
	* <code>java.lang.Byte</code> object contained in this
<code>Anything</code>
	* object.
	*
	* @return		the result of <code>((Byte)toObject()).byteValue()</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Byte</code>
	**/
	 public byte toByte()
	{
		return 0;
	}


	/**
	* A convenience method to access an <code>byte</code> value of a
	* <code>java.lang.Byte</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @return		the result of <code>((Byte)getObject(key)).byteValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @throws		ClassCastException if the object contained in this <code>Anything</code> object is not of type <code>java.lang.Byte</code>
	**/
	 public byte getByte(java.lang.String key)
	{
		return 0;
	}


	/**
	* A convenience method to access a <code>byte</code> value of a
	* <code>java.lang.Byte</code> object contained as a value in
	* a
<code>java.util.Map</code> object, whereby the map is itself contained in
	* this <code>Anything</code> object.
	*
	* @param key 		 the key for which the associated value is to be retrieved from the map
	* @param dflt 		 the value to be returned, if no value is bound to the key or if the value is not of type <code>java.lang.Byte</code>
	* @return		the result of <code>((Byte)getObject(key)).byteValue()</code>, in case <code>getObject(key)</code> returns a
<code>java.lang.Byte</code> object and <code>dflt</code> otherwise
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public byte getByte(java.lang.String key, byte dflt)
	{
		return 0;
	}


	/**
	* A convenience method to retrieve a <code>byte</code> value of a
	* <code>java.lang.Byte</code> object contained as an element in
	* a
<code>java.util.List</code> object, whereby the list is itself contained in
	* this <code>Anything</code> object.
	*
	* @param index 		 the index of the list element to be retrieved
	* @return		the result of <code>((Byte)getObject(index)).byteValue()</code>
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if the contained list does not contain an element with index <code>index</code>
	* @throws		ClassCastException if the retrieved list element is not of type <code>java.lang.Byte</code>
	**/
	 public byte getByte(int index)
	{
		return 0;
	}


	/**
	* Tries to return a value of a map contained in this <code>Anything</code>
	* object. The related value will be wrapped in an
<code>Anything</code> object
	* before it is returned. In detail the process works as follows: <list>
<li>If
	* the contained object is not an object of type <code>java.util.Map</code>,
	* thenan exception is thrown.
<li>Otherwise if the map does have value
	* associated with the key <code>key</code>, then <code>null</code> is returned.
	* </list>
<p/> If existing the value <code>e</code> is wrapped in an
	* <code>Anything</code> object as follows: <list>
<li> If the element
	* <code>e</code> is of type <code>String[]</code>, then the result of <code>new
	* Anything((String[])e)</code>
is returned.
<li> If the element <code>e</code>
	* is of type <code>int[]</code>, then the result of <code>new
	* Anything((int[])e)</code> is
returned.
<li> If the element <code>e</code> is
	* of type <code>double[]</code>, then the result of <code>new
	* Anything((double[])e)</code>
is returned.
<li> If the element <code>e</code>
	* is of type <code>int[][]</code>, then the result of <code>new
	* Anything((int[][])e)</code>
is returned.
<li> If the element <code>e</code>
	* isof type <code>Anything</code>, then <code>e</code> is returned as is.
<li>
	* Otherwise <code>new Anything((Object)e)</code> is returned. </list>
	*
	* @param key 		 the key for which a value is to be retrieved from the contained map
	* @return		the value associated with the key wrapped in an <code>Anything</code> object or <code>null</code> if no value is
associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @deprecated		Use {@link #getObject(String key)} instead.
	**/
	 public com.ulcjava.base.shared.internal.Anything get(java.lang.String key)
	{
		return null;
	}


	/**
	* Tries to return a <code>double</code> value of a map contained in this
	* <code>Anything</code> object. After retrieving the value
from the map via the
	* given key, the same conversion process as in {@link #asDouble(double)} is
	* applied and the result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @param dflt 		 the default value for the conversion process (same as <code>dflt</code> in {@link #asDouble(double)})
	* @return		the converted value for the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asDouble(double)
	* @deprecated		Use {@link #getDouble(String)} instead.
	**/
	 public double get(java.lang.String key, double dflt)
	{
		return 0.0d;
	}


	/**
	* Tries to return a <code>float</code> value of a map contained in this
	* <code>Anything</code> object. After retrieving the value
from the map via the
	* given key, the same conversion process as in {@link #asFloat(float)} is
	* applied and the result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @param dflt 		 the default value for the conversion process (same as <code>dflt</code> in {@link #asFloat(float)})
	* @return		the converted value for the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asFloat(float)
	* @deprecated		Use {@link #getFloat(String)} instead.
	**/
	 public float get(java.lang.String key, float dflt)
	{
		return 0.0f;
	}


	/**
	* Tries to return an <code>int</code> value of a map contained in this
	* <code>Anything</code> object. After retrieving the value
from the map via the
	* given key, the same conversion process as in {@link #asInt(int)} is applied
	* and the result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @param dflt 		 the default value for the conversion process (same as <code>dflt</code> in {@link #asInt(int)})
	* @return		the converted value for the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asInt(int)
	* @deprecated		Use {@link #getInt(String)} instead.
	**/
	 public int get(java.lang.String key, int dflt)
	{
		return 0;
	}


	/**
	* Tries to return a <code>long</code> value of a map contained in this
	* <code>Anything</code> object. After retrieving the value
from the map via the
	* given key, the same conversion process as in {@link #asLong(long)} is applied
	* and the result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @param dflt 		 the default value for the conversion process (same as <code>dflt</code> in {@link #asLong(long)})
	* @return		the converted value for the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asLong(long)
	* @deprecated		Use {@link #getLong(String)} instead.
	**/
	 public long get(java.lang.String key, long dflt)
	{
		return 0L;
	}


	/**
	* Tries to return a string value of a map contained in this
	* <code>Anything</code>object. After retrieving the value from the map via
the
	* given key, the same conversion process as in {@link #asString(String)} is
	* applied and the result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @param dflt 		 the default value for the conversion process (same as <code>dflt</code> in {@link #asString(String)})
	* @return		the converted value for the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asString(String)
	* @deprecated		Use {@link #getObject(String)} instead.
	**/
	 public java.lang.String get(java.lang.String key, java.lang.String dflt)
	{
		return null;
	}


	/**
	* Tries to return a <code>boolean</code> value of a map contained in this
	* <code>Anything</code> object. After retrieving the value
from the map via the
	* given key, the same conversion process as in {@link #asBoolean(boolean)} is
	* applied and the result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @param dflt 		 the default value for the conversion process (same as <code>dflt</code> in {@link #asBoolean(boolean)})
	* @return		the converted value for the key or <code>dflt</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asBoolean(boolean)
	* @deprecated		Use {@link #getBoolean(String)} instead.
	**/
	 public boolean get(java.lang.String key, boolean dflt)
	{
		return false;
	}


	/**
	* Tries to return a <code>byte[]</code> value of a map contained in this
	* <code>Anything</code> object. After retrieving the value
from the map via the
	* given key, the same conversion process as in {@link #asBytes()} is applied
	* andthe result is returned.
	*
	* @param key 		 the key to retrieve the value from the map
	* @return		the converted value for the key or <code>null</code> if no value is associated with the key
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @see		#asBytes()
	* @deprecated		Use {@link #getObject(String)} instead.
	**/
	 public byte[] getBytes(java.lang.String key)
	{
		return null;
	}


	/**
	* Detemine the type of the object contained in this <code>Anything</code> object.
	*
	* @return		The type such as indicated by one of the constants <code>NULL</code>, <code>BOOLEAN</code>, <code>LONG</code>,
<code>DOUBLE</code>, <code>STRING</code>, <code>BYTES</code>, <code>VECTOR</code>, <code>INT</code> and
<code>FLOAT</code>
	* @deprecated		Use {@link #toObject()} in combination with <code>instanceof</code> to determine the type of the contained object.
	**/
	 public int getType()
	{
		return 0;
	}


	/**
	* Checks whether value is bound to a key for a map potentially contained in this
	* <code>Anything</code> object.
	*
	* @param key 		 the key for the check
	* @return		<code>true</code> if an object of type <code>java.util.Map</code> is contained in this <code>Anything</code> object and
the map has associated a value with the given key, <code>false</code> otherwise
	**/
	 public boolean isDefined(java.lang.String key)
	{
		return false;
	}


	/**
	* Checks whether <code>null</code> is contained in this <code>Anything</code>
	* object.
	*
	* @return		<code>true</code> if <code>null</code> is contained, <code>false</code> otherwise
	**/
	 public boolean isNull()
	{
		return false;
	}


	/**
	* Checks whether an object of type <code>java.util.List</code> is contained in
	* this <code>Anything</code> object.
	*
	* @return		<code>true</code> if a list is contained, <code>false</code> otherwise
	**/
	 public boolean isList()
	{
		return false;
	}


	/**
	* Checks whether an object of type <code>java.util.Map</code> is contained in
	* this <code>Anything</code> object.
	*
	* @return		<code>true</code> if a list is contained, <code>false</code> otherwise
	**/
	 public boolean isMap()
	{
		return false;
	}


	/**
	* Checks whether an array object is contained in this <code>Anything</code>
	* object.
	*
	* @return		<code>true</code> if an array is contained, <code>false</code> otherwise
	**/
	 public boolean isArray()
	{
		return false;
	}


	/**
	* Returns an enumeration of all keys contained in the map of this
	* <code>Anything</code> object. Throws an exception if the object
contained in
	* this <code>Anything</code> object is not a map.
	*
	* @return		the enumeration of map keys
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @deprecated		Use {@link #keysIterator()} instead.
	**/
	 public java.util.Enumeration keys()
	{
		return null;
	}


	/**
	* Returns an iterator of all keys contained in the map of this
	* <code>Anything</code> object. Throws an exception if the object
contained in
	* this <code>Anything</code> object is not a map.
	*
	* @return		the iterator of map keys
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public java.util.Iterator keysIterator()
	{
		return null;
	}


	/**
	* Sets the object contained in an <code>Anything</code> object in the list which
	* is assumed to be contained in this
<code>Anything</code> object. If the list
	* has a size <code>s</code>, which is less than <code>index + 1</code>,
	* then
<code>index + 1 - s</code> <code>null</code> elements are added to the
	* end of the list. Afterwards the argument object is set is
at position
	* <code>index</code> of the list.
	*
	* @param value 		 the <code>Anything</code> object containing the object to be set
	* @param index 		 the position in the list where to set the object
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if <code>index</code> is negative
	* @deprecated		Use {@link #put(int, Object)} instead.
	**/
	 public void put(int index, com.ulcjava.base.shared.internal.Anything value)
	{
	}


	/**
	* Sets the argument object <code>value</code> in the list, which is assumed to
	* becontained in this <code>Anything</code> object.
If the list has a size
	* <code>s</code>, which is less than <code>index + 1</code>, then
<code>index +
	* 1 - s</code> <code>null</code> elements are added to the end of the list.
	* Afterwards the argument object is set is
at position <code>index</code> of
	* thelist.
	*
	* @param index 		 the position in the list where to set the object
	* @param value 		 the object to be set
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if <code>index</code> is negative
	**/
	 public void put(int index, java.lang.Object value)
	{
	}


	/**
	* Sets the argument object <code>value</code> in the list or array, which is
	* assumed to be contained in this <code>Anything</code>
object. The argument
	* object is set is at position <code>index</code> of the list or array.
	*
	* @param index 		 the position in the list where to set the object
	* @param value 		 the object to be set
	* @throws		IllegalArgumentException if this <code>Anything</code> object contains an array and if the array component type is
primitive and the specified value cannot be converted to the primitive type by a combination of unwrapping and identity
or widening conversions
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	* @throws		IndexOutOfBoundsException if <code>index</code> is negative or if the list size is less than <code>index + 1</code>
	**/
	 public void set(int index, java.lang.Object value)
	{
	}


	/**
	* Associates a <code>byte[]</code> array with a given key with respect to map,
	* which is contained in this <code>Anything</code>
object. If the contained
	* object is not an object of type <code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, a
copy of the array is bound to the key via
	* <code>java.util.Map.put(key, valueCopy)</code>.
	*
	* @param key 		 the key to associate the list with
	* @param value 		 the value, whose copy will be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, byte[] value)
	{
	}


	/**
	* Associates an <code>int[]</code> array converted to a list of
	* <code>java.lang.Integer</code> objects with a given key with
respect to a
	* map,which is contained in this <code>Anything</code> object. If the contained
	* object is not an object of type
<code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the array is converted to a list
	* of
<code>java.lang.Integer</code> objects. The resulting list has the type
	* <code>java.util.List</code> and is bound to the key
	* using
<code>java.util.Map.put(key,intList)</code>.
	*
	* @param key 		 the key to associate the list with
	* @param ints 		 the <code>int[]</code> array, whose conversion result will be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, int[] ints)
	{
	}


	/**
	* Associates an <code>int[][]</code> array converted to a list of lists of
	* <code>java.lang.Integer</code> objects with a given key
with respect to a
	* map,which is contained in this <code>Anything</code> object. If the contained
	* object is not an object of type
<code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the array is converted to a list of lists
	* of
<code>java.lang.Integer</code> objects. The resulting list has the type
	* <code>java.util.List</code> and is bound to the key
	* using
<code>java.util.Map.put(key,intSquareList)</code>.
	*
	* @param key 		 the key to associate the list with
	* @param ints 		 the <code>int[][]</code> array, whose conversion result will be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, int[][] ints)
	{
	}


	/**
	* Associates a <code>double</code> value with a given key with respect to a map,
	* which is contained in this <code>Anything</code>
object. If the contained
	* object is not an object of type <code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the
value is converted to a
	* <code>java.lang.Double</code> object and the result is bound to the key
	* using
<code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the value to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, double value)
	{
	}


	/**
	* Associates an <code>int</code> value with a given key with respect to a map,
	* which is contained in this <code>Anything</code>
object. If the contained
	* object is not an object of type <code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the
value is converted to a
	* <code>java.lang.Integer</code> object and the result is bound to the key
	* using<code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the value to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, int value)
	{
	}


	/**
	* Associates a <code>long</code> value with a given key with respect to a map,
	* which is contained in this <code>Anything</code>
object. If the contained
	* object is not an object of type <code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the
value is converted to a <code>java.lang.Long</code>
	* object and the result is bound to the key
	* using
<code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the value to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, long value)
	{
	}


	/**
	* Associates a <code>float</code> value with a given key with respect to a map,
	* which is contained in this <code>Anything</code>
object. If the contained
	* object is not an object of type <code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the
value is converted to a
	* <code>java.lang.Float</code>object and the result is bound to the key
	* using
<code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the value to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, float value)
	{
	}


	/**
	* Associates an object with a given key with respect to a map, which is
	* containedin this <code>Anything</code> object. If the
contained object is not
	* an object of type <code>java.util.Map</code>, then an exception is thrown.
	* Otherwise, the object is bound
to the key using
	* <code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the value to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, java.lang.Object value)
	{
	}


	/**
	* Associates an object wrapped in an <code>Anything</code> argument
	* <code>value</code> with a given key with respect to a map,
which is contained
	* in this <code>Anything</code> object. The wrapped object is unwrapped and
	* bound to the key using
<code>java.util.Map.put()</code>. If
	* <code>value</code>is <code>null</code> then <code>null</code> is bound to the
	* key.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the value to be bound wrapped in an <code>Anything</code> object
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @deprecated		Use {@link #put(String, Object)} instead.
	**/
	 public void put(java.lang.String key, com.ulcjava.base.shared.internal.Anything value)
	{
	}


	/**
	* Associates a list with a given key with respect to a map, which is contained
	* inthis <code>Anything</code> object. If the contained
object is not an object
	* of type <code>java.util.Map</code>, then an exception is thrown. Otherwise, a
	* flat copy of the list is
bound to the key using
	* <code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the value with
	* @param value 		 the list, whose copy is to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	* @deprecated		Use {@link #put(String, Object)} instead.
	**/
	 public void put(java.lang.String key, java.util.List value)
	{
	}


	/**
	* Associates a <code>boolean</code> value with a given key with respect to a
	* map,which is contained in this <code>Anything</code>
object. If the contained
	* object is not an object of type <code>java.util.Map</code>, then an exception
	* is thrown. Otherwise, the
value is converted to a
	* <code>java.lang.Boolean</code> object and the result is bound to the key
	* using<code>java.util.Map.put()</code>.
	*
	* @param key 		 the key to associate the list with
	* @param value 		 the value to be bound
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void put(java.lang.String key, boolean value)
	{
	}


	/**
	* Removes the element at position <code>index</code> from a list, which is
	* contained in this <code>Anything</code> object.
	* Uses
<code>java.util.List.remove(int)</code> to remove the element.
	*
	* @param index 		 the position of the element to be removed
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.List</code>
	**/
	 public void remove(int index)
	{
	}


	/**
	* Removes the key value association of the given key from a list, which is
	* contained in this <code>Anything</code> object.
	* Uses
<code>java.util.Map.remove(String)</code> to remove the association.
	*
	* @param key 		 the key, whose association is to be removed
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public void remove(java.lang.String key)
	{
	}


	/**
	* Returns the size of the object contained in this <code>Anything</code> object.
	*
	* @return		0 if this <code>Anything</code> object contains <code>null</code>, <code>java.util.List.size()</code> from the
contained object, if this <code>Anything</code> object contains a <code>java.util.List</code> object,
<code>java.util.Map.size()</code> from the contained object, if this <code>Anything</code> object contains a
<code>java.util.Map</code> object, <code>.length</code> from the contained object, if this <code>Anything</code> object
contains an array and 1 otherwise
	**/
	 public int size()
	{
		return 0;
	}


	/**
	* Returns a vector based on the object contained in this <code>Anything</code>
	* object. If the contained object is a list, a flat
vector copy of the list is
	* returned. If the contained object is a map, a vector containing the values of
	* the map is returned. If the
contained object is <code>null</code>, an empty
	* vector is returned. Otherwise a vector with one element - the contained
	* objectof
this <code>Anything</code> object - is returned.
	*
	* @return		the corresponding vector
	* @deprecated		Use {@link #toList()} instead.
	**/
	 public java.util.Vector toCollection()
	{
		return null;
	}


	/**
	* Returns a vector based on the object contained in this <code>Anything</code>
	* object. If the contained object is a list, a flat list
copy of the list is
	* returned. If the contained object is a map, a list containing the values of
	* the map is returned. If the contained
object is <code>null</code>, an empty
	* list is returned. Otherwise a list with one element - the contained object of
	* this
<code>Anything</code> object - is returned.
	*
	* @return		the corresponding list
	**/
	 public java.util.List toList()
	{
		return null;
	}


	/**
	* Returns a flat copy of the map which is supposed to be contained in this
	* <code>Anything</code> object.
	*
	* @return		the corresponding copied map
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code>
	**/
	 public java.util.Map toMap()
	{
		return null;
	}


	/**
	* Returns the contents of this <code>Anything</code> object in a human readable
	* format.
	*
	* @return		The string containing the readable contents of this <code>Anything</code> object. The result is identical to the result of
<code>print(false)</code>
	* @see		#print(boolean)
	**/
	 public java.lang.String toString()
	{
		return null;
	}


	/**
	* Returns the contents of this <code>Anything</code> object in a human readable
	* format.
	*
	* @param wrap 		 Whether to wrap lines for elements of container objects such as lists, arrays and maps. <code>true</code> means line
wrapping and containment indentation is enabled. <code>false</code> means no line breaks and no indentations are
inserted.
	* @return		The string containing the readable contents of this <code>Anything</code> object.
	**/
	 public java.lang.String print(boolean wrap)
	{
		return null;
	}


	/**
	* Returns an enumerator with elements wrapped by <code>Anything</code> objects,
	* whereby the elements are retrieved from the object
contained in this
	* <code>Anything</code> object. Returns an enumerator returning
	* <code>Anything</code> objects, whereby the latter
wrap the results of
	* <code>java.util.List.iterator()</code>, if the contained object is a list.
	* Returns an enumerator returning
<code>Anything</code> objects, whereby the
	* latter wrap the results of <code>java.util.Map.values().iterator()</code>, if
	* the
contained the contained object is a map.
	*
	* @return		the corresponding iterator
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code> or <code>java.util.List</code>
	* @deprecated		Use {@link #anythingValuesIterator()} instead.
	**/
	 public java.util.Enumeration values()
	{
		return null;
	}


	/**
	* Returns an iterator with elements wrapped by <code>Anything</code> objects,
	* whereby the elements are retrieved from the object
contained in this
	* <code>Anything</code> object. Returns an iterator returning
	* <code>Anything</code> objects, whereby the latter
wrap the results of
	* <code>java.util.List.iterator()</code>, if the contained object is a list.
	* Returns an iterator returning
<code>Anything</code> objects, whereby the
	* latter wrap the results of <code>java.util.Map.values().iterator()</code>, if
	* the
contained the contained object is a map.
	*
	* @return		the corresponding iterator
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code> or <code>java.util.List</code>
	**/
	 public java.util.Iterator anythingValuesIterator()
	{
		return null;
	}


	/**
	* Returns an iterator with elements retrieved from the the object contained in
	* this <code>Anything</code> object. Returns the result
of
	* <code>java.util.List.iterator()</code>, if the contained object is a list.
	* Returns the result of
<code>java.util.Map.values().iterator()</code>, if the
	* contained the contained object is a map.
	*
	* @return		the corresponding iterator
	* @throws		IllegalStateException if the object contained in this <code>Anything</code> object is not of type
<code>java.util.Map</code> or <code>java.util.List</code>
	**/
	 public java.util.Iterator valuesIterator()
	{
		return null;
	}

	 protected  static int[] asIntArray(java.util.List list, int dflt)
	{
		return null;
	}


}