package com.ulcjava.base.shared.internal;


	/**
	* Defines symbolic names for the control codes that may appear in an ULC data
	* stream.
	*
	* @ulc.internal		
	**/
 public  final class UlcStreamConstants extends java.lang.Object
{

	/**
	* Represents the value <code>null</code>.
	*
	**/
	 public  final  static byte NULL = 0;

	/**
	* Announces that the next stream element is a <code>Class</code>.
	*
	**/
	 public  final  static byte TC_CLASS = 0;

	/**
	* Announces that the next stream element is an array of <code>boolean</code>
	* values.
	*
	**/
	 public  final  static byte TC_BOOLEAN_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>byte</code> values.
	*
	**/
	 public  final  static byte TC_BYTE_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>char</code> values.
	*
	**/
	 public  final  static byte TC_CHAR_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>short</code> values.
	*
	**/
	 public  final  static byte TC_SHORT_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>int</code> values.
	*
	**/
	 public  final  static byte TC_INT_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>long</code> values.
	*
	**/
	 public  final  static byte TC_LONG_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>float</code> values.
	*
	**/
	 public  final  static byte TC_FLOAT_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of <code>double</code>
	* values.
	*
	**/
	 public  final  static byte TC_DOUBLE_ARRAY = 0;

	/**
	* Announces that the next stream element is an array of objects.
	*
	**/
	 public  final  static byte TC_OBJECT_ARRAY = 0;

	/**
	* Announces that the next stream element is an object written by a {@link
	* com.ulcjava.base.shared.IStreamCoder stream coder}.
	*
	**/
	 public  final  static byte TC_OBJECT = 0;

	/**
	* Announces that the next stream element is an string written by a {@link
	* com.ulcjava.base.shared.IStreamCoder stream coder}.
	*
	**/
	 public  final  static byte TC_STRING = 0;

	 private UlcStreamConstants()
	{
		 super();
	}


}