package com.ulcjava.base.shared.logging;


	/**
	* <code>SimpleLogManager</code> is a special implementation of
	* <code>LogManager</code> used in ULC. It logs everything to the same
logger
	* instance. To use <code>Logger</code> hierarchies one has to implement an own
	* <code>LogManager</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The log level for
	* the <code>Logger</code> can be specified.
<li>The print stream to which the
	* log output is printed can be specified.
<li>The message format of the log
	* output can be specified using the </code>java.text.MessageFormat</code>
	* class.</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
The following example shows how
	* to log in ULC using <code>SimpleLogManager</code>. First the instance of the
	* <code>Logger</code> is
accessed. Despite <code>SimpleLogManager</code> logs
	* everything to one logger, a suitable name (according to the package name)
	* should
be passed to enable the use with another log manager.

<pre>
private
	* static final Logger LOG =
	* Logger
.getLogger(&quot;com.ulcjava.developerguide.logging&quot;);
</pre>

Seco
	* nd logging statements need to be included in the
	* code.

<pre>
LOG.log(Level.INFO, &quot;log this action&quot;);
</pre>

The
	* output using the default message format will look as follows:

<pre>
Nr Date
	* Time Log Level
1 26.04.2005 21:15:23.469 800 INFO

Thread
Thread[ULC
	* Communication Controller Thread,5,main]

Class Name Method
	* Name
com.ulcjava.developerguide.logging.LoggerSnippet actionPerformed

Log
	* Message
log this action
</pre>

There is the possibility to customize the
	* output of the class and method names. An Object array with parameters can
	* alsobe passed to the
logger.

<pre>
LOG.log(Level.WARNING,
	* LoggerSnippet.class.getName(), &quot;createComponent&quot;,
&quot;log this
	* advanced message&quot;, new Object[] {&quot;Param&quot;});
</pre>

The output
	* on <code>System.out</code> looks as follows using the default message
	* format:<pre>
Nr Date Time Log Level
1 26.04.2005 21:15:23.469 800
	* INFO

ThreadThread[ULC Communication Controller Thread,5,main]

Class Name
	* Method Name
com.ulcjava.developerguide.logging.LoggerSnippet
	* createComponent

Log Message Parameters
log this advanced message
	* [Param]
</pre>

The following code snippet shows how the
	* <code>SimpleLogManager</code> can be configured. This configuration defines
	* that all logs with
<code>Level.INFO</code> and above should be printed out to
	* <code>System.out</code>.

<pre>
if (LogManager.getLogManager() instanceof
	* SimpleLogManager) {
SimpleLogManager manager =
	* (SimpleLogManager)LogManager
.getLogManager();
manager.setLevel(Level.INFO);
ma
	* nager.setLogStream(System.out);
}
</pre>
	*
	* @ulc.application		
	* @see		LogManager
	* @see		Logger
	**/
 public class SimpleLogManager extends com.ulcjava.base.shared.logging.LogManager
{

	/**
	* The default message format used for logging.
	*
	**/
	 public  final  static java.lang.String DEFAULT_MESSAGE_FORMAT = null;


	/**
	* Creates a SimpleLogManager with a simple logger and the default message
	* format.The log level is set to <code>Level.WARNING</code>
and the log output
	* is sent to System.err.
	*
	**/
	 public SimpleLogManager()
	{
		 super();
	}

	 protected com.ulcjava.base.shared.logging.SimpleLogManager$SimpleLogger createSimpleLogger()
	{
		return null;
	}

	 protected com.ulcjava.base.shared.logging.ISimpleLogConfigProvider createDefaultLogConfigProvider()
	{
		return null;
	}


	/**
	* Gets a logger. (The name is ignored for this implementation.)
	*
	* @param name 		 ignored argument
	**/
	 public com.ulcjava.base.shared.logging.Logger getLoggerFor(java.lang.String name)
	{
		return null;
	}


	/**
	* Sets the log level for the application.
	*
	* @param level 		 the level
	**/
	 public void setLevel(com.ulcjava.base.shared.logging.Level level)
	{
	}


	/**
	* Gets the log level set for the application.
	*
	* @return		the log level.
	**/
	 public com.ulcjava.base.shared.logging.Level getLevel()
	{
		return null;
	}


	/**
	* Sets the print stream of this Logger.
	*
	* @param logStream 		 the print stream of this logger
	**/
	 public void setLogStream(java.io.PrintStream logStream)
	{
	}


	/**
	* Sets the message format used in the log messages.
	*
	* @param messageFormat 		 the specified message format.
	**/
	 public void setMessageFormat(java.text.MessageFormat messageFormat)
	{
	}


	/**
	* Sets the object, which provides a logging configuration. The logging
	* configuration determines how (e.g. on what level) the log
manager logs
	* messages.
	*
	* @param provider 		 the logging provider
	* @ulc.extension		
	**/
	 public void setLogConfigProvider(com.ulcjava.base.shared.logging.ISimpleLogConfigProvider provider)
	{
	}


	/**
	* Gets the current loggin configuration. The logging configuration is obtained
	* via the logging provider set by means of
{@link
	* #setLogConfigProvider(ISimpleLogConfigProvider)}.
	*
	* @return		the logging configuration
	* @ulc.extension		
	**/
	 public com.ulcjava.base.shared.logging.SimpleLogConfig getLogConfig()
	{
		return null;
	}


	/**
	* The default log config provider. It provides an (unchanged) log config object
	* created via {@link #createLogConfig()}.
	*
	* @see		SimpleLogConfig
	* @ulc.extension		
	**/
 public  static class DefaultSimpleLogConfigProvider extends java.lang.Object implements java.io.Serializable, com.ulcjava.base.shared.logging.ISimpleLogConfigProvider
{

	 public DefaultSimpleLogConfigProvider()
	{
		 super();
	}


	/**
	* Creates a default log configuation using {@link
	* SimpleLogConfig#SimpleLogConfig()}.
	*
	* @return		the created log configuration
	**/
	 protected com.ulcjava.base.shared.logging.SimpleLogConfig createLogConfig()
	{
		return null;
	}


	/**
	* Gets the logging configuration.
	*
	* @return		an instance of {@link SimpleLogConfig} constructed via {@link #createLogConfig()}
	**/
	 public com.ulcjava.base.shared.logging.SimpleLogConfig getLogConfig()
	{
		return null;
	}


} protected class SimpleLogger extends com.ulcjava.base.shared.logging.Logger
{

	 public SimpleLogger()
	{
		 super();
	}

	 public void entering(java.lang.String className, java.lang.String methodName)
	{
	}

	 public void entering(java.lang.String className, java.lang.String methodName, java.lang.Object param)
	{
	}

	 public void entering(java.lang.String className, java.lang.String methodName, java.lang.Object[] params)
	{
	}

	 public void exiting(java.lang.String className, java.lang.String methodName)
	{
	}

	 public void exiting(java.lang.String className, java.lang.String methodName, java.lang.Object result)
	{
	}

	 public void throwing(java.lang.String className, java.lang.String methodName, java.lang.Throwable thrown)
	{
	}

	 public void severe(java.lang.String msg)
	{
	}

	 public void warning(java.lang.String msg)
	{
	}

	 public void info(java.lang.String msg)
	{
	}

	 public void config(java.lang.String msg)
	{
	}

	 public void fine(java.lang.String msg)
	{
	}

	 public void finer(java.lang.String msg)
	{
	}

	 public void finest(java.lang.String msg)
	{
	}

	 public void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg)
	{
	}

	 public void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg, java.lang.Object param1)
	{
	}

	 public void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg, java.lang.Object[] params)
	{
	}

	 public void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg, java.lang.Throwable thrown)
	{
	}

	 public void log(com.ulcjava.base.shared.logging.Level level, java.lang.String className, java.lang.String methodName, java.lang.String msg, java.lang.Object[] params)
	{
	}

	 public com.ulcjava.base.shared.logging.Level getLevel()
	{
		return null;
	}

	 public void setLevel(com.ulcjava.base.shared.logging.Level level)
	{
	}


}
}