package com.ulcjava.base.shared.streamcoder;


	/**
	* A {@link IStreamCoder stream coder} for marshalling ULC objects, which
	* implement {@link java.io.Serializable}, to and from ULC data
streams.
	*
	* @ulc.extension		
	**/
 public class SerializationCoder extends java.lang.Object implements com.ulcjava.base.shared.IStreamCoder
{


	/**
	* Creates a coder instance for a serializable class. The resulting coder applies
	* Java's standard serialization mechanism to encode and
decode instances of the
	* serializable class.
	*
	* @param serializableClass 		 the serializable class, for which this coder instance provides encoding and decoding
	* @throws		IllegalArgumentException if given class does not implement the {@link Serializable} interaface.
	**/
	 public SerializationCoder(java.lang.Class serializableClass)
	{
		 super();
	}


	/**
	* Returns the full name of the serializable class, for which this coder was
	* constructed.
	*
	* @see		IStreamCoder#getPeerClassName()
	**/
	 public java.lang.String getPeerClassName()
	{
		return null;
	}


	/**
	* Writes the given object (which must be an instance of the serializable class,
	* for which this coder was constructed) to the stream.
	*
	* @see		IStreamCoder#writeObject(com.ulcjava.base.shared.IObjectOutputStream,Object)
	**/
	 public java.lang.Object readObject(com.ulcjava.base.shared.IObjectInputStream in)throws java.io.IOException
	{
		return null;
	}


	/**
	* Returns a fresh instance of the serializable class, for which this coder was
	* constructed, from the stream data.
	*
	* @see		IStreamCoder#readObject(com.ulcjava.base.shared.IObjectInputStream)
	**/
	 public void writeObject(com.ulcjava.base.shared.IObjectOutputStream out, java.lang.Object data)
	{
	}


}