package com.ulcjava.container.servlet.application;


	/**
	* The ULC servlet container adapter offers an API to access servlet container
	* specific runtime information. For instance, this API can be
used to access
	* theunderlying HttpSession object that a ULC application session resides in.
	* Using this approach, HTML-ULC multichannel
applications can be written to
	* present the same session data simultaneously in the ULC application client
	* andin a web browser.
<p>
</p>
<b>Features</b>
<p>
</p>
The
	* com.ulcjava.container.servlet.application.ServletContainerContext class
	* provides access to the following information:
<ul>
<li>The
	* javax.servlet.http.HttpSession object the ULC application session resides
	* in.</li>
<li>The javax.servlet.ServletContext object corresponding to the web
	* application that the ULC servlet container adapter was configured
to be part
	* of.</li>
<li>The HTTP servlet request and response object of the current
	* server roundtrip.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following example
	* shows a servlet displaying a session attribute and a ULC application that
	* changes the same attribute directly in
the HttpSession object. At deployment
	* time it must be ensured that both the servlet and the ULC application (i.e.,
	* the servlet container
adapter servlet) share the same session. More
	* specifically, they must be part of the same web application and it must be
	* ensured that
session tracking information is sustained between the UI Engine
	* (running as applet) connecting to the servlet engine and the
	* servlet
renderingthe HTML page. The displaying servlet can be implemented as
	* follows:

<pre>
public class MultiChannelServlet extends HttpServlet
	* {
protected void doGet(HttpServletRequest httpRequest,
HttpServletResponse
	* httpResponse) throws IOException
	* {
httpResponse.setContentType(&quot;text/html&quot;);
PrintWriter out =
	* httpResponse.getWriter();
out.println(&quot;&lt;HTML&gt;&lt;BODY&gt;&quot;);
ou
	* t.println(&quot;Text: &quot;
+
	* httpRequest.getSession().getAttribute(&quot;text&quot;));
out.println(&quot;&lt
	* ;/BODY&gt;&lt;/HTML&gt;&quot;);
}
}
</pre>

Using the ServletContainerContext
	* class, the ULC application can directly access the attributes of the
	* HttpSession that the application
is running in:

<pre>
public class
	* MultiChannelApplication extends AbstractApplication {
private ULCTextField
	* fField;

public void start() {
ULCAppletPane contentPane =
	* ULCAppletPane.getInstance();
ULCBoxPane boxPane = new
	* ULCBoxPane(true);
Stringtext =
	* (String)ServletContainerContext.getHttpSession()
.getAttribute(&quot;text&quot;
	* );
fField = new ULCTextField(text, 20);
boxPane.add(fField);
ULCButton
	* saveButton = new
	* ULCButton(&quot;Save&quot;);
saveButton.addActionListener(newIActionListener()
	* {
public void actionPerformed(ActionEvent event)
	* {
ServletContainerContext.getHttpSession().setAttribute(
&quot;text&quot;,
	* fField.getText());
}
});
boxPane.add(saveButton);
contentPane.add(boxPane);
con
	* tentPane.setVisible(true);
}
}
</pre>
	*
	* @ulc.extension		
	**/
 public class ServletContainerContext extends java.lang.Object
{

	 private ServletContainerContext()
	{
		 super();
	}


	/**
	* Returns the HTTP servlet request for the current server roundtrip.
	*
	* @return		the HTTP servlet request for the current server roundtrip
	**/
	 public  static javax.servlet.http.HttpServletRequest getRequest()
	{
		return null;
	}


	/**
	* Returns the HTTP servlet response for the current server roundtrip.
	*
	* @return		the HTTP servlet response for the current server roundtrip
	**/
	 public  static javax.servlet.http.HttpServletResponse getResponse()
	{
		return null;
	}


	/**
	* Returns the servlet configuration of the ULC application.
	*
	* @return		the servlet configuration of the ULC application
	**/
	 public  static javax.servlet.ServletConfig getServletConfig()
	{
		return null;
	}


	/**
	* Returns the servlet context of the ULC application
	*
	* @return		the servlet context of the ULC application
	**/
	 public  static javax.servlet.ServletContext getServletContext()
	{
		return null;
	}


	/**
	* Returns the HTTP session of the ULC application.
	*
	* @return		the HTTP session of the ULC application
	**/
	 public  static javax.servlet.http.HttpSession getHttpSession()
	{
		return null;
	}


}