/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.applet.client; import com.ulcjava.base.shared.internal.VersionInfo;

import com.ulcjava.base.client.ClientEnvironmentAdapter;
import com.ulcjava.base.client.IConnector;
import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.UISession;
import com.ulcjava.base.client.launcher.DefaultSessionStateListener;
import com.ulcjava.base.client.launcher.ErrorDialog;
import com.ulcjava.base.shared.ClientEnvironmentConstants;

import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

import javax.swing.JApplet;

/**
 * @ulc.application
 */
public abstract class AbstractAppletLauncher extends JApplet implements ISessionStateListener { static {VersionInfo.addVersionInfo(AbstractAppletLauncher.class, "build.3670");}
    /**
     * @ulc.extension
     */
    public static final String USER_PARAMETER_NAMES_KEY = "user-parameter-names";
    
    /**
     * @ulc.extension
     */
    public static final String PARAMETER_DEFINITION_DELIMITER = ",";
    
    private static Map sAppletsBySession = new WeakHashMap();
    
    private UISession fSession;
    
    
    /**
     * @ulc.extension
     */
    protected AbstractAppletLauncher() {
    }
    
    /**
     * @ulc.extension
     */
    protected abstract IConnector createConnector();
    
    /**
     * @ulc.extension
     */
    public static void registerApplet(UISession session, JApplet applet) {
        sAppletsBySession.put(session, applet);
    }
    
    /**
     * @ulc.extension
     */
    public static void unregisterApplet(JApplet applet) {
        sAppletsBySession.values().remove(applet);
    }
    
    /**
     * @ulc.extension
     */
    public static JApplet getApplet() {
        return (JApplet)sAppletsBySession.get(UISession.currentSession());
    }
    
    /**
     * @ulc.extension
     */
    protected UISession getSession() {
        return fSession;
    }
    
    /**
     * @ulc.extension
     */
    public void init() {
        ClientEnvironmentAdapter.setBrowserService(new AppletBrowserService());
        ClientEnvironmentAdapter.getClientInfo().setClientEnvironmentType(ClientEnvironmentConstants.APPLET);
    }
    
    /**
     * @ulc.extension
     */
    public void start() {
        IConnector connector = createConnector();
        fSession = new UISession(connector, extractParameters(USER_PARAMETER_NAMES_KEY));
        registerApplet(getSession(), this);
        
        fSession.addSessionStateListener(createSessionStateListener());
        fSession.addSessionStateListener(this);
        getSession().start();
    }
    
    /**
     * Creates an instance of {@link com.ulcjava.base.client.launcher.DefaultSessionStateListener}. Use this method to customize
     * <code>ISessionStateListener</code> implementation.
     * 
     * @ulc.extension
     */
    protected ISessionStateListener createSessionStateListener() {
        return new DefaultSessionStateListener();
    }
    
    /**
     * @ulc.extension
     */
    public void stop() {
        getSession().sendStopApplicationAndWait();
        unregisterApplet(this);
    }
    
    /**
     * @ulc.extension
     * @deprecated As of ULC 6.2, use {@link #createSessionStateListener()}
     */
    public void sessionEnded(UISession session) {
    }
    
    /**
     * @ulc.extension
     * @deprecated As of ULC 6.2, use {@link #createSessionStateListener()}
     */
    public void sessionStarted(UISession session) {
    }
    
    /**
     * @ulc.extension
     * @deprecated As of ULC 6.2, use {@link #createSessionStateListener()}
     */
    public void sessionError(UISession session, Throwable reason) {
    }
    
    /**
     * @ulc.extension
     */
    public static void showMessageDialog(String windowTitle, String message, Throwable reason) {
        new ErrorDialog(windowTitle, message, reason).show();
    }
    
    /**
     * @ulc.extension
     */
    public static void showMessageDialog(String windowTitle, String message, String reason) {
        new ErrorDialog(windowTitle, message, reason).show();
    }
    
    private Properties extractParameters(String parametersDefinitionKey) {
        Properties result = new Properties();
        String parametersDefinition = getParameter(parametersDefinitionKey);
        
        if (parametersDefinition == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(parametersDefinition, PARAMETER_DEFINITION_DELIMITER);
        
        while (tokenizer.hasMoreTokens()) {
            String parameterName = tokenizer.nextToken();
            result.setProperty(parameterName, getParameter(parameterName));
        }
        return result;
    }
    
    /**
     * @ulc.extension
     */
    public String[][] getParameterInfo() {
        return new String[][] {{USER_PARAMETER_NAMES_KEY, "String",
                "comma-separated list of names of all user parameters (e.g., 'userName,id')"}};
    }
    
    /**
     * @ulc.extension
     */
    public void sendMessage(String message) {
        getSession().sendMessage(message);
    }
}