/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.applet.development; import com.ulcjava.base.shared.internal.VersionInfo;

import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.UISession;
import com.ulcjava.base.development.DevelopmentConnector;
import com.ulcjava.base.development.DevelopmentRunner;
import com.ulcjava.environment.applet.client.AbstractAppletLauncher;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

/**
 * This class is like <code>DevelopmentRunner</code> except that it allows you to run ULC applets in standalone offline mode in the
 * development environment. It requires that the top-level container of your ULC application is a <code>>ULCAppletPane</code>.
 * <code>AppletDevelopmentRunner</code> runs both the ULC client and the ULC application within a single JVM. It can be run like a
 * standalone Java application and it should not be run as an Applet.
 * 
 * @ulc.extension
 * @see DevelopmentRunner
 */
public class AppletDevelopmentRunner extends DevelopmentRunner { static {VersionInfo.addVersionInfo(AppletDevelopmentRunner.class, "build.3670");}
    private static int sAppletWidth = 400;
    private static int sAppletHeight = 400;
    
    public static void run() {
        DevelopmentRunner.checkApplicationClass();
        sConnector = new DevelopmentConnector(getSessionProvider(), getDataStreamProviderClassName(), getCarrierStreamProviderClassName(),
                getClientRegistryProviderClassName(), getServerRegistryProviderClassName(), getConnectionType());
        sClientSession = createSession(sConnector, sUserParameters);
        sClientSession.addSessionStateListener(new ISessionStateListener() {
            public void sessionStarted(UISession session) throws Exception {
            }
            
            public void sessionError(UISession session, Throwable reason) {
            }
            
            public void sessionEnded(UISession session) throws Exception {
                sConnector = null;
                sClientSession = null;
            }
        });
        AppletDevelopmentRunner.installAppletPane(sClientSession);
        sClientSession.start();
    }
    
    public static void setAppletSize(int appletWidth, int appletHeight) {
        sAppletWidth = appletWidth;
        sAppletHeight = appletHeight;
    }
    
    private static void installAppletPane(UISession session) {
        JApplet applet = new JApplet();
        JComponent contentPane = (JComponent)applet.getContentPane();
        contentPane.setPreferredSize(new Dimension(sAppletWidth, sAppletHeight));
        
        AbstractAppletLauncher.registerApplet(session, applet);
        
        JLabel appletFrameLabel = new JLabel("Embedded Applet Viewer");
        appletFrameLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory
                .createEmptyBorder(2, 4, 1, 4)));
        
        JFrame appletFrame = new JFrame("Embedded Applet Viewer");
        appletFrame.setDefaultCloseOperation(3);
        
        appletFrame.getContentPane().add(applet, BorderLayout.CENTER);
        appletFrame.getContentPane().add(appletFrameLabel, BorderLayout.SOUTH);
        
        appletFrame.pack();
        appletFrame.pack(); // the second pack() is due to AWT bug 4511106
        // (http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4511106)
        appletFrame.setVisible(true);
    }
    
    public static void main(String[] args) {
        DevelopmentRunner.parseMainArgs(args);
        AppletDevelopmentRunner.run();
    }
}
