package com.ulcjava.testframework;


	/**
	* <code>TestContext</code> provides access to the test context.
<p
	* />
<b>Examples</b>
<p />
The following example runs a piece of code inside
	* thetest context that returns no result:
<p />

<pre>
TestContext context =
	* TestContext.getInstance();
context.runVoidCommand(new TestCommand()
	* {
protected void proceed() {
Runtime.getRuntime().gc();
}
});
</pre>

<p
	* />
The following example runs a piece of code inside the test context that
	* returns a <code>String</code>:
<p />

<pre>
TestContext context =
	* TestContext.getInstance();
String name = (String)context.runObjectCommand(new
	* TestCommand() {
protected void proceed()
	* {
setResult(Thread.currentThread().getName());
}
});
</pre>

<p />
The
	* following example runs a piece of code inside the test context that throws an
	* exception:
<p />

<pre>
TestContext context = TestContext.getInstance();
try
	* {context.runVoidCommand(new TestCommand() {
protected void proceed() throws
	* IOException {
throw new IOException();
}
});
} catch (ProceedException e)
	* {
IOException cause = (IOException)e.getCause();
}
</pre>
	*
	* @see		TestCommand
	* @see		ProceedException
	**/
 public class TestContext extends java.lang.Object
{

	 private TestContext()
	{
		 super();
	}


	/**
	* Returns the text context.
	*
	* @return		the text context
	**/
	 public  static com.ulcjava.testframework.TestContext getInstance()
	{
		return null;
	}


	/**
	* Runs the given command in the test context.
	*
	* @param command 		 the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public void runVoidCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>boolean</code>.
	*
	* @param command 		 the test command
	* @return		the boolean result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public boolean runBooleanCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return false;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>byte</code>.
	*
	* @param command 		 the test command
	* @return		the byte result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public byte runByteCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>char</code>.
	*
	* @param command 		 the test command
	* @return		the char result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public char runCharCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 'a';
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>short</code>.
	*
	* @param command 		 the test command
	* @return		the short result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public short runShortCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>int</code>.
	*
	* @param command 		 the test command
	* @return		the int result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public int runIntCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>long</code>.
	*
	* @param command 		 the test command
	* @return		the long result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public long runLongCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0L;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>float</code>.
	*
	* @param command 		 the test command
	* @return		the float result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public float runFloatCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0.0f;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>double</code>.
	*
	* @param command 		 the test command
	* @return		the double result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public double runDoubleCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0.0d;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>Object</code>.
	*
	* @param command 		 the test command
	* @return		the Object result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public java.lang.Object runObjectCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return null;
	}


	/**
	* Returns the current IServerTestEnvironmentAdapter which is set by the executed
	* test case.
	*
	* @return		the current server environment adapter
	**/
	 public  static com.ulcjava.testframework.IServerTestEnvironmentAdapter currentServerTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Sets the current IServerTestEnvironmentAdapter which is provided by the
	* currently executed test case.
	*
	* @param serverTestEnvironmentAdapter 		 the IServerTestEnvironmentAdapter, provided by the test case
	**/
	 public  static void setCurrentServerTestEnvironmentAdapter(com.ulcjava.testframework.IServerTestEnvironmentAdapter serverTestEnvironmentAdapter)
	{
	}


	/**
	* Returns the current IServerTestEnvironmentAdapter which is set by the executed
	* test case
	*
	* @return		the current IServerTestEnvironmentAdapter
	**/
	 public  static com.ulcjava.testframework.IClientTestEnvironmentAdapter currentClientTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Sets the current IClientTestEnvironmentAdapter which is provided by the
	* currently executed test case
	*
	* @param clientTestEnvironmentAdapter 		 the IClientTestEnvironmentAdapter, provided by the test case
	**/
	 public  static void setCurrentClientTestEnvironmentAdapter(com.ulcjava.testframework.IClientTestEnvironmentAdapter clientTestEnvironmentAdapter)
	{
	}


	/**
	* Sets the currently executed test case
	*
	* @param		testCase
	**/
	 protected  static void setCurrentTestCase(com.ulcjava.testframework.AbstractTestCase testCase)
	{
	}


	/**
	* Returns the currently executed test case
	*
	* @return		the test case
	**/
	 protected  static com.ulcjava.testframework.AbstractTestCase currentTestCase()
	{
		return null;
	}


	/**
	* Returns the currently active UI session. If more then one session is active, a
	* IllegalStateException is thrown.
	*
	* @return		active UI sessions
	* @throw		IlligalStateException if more then one UI session is active
	**/
	 public  static com.ulcjava.base.client.UISession getActiveSession()
	{
		return null;
	}


}