package com.ulcjava.testframework.development;


	/**
	* Abstract base class for all test cases that rely on the development runner
	* environment.
	*
	**/
 public  abstract class AbstractDevelopmentTestCase extends com.ulcjava.testframework.AbstractIntegratedTestCase
{


	/**
	* Creates a development test case with no name and a default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractDevelopmentTestCase()
	{
		 super();
	}


	/**
	* Creates a development test case with no name and the specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractDevelopmentTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a development test case with the specified name and a default max fail
	* count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractDevelopmentTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a development test case with the specified name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractDevelopmentTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}


	/**
	* 
	*
	* @deprecated		use configure(DevelopmentTestEnvironmentAdapter adapter) to customize the DevelopmentTestEnvironmentAdapter
	**/
	 protected  final com.ulcjava.testframework.IClientTestEnvironmentAdapter createClientTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		use configure(DevelopmentTestEnvironmentAdapter adapter) to customize the DevelopmentTestEnvironmentAdapter
	**/
	 protected  final com.ulcjava.testframework.IServerTestEnvironmentAdapter createServerTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Factory method that creates the development test environment adapter.
	*
	* @deprecated		use configure(DevelopmentTestEnvironmentAdapter adapter) to customize the DevelopmentTestEnvironmentAdapter
	* @return		the development test environment adapter
	**/
	 protected com.ulcjava.testframework.development.DevelopmentTestEnvironmentAdapter createDevelopmentTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* overwrite in subclasses to configure the DevelopmentTestEnvironmentAdapter
	* withfor example own Launchers etc.
	*
	* @param adapter 		 the DevelopmentTestEnvironmentAdapter to be configured
	**/
	 protected void configure(com.ulcjava.testframework.development.DevelopmentTestEnvironmentAdapter adapter)
	{
	}


}