package com.ulcjava.testframework.jnlp;


	/**
	* Abstract base class for all test cases that rely on the JNLP and remote server
	* test environment.
	*
	**/
 public  abstract class AbstractJnlpRemoteServerTestCase extends com.ulcjava.testframework.AbstractRemoteTestCase
{


	/**
	* Creates a JNLP test case that connects to a remote server with no name and a
	* default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractJnlpRemoteServerTestCase()
	{
		 super();
	}


	/**
	* Creates a JNLP test case that connects to a remote server with no name and the
	* specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractJnlpRemoteServerTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a JNLP test case that connects to a remote server with the specified
	* name and a default max fail count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractJnlpRemoteServerTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a JNLP test case that connects to a remote server with the specified
	* name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractJnlpRemoteServerTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}


	/**
	* 
	*
	* @deprecated		use configure(JnlpTestEnvironmentAdapter clientAdapter) to customize the JnlpTestEnvironmentAdapter
	**/
	 protected  final com.ulcjava.testframework.IClientTestEnvironmentAdapter createClientTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Factory method that creates the JNLP test environment adapter.
	*
	* @deprecated		use configure(JnlpTestEnvironmentAdapter clientAdapter) to customize the JnlpTestEnvironmentAdapter
	* @param urlString 		 the URL string of the remote UltraLightClient application
	* @return		the JNLP test environment adapter
	**/
	 protected com.ulcjava.testframework.jnlp.JnlpTestEnvironmentAdapter createJnlpTestEnvironmentAdapter(java.lang.String urlString)
	{
		return null;
	}


	/**
	* overwrite in subclasses to configure the Jnlp ClientTestEnvironmentAdapter
	* withfor example own Launchers etc.
	*
	* @param clientAdapter 		 the JnlpTestEnvironmentAdapter to be configured
	**/
	 protected void configure(com.ulcjava.testframework.jnlp.JnlpTestEnvironmentAdapter clientAdapter)
	{
	}


}