package com.ulcjava.testframework.jnlp;


	/**
	* Abstract base class for all test cases that rely on the JNLP and Servlet test
	* environment.
	*
	**/
 public  abstract class AbstractJnlpTestCase extends com.ulcjava.testframework.AbstractServletTestCase
{


	/**
	* Creates a JNLP test case with no name and a default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractJnlpTestCase()
	{
		 super();
	}


	/**
	* Creates a JNLP test case with no name and the specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractJnlpTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a JNLP test case with the specified name and a default max fail count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractJnlpTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a JNLP test case with the specified name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractJnlpTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}


	/**
	* overwrite in subclasses to configure the JnlpTestEnvironmentAdapter with for
	* example own Launchers etc.
	*
	* @param clientAdapter 		 the JnlpTestEnvironmentAdapter to be configured
	**/
	 protected void configure(com.ulcjava.testframework.jnlp.JnlpTestEnvironmentAdapter clientAdapter)
	{
	}


	/**
	* 
	*
	* @deprecated		use configure(JnlpTestEnvironmentAdapter clientAdapter) to customize the JnlpTestEnvironmentAdapter
	**/
	 protected  final com.ulcjava.testframework.IClientTestEnvironmentAdapter createClientTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Factory method that creates the JNLP test environment adapter.
	*
	* @deprecated		use configure(JnlpTestEnvironmentAdapter clientAdapter) to customize the JnlpTestEnvironmentAdapter
	* @return		the JNLP test environment adapter
	**/
	 protected com.ulcjava.testframework.jnlp.JnlpTestEnvironmentAdapter createJnlpTestEnvironmentAdapter()
	{
		return null;
	}


}