/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.util.DeclarationFilter;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.declaration.AnnotationProxyMaker;
import com.sun.tools.apt.mirror.declaration.DeclarationMaker;
import com.sun.tools.apt.mirror.util.SourcePositionImpl;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeclarationImpl
implements Declaration {
    protected final AptEnv env;
    public final Symbol sym;
    protected static DeclarationFilter identityFilter = new DeclarationFilter();
    private EnumSet<Modifier> modifiers = null;
    private Collection<Symbol> members = null;

    protected DeclarationImpl(AptEnv aptEnv, Symbol symbol) {
        this.env = aptEnv;
        this.sym = symbol;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DeclarationImpl) {
            DeclarationImpl declarationImpl = (DeclarationImpl)object;
            return this.sym == declarationImpl.sym && this.env == declarationImpl.env;
        }
        return false;
    }

    public int hashCode() {
        return this.sym.hashCode() + this.env.hashCode();
    }

    @Override
    public String getDocComment() {
        Env<AttrContext> env = this.getEnterEnv();
        if (env == null) {
            return null;
        }
        Tree tree = TreeInfo.declarationFor(this.sym, env.tree);
        return env.toplevel.docComments.get(tree);
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        ArrayList<AnnotationMirror> arrayList = new ArrayList<AnnotationMirror>();
        for (Attribute.Compound compound : this.sym.attributes()) {
            arrayList.add(this.env.declMaker.getAnnotationMirror(compound, this));
        }
        return arrayList;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.getAnnotation(clazz, this.sym);
    }

    protected <A extends Annotation> A getAnnotation(Class<A> clazz, Symbol symbol) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + clazz);
        }
        String string = clazz.getName();
        for (Attribute.Compound compound : symbol.attributes()) {
            if (!string.equals(compound.type.tsym.flatName().toString())) continue;
            return AnnotationProxyMaker.generateAnnotation(this.env, compound, clazz);
        }
        return null;
    }

    @Override
    public Collection<Modifier> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = EnumSet.noneOf(Modifier.class);
            long l = AptEnv.getFlags(this.sym);
            if (0L != (l & 1L)) {
                this.modifiers.add(Modifier.PUBLIC);
            }
            if (0L != (l & 4L)) {
                this.modifiers.add(Modifier.PROTECTED);
            }
            if (0L != (l & 2L)) {
                this.modifiers.add(Modifier.PRIVATE);
            }
            if (0L != (l & 0x400L)) {
                this.modifiers.add(Modifier.ABSTRACT);
            }
            if (0L != (l & 8L)) {
                this.modifiers.add(Modifier.STATIC);
            }
            if (0L != (l & 0x10L)) {
                this.modifiers.add(Modifier.FINAL);
            }
            if (0L != (l & 0x80L)) {
                this.modifiers.add(Modifier.TRANSIENT);
            }
            if (0L != (l & 0x40L)) {
                this.modifiers.add(Modifier.VOLATILE);
            }
            if (0L != (l & 0x20L)) {
                this.modifiers.add(Modifier.SYNCHRONIZED);
            }
            if (0L != (l & 0x100L)) {
                this.modifiers.add(Modifier.NATIVE);
            }
            if (0L != (l & 0x800L)) {
                this.modifiers.add(Modifier.STRICTFP);
            }
        }
        return this.modifiers;
    }

    @Override
    public String getSimpleName() {
        return this.sym.name.toString();
    }

    @Override
    public SourcePosition getPosition() {
        Env<AttrContext> env = this.getEnterEnv();
        if (env == null) {
            return null;
        }
        Tree.TopLevel topLevel = env.toplevel;
        Name name = topLevel.sourcefile;
        if (name == null) {
            return null;
        }
        int n = TreeInfo.positionFor(this.sym, topLevel);
        return new SourcePositionImpl(name, n);
    }

    @Override
    public void accept(DeclarationVisitor declarationVisitor) {
        declarationVisitor.visitDeclaration(this);
    }

    protected Collection<Symbol> getMembers(boolean bl) {
        Collection<Symbol> collection;
        if (this.members != null) {
            return this.members;
        }
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        Scope.Entry entry = this.sym.members().elems;
        while (entry != null) {
            if (entry.sym != null && !DeclarationImpl.unwanted(entry.sym)) {
                linkedList.addFirst(entry.sym);
            }
            entry = entry.sibling;
        }
        if (bl) {
            this.members = linkedList;
            collection = this.members;
        } else {
            collection = linkedList;
        }
        return collection;
    }

    private static boolean unwanted(Symbol symbol) {
        return AptEnv.hasFlag(symbol, 4096L) || symbol.kind == 2 && !DeclarationMaker.isJavaIdentifier(symbol.name.toString());
    }

    private Env<AttrContext> getEnterEnv() {
        Symbol.TypeSymbol typeSymbol = this.sym.kind != 1 ? this.sym.enclClass() : (Symbol.PackageSymbol)this.sym;
        return typeSymbol != null ? this.env.enter.getEnv(typeSymbol) : null;
    }
}

