/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.Application;
import com.ulcjava.applicationframework.application.ApplicationActionMap;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.ResourceMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager
implements Serializable {
    private final ApplicationContext fContext;
    private ApplicationActionMap fApplicationActionMap;

    protected ActionManager(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.fContext = context;
    }

    public ApplicationActionMap getActionMap() {
        if (this.fApplicationActionMap == null) {
            this.fApplicationActionMap = this.createActionMapChain(this.getContext().getApplication(), this.getContext().getApplication().getClass(), Application.class, this.getContext().getResourceMap());
        }
        return this.fApplicationActionMap;
    }

    public <T> ApplicationActionMap getActionMap(Class<? super T> actionsClass, T actionsObject) {
        ApplicationActionMap actionMapChain;
        Class<?> class1 = actionsObject.getClass();
        ApplicationActionMap rootMap = actionMapChain = this.createActionMapChain(actionsObject, actionsObject.getClass(), actionsClass, this.getContext().getResourceMap(class1, actionsClass));
        while (rootMap.getParentMap() != null) {
            rootMap = rootMap.getParentMap();
        }
        rootMap.setParentMap(this.getActionMap());
        return actionMapChain;
    }

    private ApplicationActionMap createActionMapChain(Object actionsObject, Class<?> startClass, Class<?> endClass, ResourceMap resourceMap) {
        Class<?> clazz;
        ApplicationActionMap childMap;
        if (!endClass.isAssignableFrom(startClass)) {
            throw new IllegalArgumentException(endClass.toString() + " must be super class of " + startClass.toString());
        }
        ApplicationActionMap result = childMap = new ApplicationActionMap(this.getContext(), clazz, actionsObject, resourceMap);
        ApplicationActionMap applicationActionMap = childMap;
        for (clazz = startClass; clazz != endClass; clazz = clazz.getSuperclass()) {
            applicationActionMap = new ApplicationActionMap(this.getContext(), clazz, actionsObject, resourceMap);
            childMap.setParentMap(applicationActionMap);
            childMap = applicationActionMap;
        }
        return result;
    }

    protected ApplicationContext getContext() {
        return this.fContext;
    }
}

