/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.binding;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingUtils {
    private BindingUtils() {
    }

    public static String getBeanName(Class<?> beanType) {
        String fullQualifiedName = beanType.getName();
        return fullQualifiedName.substring(fullQualifiedName.lastIndexOf(".") + 1);
    }

    public static String getBeanPackage(Class<?> beanType) {
        String fullQualifiedName = beanType.getName();
        return fullQualifiedName.substring(0, fullQualifiedName.lastIndexOf("."));
    }

    public static PropertyDescriptor[] getSimpleReadablePropertyDescriptors(Class<?> beanType) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(beanType);
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
            Method readMethod;
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i2];
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || (readMethod = propertyDescriptor.getReadMethod()) == null || readMethod.getDeclaringClass().equals(Object.class)) continue;
            result.add(propertyDescriptor);
        }
        return result.toArray(new PropertyDescriptor[result.size()]);
    }

    public static PropertyDescriptor staticResolvePropertyDescriptor(String propertyString, Class<?> beanClass) {
        int indexOfDot = propertyString.indexOf(".");
        if (indexOfDot == -1) {
            return BindingUtils.getPropertyDescriptorForProperty(propertyString, beanClass);
        }
        String firstProperty = propertyString.substring(0, indexOfDot);
        String remainingProperties = propertyString.substring(indexOfDot + 1);
        PropertyDescriptor firstPropertyDescriptor = BindingUtils.getPropertyDescriptorForProperty(firstProperty, beanClass);
        if (firstPropertyDescriptor == null) {
            return null;
        }
        Class<?> propertyType = BindingUtils.resolvePropertyType(firstPropertyDescriptor);
        return BindingUtils.staticResolvePropertyDescriptor(remainingProperties, propertyType);
    }

    public static Class<?> resolvePropertyType(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)propertyDescriptor).getMappedPropertyType();
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType();
        }
        return propertyDescriptor.getPropertyType();
    }

    private static PropertyDescriptor getPropertyDescriptorForProperty(String propertyName, Class<?> beanClass) {
        PropertyDescriptor[] propertyDescriptors;
        if (propertyName.endsWith(")")) {
            propertyName = propertyName.substring(0, propertyName.indexOf("("));
        } else if (propertyName.endsWith("]")) {
            propertyName = propertyName.substring(0, propertyName.indexOf("["));
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(beanClass)) {
            if (!propertyName.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        try {
            return new MappedPropertyDescriptor(propertyName, beanClass);
        }
        catch (IntrospectionException e2) {
            return null;
        }
    }
}

