/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.binding.AbstractWidgetBinder;
import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.application.ULCCheckBox;
import com.ulcjava.base.application.event.IValueChangedListener;
import com.ulcjava.base.application.event.ValueChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxBinder
extends AbstractWidgetBinder<ULCCheckBox> {
    private final boolean fForTrue;

    public CheckBoxBinder(FormModel<?> model, String propertyName, ULCCheckBox checkBox, boolean forTrue) {
        super(model, propertyName, checkBox);
        this.fForTrue = forTrue;
        checkBox.addValueChangedListener(new IValueChangedListener(){

            public void valueChanged(ValueChangedEvent event) {
                CheckBoxBinder.this.updateModel();
            }
        });
    }

    public boolean isForTrue() {
        return this.fForTrue;
    }

    protected ULCCheckBox getCheckBox() {
        return (ULCCheckBox)this.getWidget();
    }

    @Override
    public void updateValueFromModel(FormModel<?> model) {
        try {
            Object value = model.getProperty(this.getPropertyName());
            if (value != null) {
                boolean booleanValue = (Boolean)value;
                this.getCheckBox().setSelected(this.isForTrue() ? booleanValue : !booleanValue);
            }
        }
        catch (PropertyAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void updateModel() {
        try {
            boolean newValue = this.getCheckBox().isSelected();
            this.getModel().setProperty(new SetPropertyCommand(this.getPropertyName(), new Boolean(this.isForTrue() ? newValue : !newValue)));
        }
        catch (PropertyAccessException e2) {
            throw new RuntimeException(e2);
        }
    }
}

