/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.applicationframework.application.form.AbstractFormBuilder;
import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.base.application.BorderFactory;
import com.ulcjava.base.application.ULCAlert;
import com.ulcjava.base.application.ULCBoxPane;
import com.ulcjava.base.application.ULCButton;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCFiller;
import com.ulcjava.base.application.border.ULCAbstractBorder;
import com.ulcjava.base.application.enabler.ULCAndEnabler;
import com.ulcjava.base.application.enabler.ULCHasChangedEnabler;
import com.ulcjava.base.application.enabler.ULCMandatoryAndEnabler;
import com.ulcjava.base.application.event.ActionEvent;
import com.ulcjava.base.application.event.IActionListener;
import com.ulcjava.base.application.event.IRoundTripListener;
import com.ulcjava.base.application.event.IWindowListener;
import com.ulcjava.base.application.event.RoundTripEvent;
import com.ulcjava.base.application.event.WindowEvent;
import com.ulcjava.base.server.ULCSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFormDialog<T extends FormModel<?>>
implements Serializable {
    private final ULCBoxPane fButtonPane;
    private final ULCBoxPane fAdditionalButtonPane;
    private final ULCBoxPane fContentPane;
    private ULCButton fSaveButton;
    private ULCButton fResetButton;
    private final List<IActionListener> fSaveActions;
    private final AbstractFormBuilder<T> fFormBuilder;
    private IRoundTripListener fRoundTripListener;

    public BeanFormDialog(AbstractFormBuilder<T> beanForm) {
        this.fFormBuilder = beanForm;
        this.initRoundTripListener();
        this.fSaveActions = new ArrayList<IActionListener>();
        this.fButtonPane = this.createButtonPane();
        this.fAdditionalButtonPane = this.createButtonBox();
        ULCBoxPane buttonRow = new ULCBoxPane(false);
        buttonRow.add("lt", (ULCComponent)this.fAdditionalButtonPane);
        buttonRow.add("et", (ULCComponent)ULCFiller.createHorizontalGlue());
        buttonRow.add("rt", (ULCComponent)this.fButtonPane);
        this.fContentPane = new ULCBoxPane(true);
        this.fContentPane.setBorder(this.createBorder(10, 10, 10, 10));
        this.fContentPane.add("ee", this.getFormBuilder().getFormPane());
        this.fContentPane.add("et", (ULCComponent)buttonRow);
        this.doInitForm();
    }

    public T getModel() {
        return this.getFormBuilder().getModel();
    }

    private ULCAbstractBorder createBorder(int top, int left, int buttom, int right) {
        return BorderFactory.createEmptyBorder(top, left, buttom, right);
    }

    private ULCBoxPane createButtonPane() {
        ULCBoxPane boxPane = this.createButtonBox();
        this.fSaveButton = new ULCButton("OK");
        this.fSaveButton.setName("Button.Save");
        this.fSaveButton.addActionListener(new IActionListener(){

            public void actionPerformed(ActionEvent event) {
                BeanFormDialog.this.saveBean(event);
            }
        });
        this.fResetButton = new ULCButton("Reset");
        this.fResetButton.setName("Button.Reset");
        this.fResetButton.addActionListener(new IActionListener(){

            public void actionPerformed(ActionEvent event) {
                BeanFormDialog.this.reset();
            }
        });
        boxPane.add("re", (ULCComponent)this.fResetButton);
        boxPane.add("re", (ULCComponent)this.fSaveButton);
        return boxPane;
    }

    private ULCBoxPane createButtonBox() {
        ULCBoxPane boxPane = new ULCBoxPane(false);
        boxPane.setBorder(this.createBorder(0, 10, 0, 10));
        return boxPane;
    }

    public ULCComponent getContentPane() {
        return this.fContentPane;
    }

    public void setModel(T newModel) {
        if (((FormModel)this.getModel()).getBean() != ((FormModel)newModel).getBean()) {
            this.interceptIfDirty(new ModelReplacer(this, (FormModel)newModel));
        }
    }

    public void addSaveActionListener(IActionListener saveActionListener) {
        this.fSaveActions.add(saveActionListener);
    }

    public void addResetActionListener(IActionListener resetActionListener) {
        this.fResetButton.addActionListener(resetActionListener);
    }

    public void interceptIfDirty(final Runnable process) {
        if (((FormModel)this.getModel()).hasChanges()) {
            final ULCAlert alert = this.createUnsavedEditsAlert();
            alert.addWindowListener(new IWindowListener(){

                public void windowClosing(WindowEvent event) {
                    if (alert.getValue().equals(alert.getFirstButtonLabel())) {
                        if (BeanFormDialog.this.saveBean(new ActionEvent(BeanFormDialog.this.getModel(), "Save"))) {
                            process.run();
                        }
                    } else if (alert.getValue().equals(alert.getSecondButtonLabel())) {
                        try {
                            ((FormModel)BeanFormDialog.this.getModel()).undoAll();
                        }
                        catch (PropertyAccessException e2) {
                            throw new RuntimeException(e2);
                        }
                        process.run();
                    }
                }
            });
            alert.show();
        } else {
            process.run();
        }
    }

    protected ULCAlert createUnsavedEditsAlert() {
        return new ULCAlert("Unsaved edits", "Do you want to save changes?", "Yes", "No", "Cancel");
    }

    private void initRoundTripListener() {
        this.fRoundTripListener = new IRoundTripListener(){

            public void roundTripWillEnd(RoundTripEvent event) {
                BeanFormDialog.this.fSaveButton.setEnabled(BeanFormDialog.this.getDirtyState().isEnabling() && !((FormModel)BeanFormDialog.this.getModel()).hasErrors() && ((FormModel)BeanFormDialog.this.getModel()).areAllMandatoryFieldsSet());
            }

            public void roundTripDidStart(RoundTripEvent event) {
            }
        };
        ULCSession.currentSession().addRoundTripListener(this.fRoundTripListener);
    }

    public void dispose() {
        this.getFormBuilder().dispose();
        ULCSession.currentSession().removeRoundTripListener(this.fRoundTripListener);
    }

    private void resetForm() {
        this.getFormBuilder().reset();
        this.doInitForm();
    }

    private void doInitForm() {
        ULCAndEnabler andEnabler = new ULCAndEnabler();
        andEnabler.add(this.getDirtyState());
        andEnabler.add(this.getMandatoryEnabler());
        this.fSaveButton.setEnabler(andEnabler);
        this.fResetButton.setEnabler(this.getDirtyState());
    }

    private void replaceModel(T model) {
        this.getFormBuilder().replaceModel(model);
        this.resetForm();
    }

    private boolean saveBean(ActionEvent event) {
        if (((FormModel)this.getModel()).canSave()) {
            for (IActionListener listener : this.fSaveActions) {
                listener.actionPerformed(event);
            }
            ((FormModel)this.getModel()).resetUndo();
            return true;
        }
        this.handleModelHasErrorsOnSave();
        return false;
    }

    protected void handleModelHasErrorsOnSave() {
        new ULCAlert("Error on save", "Cannot save as long as there are errors in the form", "Ok").show();
    }

    public void reset() {
        this.getFormBuilder().reset();
    }

    public void addToButtons(ULCButton button) {
        this.fAdditionalButtonPane.add("lc", (ULCComponent)button);
    }

    protected AbstractFormBuilder<T> getFormBuilder() {
        return this.fFormBuilder;
    }

    private ULCHasChangedEnabler getDirtyState() {
        return this.getFormBuilder().getDirtyStateEnabler();
    }

    private ULCMandatoryAndEnabler getMandatoryEnabler() {
        return this.getFormBuilder().getMandatoryEnabler();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ModelReplacer
    implements Runnable,
    Serializable {
        private final T fNewModel;
        final /* synthetic */ BeanFormDialog this$0;

        private ModelReplacer(T newModel) {
            this.this$0 = var1_1;
            this.fNewModel = newModel;
        }

        @Override
        public void run() {
            this.this$0.replaceModel(this.fNewModel);
        }
    }
}

