/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.applicationframework.application.form.LayoutParameter;
import com.ulcjava.applicationframework.application.form.WidgetFactory;
import com.ulcjava.base.application.ClientContext;
import com.ulcjava.base.application.ULCTextField;
import com.ulcjava.base.application.datatype.IDataType;
import com.ulcjava.base.application.datatype.ULCDateDataType;
import com.ulcjava.base.application.datatype.ULCNumberDataType;
import java.text.DecimalFormatSymbols;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFieldParameter
extends LayoutParameter<TextFieldParameter, ULCTextField, WidgetFactory> {
    private String fIntegerFormatPattern;
    private String fDecimalFormatPattern;
    private String fDateFormatPattern;
    private boolean fHorizontalAlignmentIsSet = false;

    public TextFieldParameter(String propertyName, WidgetFactory widgetFactory) {
        super(propertyName, widgetFactory);
    }

    @Override
    protected TextFieldParameter getThis() {
        return this;
    }

    public String getIntegerFormatPattern() {
        return this.fIntegerFormatPattern;
    }

    public String getDecimalFormatPattern() {
        return this.fDecimalFormatPattern;
    }

    public String getDateFormatPattern() {
        return this.fDateFormatPattern;
    }

    public TextFieldParameter columns(int columns) {
        ((ULCTextField)this.getWidget()).setColumns(columns);
        return this;
    }

    public TextFieldParameter horizontalAlignment(int alignment) {
        this.fHorizontalAlignmentIsSet = true;
        ((ULCTextField)this.getWidget()).setHorizontalAlignment(alignment);
        return this;
    }

    public boolean isHorizontalAlignmentSet() {
        return this.fHorizontalAlignmentIsSet;
    }

    public TextFieldParameter integerFormatPattern(String formatPattern) {
        ULCNumberDataType numberDataType = new ULCNumberDataType(formatPattern, this.getDecimalFormatSymbols());
        numberDataType.setInteger(true);
        this.setDataType(numberDataType);
        this.fIntegerFormatPattern = formatPattern;
        return this;
    }

    public TextFieldParameter decimalFormatPattern(String formatPattern) {
        this.setDataType(new ULCNumberDataType(formatPattern, this.getDecimalFormatSymbols()));
        this.fDecimalFormatPattern = formatPattern;
        return this;
    }

    public TextFieldParameter dateFormatPattern(String formatPattern) {
        this.setDataType(new ULCDateDataType(formatPattern));
        this.fDateFormatPattern = formatPattern;
        return this;
    }

    protected DecimalFormatSymbols getDecimalFormatSymbols() {
        return new DecimalFormatSymbols(ClientContext.getLocale());
    }

    public IDataType getDataType() {
        return ((ULCTextField)this.getWidget()).getDataType();
    }

    public TextFieldParameter dataType(IDataType dataType) {
        this.setDataType(dataType);
        return this;
    }

    private void setDataType(IDataType dataType) {
        ((ULCTextField)this.getWidget()).setDataType(dataType);
    }

    @Override
    protected ULCTextField createWidget() {
        return ((WidgetFactory)this.getWidgetFactory()).createTextField();
    }
}

