/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.base.server.ApplicationConfiguration;
import com.ulcjava.easydeployment.server.DeploymentParameter;
import com.ulcjava.easydeployment.server.EasyDeploymentUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JNLPDownloader
extends HttpServlet
implements Servlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String splashURL;
        String icon64;
        DeploymentParameter parameter = new DeploymentParameter(request.getLocale());
        response.setContentType("application/x-java-jnlp-file");
        ApplicationConfiguration appConfig = ApplicationConfiguration.getInstance();
        PrintWriter writer = response.getWriter();
        writer.println("<jnlp spec=\"1.0+\"");
        writer.println("      codebase=\"" + EasyDeploymentUtilities.toBaseURL(request) + "\"");
        String jnlpFileName = request.getServletPath();
        jnlpFileName = jnlpFileName.substring(jnlpFileName.lastIndexOf(47) + 1);
        writer.println("      href=\"" + jnlpFileName + "\">");
        writer.println("    <information>");
        writer.println("        <title>" + parameter.getTitle() + "</title>");
        String vendor = parameter.getVendor();
        this.writeTagIfNotNull(writer, "vendor", vendor != null ? vendor : "Canoo Engineering AG");
        String homepage = parameter.getHomepage();
        this.writeTagIfNotNull(writer, "homepage", new Attribute("href", homepage != null ? homepage : "http://www.canoo.com/ulc/"));
        this.writeTagIfNotNull(writer, "description", parameter.getDescription());
        String icon32 = parameter.getIcon(32);
        if (icon32 != null) {
            this.writeTagIfNotNull(writer, "icon", new Attribute[]{new Attribute("href", EasyDeploymentUtilities.toFullURLIfNotNull(request, icon32)), new Attribute("width", "32"), new Attribute("height", "32")});
        }
        if ((icon64 = parameter.getIcon(64)) != null) {
            this.writeTagIfNotNull(writer, "icon", new Attribute[]{new Attribute("href", EasyDeploymentUtilities.toFullURLIfNotNull(request, icon64)), new Attribute("width", "64"), new Attribute("height", "64")});
        }
        if ((splashURL = EasyDeploymentUtilities.toFullURLIfNotNull(request, parameter.getSplash())) != null) {
            this.writeTagIfNotNull(writer, "icon", new Attribute[]{new Attribute("href", splashURL), new Attribute("kind", "splash")});
        }
        this.writeTagIfNotNull(writer, "association", new Attribute[]{new Attribute("mime-type", appConfig.getMimeType()), new Attribute("extensions", appConfig.getExtensions())});
        this.writeShortCutTag(writer, parameter);
        writer.println("    </information>");
        this.writeSecurityAllPermissions(writer);
        writer.println("    <resources>");
        String javaVersion = appConfig.getJavaVersion();
        if (javaVersion == null) {
            javaVersion = "1.4+";
        }
        this.writeTagIfNotNull(writer, "j2se", new Attribute[]{new Attribute("version", javaVersion), new Attribute("href", "http://java.sun.com/products/autodl/j2se"), new Attribute("java-vm-args", appConfig.getVmArgs()), new Attribute("initial-heap-size", this.asMegaByte(appConfig.getInitialHeapSize())), new Attribute("max-heap-size", this.asMegaByte(appConfig.getMaxHeapSize()))});
        writer.println("        " + EasyDeploymentUtilities.toJNLPJarTags(this.getServletContext()));
        writer.println("    </resources>");
        writer.println("    <application-desc main-class=\"" + EasyDeploymentUtilities.toJNLPLauncherClassName(this.getServletContext(), request) + "\">");
        writer.println("        <argument>url-string=" + EasyDeploymentUtilities.toUrlStringParam(request) + "</argument>");
        writer.println("    </application-desc>");
        writer.println("</jnlp> ");
    }

    private String asMegaByte(Integer heapSize) {
        return heapSize == null ? null : heapSize + "m";
    }

    private void writeSecurityAllPermissions(PrintWriter writer) {
        ApplicationConfiguration appConfig = ApplicationConfiguration.getInstance();
        if (appConfig.needsAllPermissions()) {
            writer.println("      <security><all-permissions/></security>");
        }
    }

    private void writeShortCutTag(PrintWriter writer, DeploymentParameter parameter) {
        ApplicationConfiguration appConfig = ApplicationConfiguration.getInstance();
        String menuGroup = parameter.getMenuGroup();
        if (appConfig.hasDesktopShortcut() || appConfig.hasMenuShortcut() || menuGroup != null) {
            writer.println("    <shortcut online=\"true\">");
            if (appConfig.hasDesktopShortcut()) {
                writer.println("    <desktop/>");
            }
            if (appConfig.hasMenuShortcut() || menuGroup != null) {
                if (menuGroup != null && menuGroup.length() > 0) {
                    this.writeTagIfNotNull(writer, "menu", new Attribute("submenu", menuGroup));
                } else {
                    writer.println("    <menu/>");
                }
            }
            writer.println("    </shortcut>");
        }
    }

    private void writeTagIfNotNull(PrintWriter writer, String tag, String value) {
        if (value != null) {
            writer.println("        <" + tag + ">" + value + "</" + tag + ">");
        }
    }

    private void writeTagIfNotNull(PrintWriter writer, String tag, Attribute attrib) {
        this.writeTagIfNotNull(writer, new Attribute(tag, null), new Attribute[]{attrib});
    }

    private void writeTagIfNotNull(PrintWriter writer, String tag, Attribute[] attrib) {
        this.writeTagIfNotNull(writer, new Attribute(tag, null), attrib);
    }

    private void writeTagIfNotNull(PrintWriter writer, Attribute tag, Attribute attrib) {
        this.writeTagIfNotNull(writer, tag, new Attribute[]{attrib});
    }

    private void writeTagIfNotNull(PrintWriter writer, Attribute tag, Attribute[] attrib) {
        String attributes = "";
        for (int i2 = 0; i2 < attrib.length; ++i2) {
            if (!attrib[i2].hasValue()) continue;
            attributes = attributes + attrib[i2] + " ";
        }
        if (attributes.length() > 0) {
            writer.print("        <" + tag.getKey() + " " + attributes);
            if (tag.hasValue()) {
                writer.println(">" + tag.getValue() + "</" + tag.getKey() + ">");
            } else {
                writer.println("/>");
            }
        }
    }

    private static class Attribute {
        private final String fValue;
        private final String fKey;

        public Attribute(String key, String value) {
            this.fKey = key;
            this.fValue = value;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue() {
            return this.fValue;
        }

        public boolean hasValue() {
            return this.getValue() != null;
        }

        public String toString() {
            return this.getKey() + "=\"" + this.getValue() + "\"";
        }
    }
}

