/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.AbstractBean;
import com.ulcjava.applicationframework.application.Action;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.View;
import com.ulcjava.base.application.IApplication;
import com.ulcjava.base.application.ULCPollingTimer;
import com.ulcjava.base.application.event.ActionEvent;
import com.ulcjava.base.application.event.IActionListener;
import com.ulcjava.base.development.DevelopmentRunner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Application
extends AbstractBean
implements IApplication,
Serializable {
    private static final Logger LOG = Logger.getLogger(Application.class.getName());
    public static final String QUIT_ACTION = "quit";
    private final List<IExitListener> fExitListenerList = new ArrayList<IExitListener>();
    private ApplicationContext fContext;

    protected ApplicationContext createApplicationContext() {
        return new ApplicationContext(this);
    }

    public static synchronized Application getInstance() {
        return (Application)com.ulcjava.base.application.ApplicationContext.getApplication();
    }

    public final void start() {
        this.initialize();
        this.startup();
        ULCPollingTimer readyTrigger = new ULCPollingTimer(10, new IActionListener(){

            public void actionPerformed(ActionEvent event) {
                Application.this.ready();
            }
        });
        readyTrigger.setRepeats(false);
        readyTrigger.start();
    }

    public static void run(String[] args) {
        String launcherClass = "unkown";
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElements.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElements[i2];
            String methodName = stackTraceElement.getMethodName();
            if (!"run".equals(methodName)) continue;
            launcherClass = stackTraceElements[i2 + 1].getClassName();
            break;
        }
        try {
            Class<?> applicationClass = Class.forName(launcherClass);
            DevelopmentRunner.setApplicationClass(applicationClass);
            DevelopmentRunner.main(args);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        DevelopmentRunner.main(args);
    }

    public final void stop() {
        try {
            this.shutdown();
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "Exception in shutdown()", e2);
        }
    }

    public void handleMessage(String message) {
    }

    public void activate() {
    }

    public void passivate() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void exit() {
        this.exit(null);
    }

    public void exit(EventObject event) {
        for (IExitListener exitListener : this.fExitListenerList) {
            if (exitListener.canExit(event)) continue;
            return;
        }
        for (IExitListener exitListener : this.fExitListenerList) {
            try {
                exitListener.willExit(event);
            }
            catch (Exception e2) {
                LOG.log(Level.WARNING, "Exception in ExitListener.willExit()", e2);
            }
        }
        com.ulcjava.base.application.ApplicationContext.terminate();
    }

    @Action(name="quit")
    public void quit(ActionEvent e2) {
        this.exit(e2);
    }

    public void addExitListener(IExitListener listener) {
        this.fExitListenerList.add(listener);
    }

    public void removeExitListener(IExitListener listener) {
        this.fExitListenerList.remove(listener);
    }

    public IExitListener[] getExitListeners() {
        return this.fExitListenerList.toArray(new IExitListener[this.fExitListenerList.size()]);
    }

    public final ApplicationContext getContext() {
        if (this.fContext == null) {
            this.fContext = this.createApplicationContext();
        }
        return this.fContext;
    }

    public void hide(View view) {
        view.hide();
    }

    public void show(View view) {
        view.show();
    }

    protected void initialize() {
    }

    protected abstract void startup();

    protected void ready() {
    }

    protected void shutdown() {
    }

    public static interface IExitListener
    extends EventListener,
    Serializable {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }
}

