/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.applicationframework.application.Application;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.ClientContextLocaleProvider;
import com.ulcjava.applicationframework.application.ILocaleProvider;
import com.ulcjava.applicationframework.application.ResourceMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager
implements Serializable {
    private final ApplicationContext fContext;
    private ResourceMap fApplicationResourceMap;
    private Class<? extends Application> fApplicationClass;

    public ResourceManager(Class<? extends Application> applicationClass) {
        if (applicationClass == null) {
            throw new IllegalArgumentException("applicationClass must not be null");
        }
        this.fContext = null;
        this.fApplicationClass = applicationClass;
    }

    public ResourceManager(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext must not be null");
        }
        this.fContext = applicationContext;
        this.fApplicationClass = applicationContext.getApplication().getClass();
    }

    protected ApplicationContext getContext() {
        return this.fContext;
    }

    public ResourceMap getResourceMap() {
        if (this.fApplicationResourceMap == null) {
            this.fApplicationResourceMap = this.getResourceMap(this.fApplicationClass, Application.class, null);
        }
        return this.fApplicationResourceMap;
    }

    public <T> ResourceMap getResourceMap(Class<T> clazz) {
        return this.getResourceMap(clazz, clazz);
    }

    public <T> ResourceMap getResourceMap(Class<? extends T> startClass, Class<T> endClass) {
        ResourceMap resourceMapForClassTree = this.getResourceMap(startClass, endClass, this.getResourceMap());
        return resourceMapForClassTree;
    }

    public <T> List<String> getBundleNames(Class<? extends T> startClass, Class<T> endClass) {
        ArrayList<String> result = new ArrayList<String>();
        for (Class<T> clazz = startClass; clazz != endClass.getSuperclass(); clazz = clazz.getSuperclass()) {
            result.addAll(this.getClassBundleNames(clazz));
        }
        return result;
    }

    public List<String> getClassBundleNames(Class<?> clazz) {
        String bundleName = clazz.getName();
        int insertionPoint = bundleName.lastIndexOf(46) + 1;
        bundleName = bundleName.substring(0, insertionPoint) + "resources." + bundleName.substring(insertionPoint);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(bundleName);
        return arrayList;
    }

    public <T> ResourceMap getResourceMap(Class<? extends T> startClass, Class<T> endClass, ResourceMap parent) {
        if (startClass == null) {
            throw new IllegalArgumentException("startClass must not be null");
        }
        if (endClass == null) {
            throw new IllegalArgumentException("endClass must not be null");
        }
        List<String> bundleNames = this.getBundleNames(startClass, endClass);
        ResourceMap rMap = null;
        for (int i2 = bundleNames.size() - 1; i2 >= 0; --i2) {
            parent = rMap = new ResourceMap(parent, this.getLocaleProvider(), bundleNames.get(i2));
        }
        return rMap;
    }

    protected ILocaleProvider getLocaleProvider() {
        return ClientContextLocaleProvider.getInstance();
    }
}

