/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.binding.CheckBoxBinder;
import com.ulcjava.applicationframework.application.binding.ComboBoxBinder;
import com.ulcjava.applicationframework.application.binding.IFormModelBinding;
import com.ulcjava.applicationframework.application.binding.IViewUpdater;
import com.ulcjava.applicationframework.application.binding.ListBinder;
import com.ulcjava.applicationframework.application.binding.RadioButtonBinder;
import com.ulcjava.applicationframework.application.binding.SliderBinder;
import com.ulcjava.applicationframework.application.binding.SpinnerBinder;
import com.ulcjava.applicationframework.application.binding.TextAreaBinder;
import com.ulcjava.applicationframework.application.binding.TextFieldBinder;
import com.ulcjava.applicationframework.application.binding.ViewUpdaterBinder;
import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.base.application.ULCCheckBox;
import com.ulcjava.base.application.ULCComboBox;
import com.ulcjava.base.application.ULCList;
import com.ulcjava.base.application.ULCRadioButton;
import com.ulcjava.base.application.ULCSlider;
import com.ulcjava.base.application.ULCSpinner;
import com.ulcjava.base.application.ULCTextArea;
import com.ulcjava.base.application.ULCTextField;
import com.ulcjava.base.application.datatype.ULCAbstractErrorManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetBinderManager<T extends FormModel<?>>
implements Serializable {
    private T fModel = null;
    private List<IFormModelBinding> fBindings = new ArrayList<IFormModelBinding>();

    public WidgetBinderManager() {
    }

    public WidgetBinderManager(T model) {
        this();
        this.setModel(model);
    }

    public T getModel() {
        return this.fModel;
    }

    public void setModel(T model) {
        T oldModel = this.fModel;
        this.fModel = model;
        this.moveBindings(oldModel);
    }

    private void moveBindings(T oldModel) {
        for (IFormModelBinding binding : this.fBindings) {
            if (oldModel != null) {
                binding.detachFromModel((FormModel<?>)oldModel);
            }
            if (this.getModel() == null) continue;
            binding.attachToModel((FormModel<?>)this.getModel());
        }
    }

    public void updateFromModel() {
        T model = this.getModel();
        if (model != null) {
            for (IFormModelBinding binding : this.fBindings) {
                binding.updateValueFromModel((FormModel<?>)model);
            }
        }
    }

    public void bindSlider(String propertyName, ULCSlider slider) {
        this.attach(new SliderBinder((FormModel<?>)this.getModel(), propertyName, slider));
    }

    public void bindSpinner(String propertyName, ULCSpinner spinner) {
        this.attach(new SpinnerBinder((FormModel<?>)this.getModel(), propertyName, spinner));
    }

    public void bindTextField(String propertyName, ULCTextField textField, ULCAbstractErrorManager errorManager) {
        this.attach(new TextFieldBinder((FormModel<?>)this.getModel(), propertyName, textField, errorManager));
    }

    public void bindComboBox(String propertyName, ULCComboBox comboBox) {
        this.attach(new ComboBoxBinder((FormModel<?>)this.getModel(), propertyName, comboBox));
    }

    public void bindCheckBox(String propertyName, ULCCheckBox checkBox, boolean forTrue) {
        this.attach(new CheckBoxBinder((FormModel<?>)this.getModel(), propertyName, checkBox, forTrue));
    }

    public void bindRadioButton(String propertyName, ULCRadioButton radioButton, Object value) {
        this.attach(new RadioButtonBinder((FormModel<?>)this.getModel(), propertyName, radioButton, value));
    }

    public void bindTextArea(String propertyName, ULCTextArea textArea) {
        this.attach(new TextAreaBinder((FormModel<?>)this.getModel(), propertyName, textArea));
    }

    public void bindList(String propertyName, ULCList widget) {
        this.attach(new ListBinder((FormModel<?>)this.getModel(), propertyName, widget));
    }

    public void bindMandatoryStateListener(String propertyName, IViewUpdater viewUpdater) {
        this.attach(new ViewUpdaterBinder(FormModel.getMandatoryStatePropertyName(propertyName), viewUpdater));
    }

    public void bindEnabledStateListener(String propertyName, IViewUpdater viewUpdater) {
        this.attach(new ViewUpdaterBinder(FormModel.getEnabledStatePropertyName(propertyName), viewUpdater));
    }

    public void bindReadonlyStateListener(String propertyName, IViewUpdater viewUpdater) {
        this.attach(new ViewUpdaterBinder(FormModel.getReadonlyStatePropertyName(propertyName), viewUpdater));
    }

    public void bindErrorStateListener(String propertyName, IViewUpdater viewUpdater) {
        propertyName = FormModel.getErrorStatePropertyName(propertyName);
        this.bindViewUpdater(propertyName, viewUpdater);
    }

    public void bindViewUpdater(String propertyName, IViewUpdater viewUpdater) {
        this.attach(new ViewUpdaterBinder(propertyName, viewUpdater));
    }

    public void attach(IFormModelBinding binder) {
        T model = this.getModel();
        if (model != null) {
            binder.attachToModel((FormModel<?>)model);
        }
        this.fBindings.add(binder);
    }
}

