/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.applicationframework.application.Application;
import com.ulcjava.applicationframework.application.ApplicationContext;
import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.applicationframework.application.binding.IViewUpdater;
import com.ulcjava.applicationframework.application.binding.WidgetBinderManager;
import com.ulcjava.applicationframework.application.form.CheckboxParameter;
import com.ulcjava.applicationframework.application.form.ComboboxParameter;
import com.ulcjava.applicationframework.application.form.DateSpinnerParameter;
import com.ulcjava.applicationframework.application.form.GeneralParameter;
import com.ulcjava.applicationframework.application.form.LabelParameter;
import com.ulcjava.applicationframework.application.form.LayoutParameter;
import com.ulcjava.applicationframework.application.form.ListParameter;
import com.ulcjava.applicationframework.application.form.ListSpinnerParameter;
import com.ulcjava.applicationframework.application.form.NumericSpinnerParameter;
import com.ulcjava.applicationframework.application.form.PasswordFieldParameter;
import com.ulcjava.applicationframework.application.form.RadioButtonParameter;
import com.ulcjava.applicationframework.application.form.SliderParameter;
import com.ulcjava.applicationframework.application.form.TextAreaParameter;
import com.ulcjava.applicationframework.application.form.TextFieldParameter;
import com.ulcjava.applicationframework.application.form.WidgetFactory;
import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.base.application.BorderFactory;
import com.ulcjava.base.application.ClientContext;
import com.ulcjava.base.application.DefaultComboBoxModel;
import com.ulcjava.base.application.DefaultListModel;
import com.ulcjava.base.application.IComboBoxModel;
import com.ulcjava.base.application.IListModel;
import com.ulcjava.base.application.ISpinnerModel;
import com.ulcjava.base.application.ULCBoxPane;
import com.ulcjava.base.application.ULCCheckBox;
import com.ulcjava.base.application.ULCComboBox;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCContainer;
import com.ulcjava.base.application.ULCFiller;
import com.ulcjava.base.application.ULCLabel;
import com.ulcjava.base.application.ULCList;
import com.ulcjava.base.application.ULCPasswordField;
import com.ulcjava.base.application.ULCProxy;
import com.ulcjava.base.application.ULCRadioButton;
import com.ulcjava.base.application.ULCScrollPane;
import com.ulcjava.base.application.ULCSeparator;
import com.ulcjava.base.application.ULCSlider;
import com.ulcjava.base.application.ULCSpinner;
import com.ulcjava.base.application.ULCTabbedPane;
import com.ulcjava.base.application.ULCTextArea;
import com.ulcjava.base.application.ULCTextComponent;
import com.ulcjava.base.application.ULCTextField;
import com.ulcjava.base.application.border.ULCAbstractBorder;
import com.ulcjava.base.application.datatype.ULCAbstractErrorManager;
import com.ulcjava.base.application.datatype.ULCDateDataType;
import com.ulcjava.base.application.datatype.ULCDefaultErrorManager;
import com.ulcjava.base.application.datatype.ULCNumberDataType;
import com.ulcjava.base.application.datatype.ULCPercentDataType;
import com.ulcjava.base.application.enabler.IEnabler;
import com.ulcjava.base.application.enabler.IHasChangedSource;
import com.ulcjava.base.application.enabler.ULCHasChangedEnabler;
import com.ulcjava.base.application.enabler.ULCMandatoryAndEnabler;
import com.ulcjava.base.application.event.IRoundTripListener;
import com.ulcjava.base.application.event.RoundTripEvent;
import com.ulcjava.base.application.util.Color;
import com.ulcjava.base.server.ULCSession;
import com.ulcjava.base.shared.ErrorObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormBuilder<T extends FormModel<?>>
implements Serializable {
    protected static final int DEFAULT_SPACE_BEFORE_TITLE = 10;
    protected static final int DEFAULT_SPACE_AFTER_TITLE = 5;
    private static final Integer DEFAULT_COLUMN_WEIGHT = new Integer(1);
    private static final Integer DEFAULT_LABEL_COLUMN_WEIGHT = new Integer(0);
    private static final int DEFAULT_SPACER_WIDTH = 50;
    private static final int HORIZONTAL_GAP = 3;
    private static final int VERTICAL_GAP = 3;
    private T fModel;
    private ULCTabbedPane fTabbedPane;
    private ULCBoxPane fFormPane;
    private ULCHasChangedEnabler fDirtyStateEnabler;
    private ULCMandatoryAndEnabler fMandatoryEnabler;
    private int fYPos;
    private WidgetStore fLastWidget;
    private float[] fColumnWeights;
    private List<Number> fDefaultWeights;
    private final WidgetBinderManager<T> fWidgetBinderManager;
    private final WidgetFactory fWidgetFactory = this.createWidgetFactory();
    private int[] fColumnWidths;
    private int fDefaultEventDeliveryMode;
    private int fLabelHorizontalAlignment;
    private List<FormBuilderPart> fPart;
    private IRoundTripListener fRoundTripListener;
    private final ULCAbstractErrorManager fErrorManager;
    private ResourceMap fResourceMap;

    public AbstractFormBuilder(T model) {
        this(model, 0);
    }

    public AbstractFormBuilder(T model, int defaultEventDeliveryMode) {
        this.fWidgetBinderManager = this.createWidgetBinder();
        this.doSetModel(model);
        this.fDirtyStateEnabler = new ULCHasChangedEnabler();
        this.fMandatoryEnabler = new ULCMandatoryAndEnabler();
        this.getMandatoryEnabler().setHighLightColor(Color.yellow);
        this.fDefaultEventDeliveryMode = defaultEventDeliveryMode;
        this.fTabbedPane = null;
        this.fDefaultWeights = new ArrayList<Number>();
        this.fColumnWeights = null;
        this.fColumnWidths = null;
        this.fFormPane = null;
        this.fLabelHorizontalAlignment = 10;
        this.fPart = new ArrayList<FormBuilderPart>(25);
        this.fErrorManager = this.createErrorManager();
        this.fResourceMap = null;
    }

    protected abstract void initForm();

    protected ULCAbstractErrorManager createErrorManager() {
        return new ULCDefaultErrorManager(this.createErrorMessages(), this.getErrorColor(), this.getErrorBorder());
    }

    public ULCAbstractErrorManager getErrorManager() {
        return this.fErrorManager;
    }

    protected ULCAbstractBorder getErrorBorder() {
        return BorderFactory.createLineBorder(Color.red, 1);
    }

    protected Color getErrorColor() {
        return Color.pink;
    }

    protected HashMap<String, String> createErrorMessages() {
        HashMap<String, String> result = new HashMap<String, String>();
        ResourceMap resourceMap = this.getResourceMap();
        List<String> resourceKeys = resourceMap.getResourceKeys("ERROR_CODE.");
        for (String errorCode : resourceKeys) {
            result.put(errorCode, resourceMap.getString(errorCode, new Object[0]));
        }
        return result;
    }

    protected WidgetBinderManager<T> createWidgetBinder() {
        return new WidgetBinderManager();
    }

    protected WidgetFactory createWidgetFactory() {
        return new WidgetFactory();
    }

    protected WidgetFactory getWidgetFactory() {
        return this.fWidgetFactory;
    }

    public int getDefaultEventDeliveryMode() {
        return this.fDefaultEventDeliveryMode;
    }

    protected int getEventDeliveryMode(LayoutParameter<?, ?, ?> layoutParameter) {
        return layoutParameter.getEventDeliveryMode(this.getDefaultEventDeliveryMode());
    }

    public void setDefaultEventDeliveryMode(final int eventDeliveryMode) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                AbstractFormBuilder.this.fDefaultEventDeliveryMode = eventDeliveryMode;
            }
        });
    }

    private ULCAbstractBorder createBorder(int top, int left, int buttom, int right) {
        return BorderFactory.createEmptyBorder(top, left, buttom, right);
    }

    public ULCComponent getFormPane() {
        if (this.fFormPane == null) {
            this.doInitForm();
            ULCContainer pane = this.fTabbedPane == null ? this.fFormPane : this.fTabbedPane;
            this.getResourceMap().injectComponents(pane);
            return pane;
        }
        return this.fTabbedPane == null ? this.fFormPane : this.fTabbedPane;
    }

    protected WidgetBinderManager<T> getWidgetBinderManager() {
        return this.fWidgetBinderManager;
    }

    public void reset() {
        try {
            ((FormModel)this.getModel()).undoAll();
            this.getDirtyStateEnabler().reset();
        }
        catch (PropertyAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void addPart(FormBuilderPart part) {
        this.fPart.add(part);
    }

    public T getModel() {
        return this.fModel;
    }

    protected TextFieldParameter addTextField(String propertyName) {
        return this.addTextField(new TextFieldParameter(propertyName, this.getWidgetFactory()));
    }

    protected TextFieldParameter addTextField(String propertyName, String labelText) {
        return this.addTextField((TextFieldParameter)new TextFieldParameter(propertyName, this.getWidgetFactory()).labelText(labelText));
    }

    protected TextFieldParameter addTextField(final TextFieldParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCTextField widget = AbstractFormBuilder.this.createBoundTextField(parameter);
                ClientContext.setEventDeliveryMode((ULCProxy)widget, "valueChanged", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(widget, widget, parameter);
            }
        });
        return parameter;
    }

    protected PasswordFieldParameter addPasswordField(String propertyName) {
        return this.addPasswordField(new PasswordFieldParameter(propertyName, this.getWidgetFactory()));
    }

    protected PasswordFieldParameter addPasswordField(String propertyName, String labelText) {
        return (PasswordFieldParameter)this.addPasswordField(propertyName).labelText(labelText);
    }

    protected PasswordFieldParameter addPasswordField(final PasswordFieldParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCPasswordField widget = (ULCPasswordField)parameter.getWidget();
                AbstractFormBuilder.this.getWidgetBinderManager().bindTextField(parameter.getPropertyName(), widget, AbstractFormBuilder.this.getErrorManager());
                ClientContext.setEventDeliveryMode((ULCProxy)widget, "valueChanged", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(widget, widget, parameter);
            }
        });
        return parameter;
    }

    protected TextAreaParameter addTextArea(String propertyName) {
        return this.addTextArea(new TextAreaParameter(propertyName, this.getWidgetFactory()));
    }

    protected TextAreaParameter addTextArea(String propertyName, String labelText) {
        return (TextAreaParameter)this.addTextArea(propertyName).labelText(labelText);
    }

    protected TextAreaParameter addTextArea(String propertyName, String labelText, int rows, int columns) {
        return ((TextAreaParameter)this.addTextArea(propertyName).labelText(labelText)).rows(rows).columns(columns);
    }

    protected TextAreaParameter addTextArea(final TextAreaParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                AbstractFormBuilder.this.getWidgetBinderManager().bindTextArea(parameter.getPropertyName(), (ULCTextArea)parameter.getWidget());
                ULCTextArea widget = (ULCTextArea)parameter.getWidget();
                ClientContext.setEventDeliveryMode((ULCProxy)widget, "valueChanged", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(new ULCScrollPane(widget), widget, parameter);
            }
        });
        return parameter;
    }

    protected ListParameter addList(String propertyName, IListModel model) {
        return this.addList(new ListParameter(propertyName, model, this.getWidgetFactory()));
    }

    protected ListParameter addList(String propertyName, Object[] values) {
        return this.addList(propertyName, new DefaultListModel(values));
    }

    protected ListParameter addList(String propertyName, List<?> values) {
        return this.addList(propertyName, new DefaultListModel(values.toArray()));
    }

    protected ListParameter addList(String propertyName, String labelText, IListModel model) {
        return (ListParameter)this.addList(new ListParameter(propertyName, model, this.getWidgetFactory())).labelText(labelText);
    }

    protected ListParameter addList(String propertyName, String labelText, Object[] values) {
        return (ListParameter)this.addList(propertyName, values).labelText(labelText);
    }

    protected ListParameter addList(String propertyName, String labelText, List<?> values) {
        return (ListParameter)this.addList(propertyName, values).labelText(labelText);
    }

    protected ListParameter addList(final ListParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCList widget = (ULCList)parameter.getWidget();
                AbstractFormBuilder.this.getWidgetBinderManager().bindList(parameter.getPropertyName(), widget);
                ClientContext.setEventDeliveryMode((ULCProxy)widget, "action", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(new ULCScrollPane(widget), widget.getSelectionModel(), parameter);
            }
        });
        return parameter;
    }

    protected SliderParameter addSlider(String propertyName) {
        return this.addSlider(new SliderParameter(propertyName, this.getWidgetFactory()));
    }

    protected SliderParameter addSlider(String propertyName, String labelText) {
        return (SliderParameter)this.addSlider(propertyName).labelText(labelText);
    }

    protected SliderParameter addSlider(final SliderParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCSlider widget = (ULCSlider)parameter.getWidget();
                AbstractFormBuilder.this.getWidgetBinderManager().bindSlider(parameter.getPropertyName(), widget);
                ClientContext.setEventDeliveryMode((ULCProxy)widget, "valueChanged", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(widget, widget, parameter);
            }
        });
        return parameter;
    }

    protected LayoutParameter<?, ULCSpinner, ?> addSpinner(String propertyName) {
        Class<?> propertyType = ((FormModel)this.getModel()).getPropertyType(propertyName);
        if (Date.class.isAssignableFrom(propertyType)) {
            return this.addSpinner(new DateSpinnerParameter(propertyName, this.getWidgetFactory()));
        }
        if (this.isIntegerNumberType(propertyType) || this.isFloatNumberType(propertyType)) {
            return this.addSpinner(new NumericSpinnerParameter(propertyName, this.getWidgetFactory()));
        }
        throw new IllegalArgumentException("Cannot instantiate a Spinner for the given property of type " + propertyType);
    }

    protected LayoutParameter<?, ULCSpinner, ?> addSpinner(String propertyName, String labelText) {
        return ((LayoutParameter)((Object)this.addSpinner((LayoutParameter)((Object)propertyName)))).labelText(labelText);
    }

    protected ListSpinnerParameter addListSpinner(String propertyName, List<?> items) {
        return this.addSpinner(new ListSpinnerParameter(propertyName, this.getWidgetFactory(), items));
    }

    protected ListSpinnerParameter addListSpinner(String propertyName, String labelText, List<?> items) {
        return (ListSpinnerParameter)this.addListSpinner(propertyName, items).labelText(labelText);
    }

    protected ListSpinnerParameter addListSpinner(String propertyName, Object[] items) {
        return this.addSpinner(new ListSpinnerParameter(propertyName, this.getWidgetFactory(), items));
    }

    protected ListSpinnerParameter addListSpinner(String propertyName, String labelText, Object[] items) {
        return (ListSpinnerParameter)this.addListSpinner(propertyName, items).labelText(labelText);
    }

    protected NumericSpinnerParameter addNumericSpinner(String propertyName) {
        return this.addSpinner(new NumericSpinnerParameter(propertyName, this.getWidgetFactory()));
    }

    protected NumericSpinnerParameter addNumericSpinner(String propertyName, String labelText) {
        return (NumericSpinnerParameter)this.addNumericSpinner(propertyName).labelText(labelText);
    }

    protected DateSpinnerParameter addDateSpinner(String propertyName, String labelText) {
        return (DateSpinnerParameter)this.addDateSpinner(propertyName).labelText(labelText);
    }

    protected DateSpinnerParameter addDateSpinner(String propertyName) {
        return this.addSpinner(new DateSpinnerParameter(propertyName, this.getWidgetFactory()));
    }

    protected <LP extends LayoutParameter<?, ULCSpinner, ?>> LP addSpinner(final LP parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCSpinner widget = (ULCSpinner)parameter.getWidget();
                AbstractFormBuilder.this.getWidgetBinderManager().bindSpinner(parameter.getPropertyName(), widget);
                AbstractFormBuilder.this.addSpinnerToView(parameter, widget);
            }
        });
        return parameter;
    }

    private void addSpinnerToView(LayoutParameter<?, ULCSpinner, ?> layoutInfo, ULCSpinner widget) {
        ISpinnerModel model = widget.getModel();
        if (model instanceof ULCProxy) {
            ULCProxy modelProxy = (ULCProxy)((Object)model);
            ClientContext.setEventDeliveryMode(modelProxy, "valueChanged", this.getEventDeliveryMode(layoutInfo));
        }
        this.addComponentToView(widget, model, layoutInfo);
    }

    protected ComboboxParameter addCombobox(String propertyName, IComboBoxModel model) {
        return this.addCombobox(new ComboboxParameter(propertyName, model, this.getWidgetFactory()));
    }

    protected ComboboxParameter addCombobox(String propertyName, List<?> items) {
        return this.addCombobox(propertyName, new DefaultComboBoxModel(items));
    }

    protected ComboboxParameter addCombobox(String propertyName, Object[] items) {
        return this.addCombobox(propertyName, new DefaultComboBoxModel(items));
    }

    protected ComboboxParameter addCombobox(String propertyName, String labelText, IComboBoxModel model) {
        return (ComboboxParameter)this.addCombobox(propertyName, model).labelText(labelText);
    }

    protected ComboboxParameter addCombobox(String propertyName, String labelText, List<?> items) {
        return (ComboboxParameter)this.addCombobox(propertyName, items).labelText(labelText);
    }

    protected ComboboxParameter addCombobox(String propertyName, String labelText, Object[] items) {
        return (ComboboxParameter)this.addCombobox(propertyName, items).labelText(labelText);
    }

    protected ComboboxParameter addCombobox(final ComboboxParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCComboBox widget = (ULCComboBox)parameter.getWidget();
                AbstractFormBuilder.this.getWidgetBinderManager().bindComboBox(parameter.getPropertyName(), widget);
                ClientContext.setEventDeliveryMode((ULCProxy)widget, "action", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(widget, widget.getModel(), parameter);
            }
        });
        return parameter;
    }

    protected CheckboxParameter addCheckBox(String propertyName) {
        return this.addCheckBox(new CheckboxParameter(propertyName, this.getWidgetFactory()));
    }

    protected CheckboxParameter addCheckBox(String propertyName, String labelText) {
        return (CheckboxParameter)this.addCheckBox(propertyName).labelText(labelText);
    }

    protected CheckboxParameter addCheckBox(String propertyName, String labelText, String textAfter) {
        return ((CheckboxParameter)this.addCheckBox(propertyName).labelText(labelText)).text(textAfter);
    }

    protected CheckboxParameter addCheckBox(final CheckboxParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCCheckBox checkBox = (ULCCheckBox)parameter.getWidget();
                AbstractFormBuilder.this.getWidgetBinderManager().bindCheckBox(parameter.getPropertyName(), checkBox, true);
                checkBox.setAlignmentX(0.0f);
                ClientContext.setEventDeliveryMode((ULCProxy)checkBox, "action", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                AbstractFormBuilder.this.addComponentToView(checkBox, checkBox, parameter);
            }
        });
        return parameter;
    }

    protected RadioButtonParameter addRadioButtons(String propertyName, String labelText, String[] labels, Object[] values) {
        return this.addRadioButtons((RadioButtonParameter)new RadioButtonParameter(propertyName, labels, values, this.getWidgetFactory()).labelText(labelText));
    }

    protected RadioButtonParameter addRadioButtons(final RadioButtonParameter parameter) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                ULCRadioButton[] radios = parameter.getRadioButtons();
                Object[] values = parameter.getValues();
                ULCRadioButton radio = null;
                for (int i2 = 0; i2 < radios.length; ++i2) {
                    radio = radios[i2];
                    AbstractFormBuilder.this.getWidgetBinderManager().bindRadioButton(parameter.getPropertyName(), radio, values[i2]);
                    ClientContext.setEventDeliveryMode((ULCProxy)radio, "action", AbstractFormBuilder.this.getEventDeliveryMode(parameter));
                }
                AbstractFormBuilder.this.addComponentToView((ULCComponent)parameter.getWidget(), radio, parameter);
            }
        });
        return parameter;
    }

    protected GeneralParameter addComponentToView(final ULCComponent widget) {
        final GeneralParameter generalParameter = new GeneralParameter(widget, this.getWidgetFactory());
        this.addPart(new FormBuilderPart(){

            protected void build() {
                AbstractFormBuilder.this.addComponentToView(widget, null, generalParameter);
            }
        });
        return generalParameter;
    }

    protected GeneralParameter addComponentToView(String labelText, ULCComponent widget) {
        return (GeneralParameter)this.addComponentToView(widget).labelText(labelText);
    }

    protected LabelParameter addLabel(String text) {
        final LabelParameter labelParameter = new LabelParameter(text, this.getWidgetFactory());
        labelParameter.widgetName(text + ".Label");
        this.addPart(new FormBuilderPart(){

            protected void build() {
                if (!labelParameter.isHorizontalAlignmentSet()) {
                    labelParameter.horizontalAlignment(AbstractFormBuilder.this.getLabelHorizontalAlignment());
                }
                AbstractFormBuilder.this.addComponentToView((ULCComponent)labelParameter.getWidget(), null, labelParameter);
            }
        });
        return labelParameter;
    }

    protected GeneralParameter addSpacer(int startColumn) {
        return this.addSpacer(startColumn, 50);
    }

    protected GeneralParameter addSpacer(int startColumn, int width) {
        return (GeneralParameter)this.addComponentToView(ULCFiller.createHorizontalStrut(width)).startColumn(startColumn);
    }

    protected LabelParameter addTitle(String titleText) {
        return this.addTitle(titleText, 10, 5);
    }

    protected LabelParameter addTitle(String titleText, int spaceBefore, int spaceAfter) {
        this.addComponentToView(ULCFiller.createVerticalStrut(spaceBefore));
        LabelParameter labelParameter = this.addLabel(titleText).horizontalAlignment(10);
        labelParameter.notGrowing(true);
        this.addComponentToView(new ULCSeparator(0)).append(true);
        this.addComponentToView(ULCFiller.createVerticalStrut(spaceAfter));
        return labelParameter;
    }

    protected ULCComponent addComponentToView(final ULCComponent widget, IHasChangedSource changedSource, LayoutParameter<?, ?, ?> layoutInfo) {
        String propertyName = layoutInfo.getPropertyName();
        if (widget == null) {
            throw new IllegalArgumentException("Widget must not be null");
        }
        if (layoutInfo.shouldStartRow()) {
            this.finishCurrentRow();
        }
        int column = layoutInfo.getStartColumn();
        final ULCLabel label = layoutInfo.getLabel();
        if (label != null) {
            label.setHorizontalAlignment(this.getLabelHorizontalAlignment());
            this.setDefaultColumnWeight(column, DEFAULT_LABEL_COLUMN_WEIGHT);
            this.addWidget(label, column, -1, layoutInfo.isGrowingHorizontally(), false, layoutInfo.isAppend());
            ++column;
        }
        widget.setAlignmentX(1.0f);
        this.addWidget(widget, column, layoutInfo.getEndColumn(), layoutInfo.isGrowingHorizontally(), layoutInfo.isGrowingVertically(), layoutInfo.isAppend());
        if (changedSource != null) {
            this.getDirtyStateEnabler().add(changedSource);
        }
        if (this.isDefined(propertyName)) {
            this.fWidgetBinderManager.bindErrorStateListener(propertyName, new IViewUpdater(){

                public void updateView(Object newValue) {
                    if (newValue instanceof ErrorObject) {
                        ErrorObject error = (ErrorObject)newValue;
                        AbstractFormBuilder.this.getErrorManager().showError(widget, error);
                    } else if (newValue == null) {
                        AbstractFormBuilder.this.getErrorManager().showError(widget, null);
                    } else {
                        throw new IllegalArgumentException("value is not null and not an instance of BeanError");
                    }
                }
            });
            if (widget.getName() == null) {
                widget.setName(propertyName + "." + this.toWidgetName(widget));
            }
            if (layoutInfo.isReadonly()) {
                this.setWidgetReadonly(widget, false);
            } else {
                this.fWidgetBinderManager.bindReadonlyStateListener(propertyName, new IViewUpdater(){

                    public void updateView(Object value) {
                        boolean isReadonly = Boolean.TRUE.equals(value);
                        boolean editable = !isReadonly;
                        AbstractFormBuilder.this.setWidgetReadonly(widget, editable);
                    }
                });
                this.fWidgetBinderManager.bindMandatoryStateListener(propertyName, new IViewUpdater(){

                    public void updateView(Object value) {
                        boolean isMandatory = Boolean.TRUE.equals(value);
                        if (isMandatory) {
                            if (widget instanceof IEnabler) {
                                AbstractFormBuilder.this.getMandatoryEnabler().remove((IEnabler)((Object)widget));
                                AbstractFormBuilder.this.getMandatoryEnabler().add((IEnabler)((Object)widget));
                            }
                        } else if (widget instanceof IEnabler) {
                            AbstractFormBuilder.this.getMandatoryEnabler().remove((IEnabler)((Object)widget));
                        }
                    }
                });
                this.fWidgetBinderManager.bindEnabledStateListener(propertyName, new IViewUpdater(){

                    public void updateView(Object value) {
                        boolean isEnabled = Boolean.TRUE.equals(value);
                        widget.setEnabled(isEnabled);
                        if (label != null) {
                            label.setEnabled(isEnabled);
                        }
                    }
                });
            }
        }
        return widget;
    }

    private String toWidgetName(ULCComponent widget) {
        String simpleClassName = widget.getClass().getSimpleName();
        return simpleClassName.startsWith("ULC") ? simpleClassName.substring(3) : simpleClassName;
    }

    protected int getLabelHorizontalAlignment() {
        return this.fLabelHorizontalAlignment;
    }

    protected void setLabelHorizontalAlignment(final int labelAlignement) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                AbstractFormBuilder.this.fLabelHorizontalAlignment = labelAlignement;
            }
        });
    }

    protected void startTab(final String title) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                if (AbstractFormBuilder.this.fTabbedPane == null) {
                    AbstractFormBuilder.this.fTabbedPane = new ULCTabbedPane();
                    AbstractFormBuilder.this.fTabbedPane.setBorder(AbstractFormBuilder.this.createBorder(5, 10, 0, 10));
                    AbstractFormBuilder.this.addFormPaneToTab(title);
                } else {
                    AbstractFormBuilder.this.finishCurrentAndCreateNewFormPane();
                    AbstractFormBuilder.this.addFormPaneToTab(title);
                }
            }
        });
    }

    private void finishCurrentRow() {
        this.addWidget(null, 0, -1, false, false, false);
        ++this.fYPos;
    }

    private void finishCurrentAndCreateNewFormPane() {
        this.finishCurrentPane();
        this.fFormPane = this.createFormPane();
    }

    private void finishCurrentPane() {
        this.finishCurrentRow();
        if (this.fColumnWeights != null) {
            for (int i2 = 0; i2 < this.fColumnWeights.length; ++i2) {
                this.setColumnWeight(i2, this.fColumnWeights[i2], this.getColumnWidth(i2));
            }
        } else {
            for (int i3 = 0; i3 < this.fDefaultWeights.size(); ++i3) {
                this.setColumnWeight(i3, this.fDefaultWeights.get(i3).floatValue(), this.getColumnWidth(i3));
            }
        }
        this.fFormPane.set(0, this.fYPos, 0, 1, 0.0, 1.0E-4, "ce", ULCFiller.createHorizontalGlue());
    }

    private int getColumnWidth(int i2) {
        int width = 0;
        if (this.fColumnWidths != null && i2 < this.fColumnWidths.length) {
            width = this.fColumnWidths[i2];
        }
        return width;
    }

    private void setColumnWeight(int i2, float weight, int width) {
        this.fFormPane.set(i2, 0, weight, 0.0, "cc", (ULCComponent)ULCFiller.createHorizontalStrut(width));
    }

    private ULCBoxPane createFormPane() {
        this.fYPos = 0;
        this.fDefaultWeights.clear();
        ULCBoxPane boxPane = new ULCBoxPane(0, 0, 3, 3);
        return boxPane;
    }

    private void addWidget(ULCComponent widget, int startColumn, int endColumn, boolean isGrowingHorizontally, boolean isGrowingVertically, boolean append) {
        if (this.fDefaultWeights.size() < startColumn + 1) {
            this.setDefaultColumnWeight(startColumn, DEFAULT_COLUMN_WEIGHT);
        }
        if (this.fLastWidget != null) {
            if (append && widget != null) {
                this.fLastWidget.append(widget, isGrowingHorizontally, isGrowingVertically);
                return;
            }
            if (this.fLastWidget.getColumnSpan() == 0) {
                this.fLastWidget.setLastColumn(startColumn);
            }
            this.doAddWidget(this.fLastWidget);
        }
        this.fLastWidget = widget != null ? new WidgetStore(widget, startColumn, endColumn, this.fYPos, isGrowingHorizontally, isGrowingVertically) : null;
    }

    private void doAddWidget(WidgetStore widgetStore) {
        this.fFormPane.set(widgetStore.getColumn(), widgetStore.getRow(), widgetStore.getColumnSpan(), 1, 0.0, widgetStore.isGrowingVertically() ? 1.0 : 0.0, widgetStore.getAlingment(), widgetStore.getWidget());
    }

    private boolean isDefined(String aString) {
        return aString != null && aString.length() > 0;
    }

    /*
     * Unable to fully structure code
     */
    private ULCTextField createBoundTextField(TextFieldParameter parameter) {
        propertyName = parameter.getPropertyName();
        widget = (ULCTextField)parameter.getWidget();
        dataType = parameter.getDataType();
        if (dataType == null) {
            try {
                propertyType = this.getModel().getPropertyType(propertyName);
                if (this.isIntegerNumberType(propertyType)) {
                    numberDataType = new ULCNumberDataType(this.getErrorManager());
                    numberDataType.setInteger(true);
                    widget.setDataType(numberDataType);
                    if (parameter.isHorizontalAlignmentSet()) ** GOTO lbl26
                    widget.setHorizontalAlignment(11);
                }
                if (this.isFloatNumberType(propertyType)) {
                    widget.setDataType(new ULCNumberDataType(this.getErrorManager()));
                    if (parameter.isHorizontalAlignmentSet()) ** GOTO lbl26
                    widget.setHorizontalAlignment(11);
                }
                if (!propertyType.equals(Date.class)) ** GOTO lbl26
                widget.setDataType(new ULCDateDataType(this.getErrorManager()));
            }
            catch (PropertyAccessException e) {
                throw new RuntimeException(e);
            }
        } else if (!parameter.isHorizontalAlignmentSet() && dataType instanceof ULCNumberDataType || dataType instanceof ULCPercentDataType) {
            widget.setHorizontalAlignment(11);
        }
lbl26:
        // 9 sources

        this.getWidgetBinderManager().bindTextField(propertyName, widget, this.getErrorManager());
        return widget;
    }

    private boolean isFloatNumberType(Class<?> propertyType) {
        return propertyType.equals(Double.TYPE) || propertyType.equals(Double.class) || propertyType.equals(Float.TYPE) || propertyType.equals(Float.class) || propertyType.equals(BigDecimal.class);
    }

    private boolean isIntegerNumberType(Class<?> propertyType) {
        return propertyType.equals(Integer.TYPE) || propertyType.equals(Short.TYPE) || propertyType.equals(Byte.TYPE) || propertyType.equals(Long.TYPE) || propertyType.equals(Integer.class) || propertyType.equals(Short.class) || propertyType.equals(Byte.class) || propertyType.equals(Long.class) || propertyType.equals(BigInteger.class);
    }

    private void addFormPaneToTab(String title) {
        String resourceKeyPrefix = title + ".Tab.";
        String titleResource = this.getResourceMap().getString(resourceKeyPrefix + "text", null);
        if (titleResource != null) {
            title = titleResource;
        }
        this.fTabbedPane.addTab(title, this.getResourceMap().getULCIcon(resourceKeyPrefix + "icon"), this.fFormPane, this.getResourceMap().getString(resourceKeyPrefix + "tip", null));
    }

    private void doSetModel(T model) {
        this.fWidgetBinderManager.setModel(model);
        this.fModel = model;
    }

    private void doInitForm() {
        this.fFormPane = this.createFormPane();
        this.fFormPane.setBorder(this.createBorder(5, 10, 15, 10));
        this.initForm();
        for (FormBuilderPart part : this.fPart) {
            part.build();
        }
        this.finishCurrentPane();
        ((FormModel)this.getModel()).updatePresentationState();
        this.fRoundTripListener = new IRoundTripListener(){

            public void roundTripWillEnd(RoundTripEvent event) {
                AbstractFormBuilder.this.getWidgetBinderManager().updateFromModel();
            }

            public void roundTripDidStart(RoundTripEvent event) {
            }
        };
        ULCSession.currentSession().addRoundTripListener(this.fRoundTripListener);
        this.getErrorManager().upload();
    }

    public void dispose() {
        if (this.fRoundTripListener != null) {
            ULCSession.currentSession().removeRoundTripListener(this.fRoundTripListener);
            this.fRoundTripListener = null;
        }
    }

    public void replaceModel(T model) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.doSetModel(model);
        ((FormModel)this.getModel()).updatePresentationState();
    }

    protected void setColumnWeights(final float ... columnWeight) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                AbstractFormBuilder.access$1702(AbstractFormBuilder.this, columnWeight);
            }
        });
    }

    protected void setColumnWidths(final int ... columnWidths) {
        this.addPart(new FormBuilderPart(){

            protected void build() {
                AbstractFormBuilder.access$1802(AbstractFormBuilder.this, columnWidths);
            }
        });
    }

    private void setDefaultColumnWeight(int column, Integer weight) {
        while (this.fDefaultWeights.size() < column + 1) {
            this.fDefaultWeights.add(DEFAULT_COLUMN_WEIGHT);
        }
        this.fDefaultWeights.set(column, weight);
    }

    public ULCHasChangedEnabler getDirtyStateEnabler() {
        return this.fDirtyStateEnabler;
    }

    public ULCMandatoryAndEnabler getMandatoryEnabler() {
        return this.fMandatoryEnabler;
    }

    protected void setWidgetReadonly(ULCComponent widget, boolean editable) {
        if (widget instanceof ULCTextComponent) {
            ((ULCTextComponent)widget).setEditable(editable);
        } else {
            widget.setEnabled(editable);
        }
        widget.setFocusable(editable);
    }

    protected ApplicationContext getContext() {
        return Application.getInstance().getContext();
    }

    protected ResourceMap getResourceMap() {
        if (this.fResourceMap == null) {
            ResourceMap modelMap = this.getContext().getResourceMap(this.getModel().getClass(), FormModel.class);
            this.fResourceMap = this.getContext().getResourceMap(this.getClass(), AbstractFormBuilder.class, modelMap);
        }
        return this.fResourceMap;
    }

    static /* synthetic */ float[] access$1702(AbstractFormBuilder x0, float[] x1) {
        x0.fColumnWeights = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1802(AbstractFormBuilder x0, int[] x1) {
        x0.fColumnWidths = x1;
        return x1;
    }

    private static class WidgetStore
    implements Serializable {
        private ULCComponent fWidget;
        private final int fColumn;
        private final int fRow;
        private boolean fIsGrowingHorizontally;
        private int fNextStartColumn;
        private boolean fIsGrowingVertically;
        private boolean fAppended;

        private WidgetStore(ULCComponent widget, int column, int nextStartColumn, int row, boolean isGrowing, boolean isGrowingVertically) {
            this.fWidget = widget;
            this.fColumn = column;
            this.fNextStartColumn = nextStartColumn;
            this.fRow = row;
            this.fIsGrowingHorizontally = isGrowing;
            this.fIsGrowingVertically = isGrowingVertically;
            this.fAppended = false;
        }

        private ULCComponent getWidget() {
            return this.fWidget;
        }

        private int getColumn() {
            return this.fColumn;
        }

        private int getRow() {
            return this.fRow;
        }

        private boolean isGrowingVertically() {
            return this.fIsGrowingVertically;
        }

        private boolean isGrowingHorizontally() {
            return this.fIsGrowingHorizontally;
        }

        private void setLastColumn(int nextStartColumn) {
            this.fNextStartColumn = nextStartColumn;
        }

        private int getColumnSpan() {
            int span = this.fNextStartColumn - this.fColumn;
            return span < 0 ? 0 : span;
        }

        private String getAlingment() {
            return this.alignment(this.isGrowingHorizontally(), this.isGrowingVertically());
        }

        private String alignment(boolean growingHorizontally, boolean growingVertically) {
            return (growingHorizontally ? "e" : "l") + (growingVertically ? "e" : "c");
        }

        private void append(ULCComponent anotherWidget, boolean isGrowingHorizontally, boolean isGrowingVertically) {
            if (!this.fAppended) {
                ULCBoxPane widgetBox = new ULCBoxPane(false);
                widgetBox.add(this.alignment(this.isGrowingHorizontally(), this.isGrowingVertically()), this.fWidget);
                this.fIsGrowingHorizontally = true;
                this.fIsGrowingVertically = false;
                this.fWidget = widgetBox;
                this.fAppended = true;
            }
            ((ULCBoxPane)this.fWidget).add(this.alignment(isGrowingHorizontally, isGrowingVertically), anotherWidget);
        }
    }

    protected abstract class FormBuilderPart
    implements Serializable {
        protected FormBuilderPart() {
        }

        protected abstract void build();
    }
}

