/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form;

import com.ulcjava.applicationframework.application.form.WidgetFactory;
import com.ulcjava.base.application.ULCComponent;
import com.ulcjava.base.application.ULCLabel;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutParameter<T extends LayoutParameter<T, W, WF>, W extends ULCComponent, WF extends WidgetFactory>
implements Serializable {
    public static final int DEFAULT_LABEL_SPAN = 1;
    public static final int DEFAULT_START_COLUMN = 0;
    private final WF fWidgetFactory;
    private int fStartColumn;
    private int fEndColumn;
    private boolean fNotGrowing;
    private boolean fGrowVertical;
    private boolean fAppend;
    private boolean fReadonly;
    private boolean fStartNewRow;
    private int fEventDeliveryMode;
    private String fPropertyName;
    private W fWidget;
    private ULCLabel fLabel;
    private boolean fNoLabel;

    public LayoutParameter(WF widgetFactory) {
        this((String)null, widgetFactory);
    }

    public LayoutParameter(String propertyName, WF widgetFactory) {
        this(0, propertyName, widgetFactory);
    }

    public LayoutParameter(int startColumn, String propertyName, WF widgetFactory) {
        if (widgetFactory == null) {
            throw new IllegalArgumentException("widgetFactory must not be null");
        }
        this.fStartColumn = startColumn;
        this.fPropertyName = propertyName;
        this.fWidgetFactory = widgetFactory;
        this.init();
        this.fWidget = this.createWidget();
        if (this.getPropertyName() != null) {
            this.createLabel();
        }
    }

    public LayoutParameter(W widget, WF widgetFactory) {
        if (widgetFactory == null) {
            throw new IllegalArgumentException("widgetFactory must not be null");
        }
        this.fWidgetFactory = widgetFactory;
        this.fStartColumn = 0;
        this.fPropertyName = null;
        this.init();
        this.fWidget = widget;
    }

    private void init() {
        this.fEndColumn = -1;
        this.fNotGrowing = false;
        this.fGrowVertical = false;
        this.fAppend = false;
        this.fReadonly = false;
        this.fStartNewRow = false;
        this.fNoLabel = false;
        this.fEventDeliveryMode = -1;
    }

    protected abstract T getThis();

    protected abstract W createWidget();

    protected WF getWidgetFactory() {
        return this.fWidgetFactory;
    }

    private void createLabel() {
        this.fLabel = ((WidgetFactory)this.getWidgetFactory()).createLabel();
        this.fLabel.setName(this.getPropertyName() + ".Label");
        this.fLabel.setLabelFor((ULCComponent)this.getWidget());
    }

    public boolean isGrowingHorizontally() {
        return !this.isNotGrowing();
    }

    public boolean isNotGrowing() {
        return this.fNotGrowing;
    }

    public boolean isGrowingVertically() {
        return this.fGrowVertical;
    }

    public boolean isAppend() {
        return this.fAppend;
    }

    public boolean isReadonly() {
        return this.fReadonly;
    }

    public boolean isStartNewRow() {
        return this.fStartNewRow;
    }

    public int getStartColumn() {
        return this.fStartColumn;
    }

    public int getEndColumn() {
        return this.fEndColumn;
    }

    public boolean shouldStartRow() {
        return !this.isAppend() && this.getStartColumn() <= 0 || this.isStartNewRow();
    }

    public int getEventDeliveryMode(int defaultMode) {
        return this.fEventDeliveryMode < 0 ? defaultMode : this.fEventDeliveryMode;
    }

    public T startColumn(int startColumn) {
        this.fStartColumn = startColumn;
        return this.getThis();
    }

    public T endColumn(int endColumn) {
        this.fEndColumn = endColumn;
        return this.getThis();
    }

    public boolean isNoLabel() {
        return this.fNoLabel;
    }

    public T noLabel(boolean isNoLabel) {
        if (isNoLabel) {
            this.fLabel = null;
        }
        this.fNoLabel = isNoLabel;
        return this.getThis();
    }

    public String getLabelText() {
        return this.fLabel != null ? this.fLabel.getText() : null;
    }

    public T labelText(String labelText) {
        if (this.isNoLabel()) {
            throw new IllegalStateException("labelText cannot be set when noLabel is set");
        }
        if (this.fLabel == null) {
            this.createLabel();
        }
        this.fLabel.setText(labelText);
        return this.getThis();
    }

    public String getLabelName() {
        return this.fLabel != null ? this.fLabel.getName() : null;
    }

    public T labelName(String labelName) {
        if (this.isNoLabel()) {
            throw new IllegalStateException("labelName cannot be set when noLabel is set");
        }
        if (this.fLabel == null) {
            this.createLabel();
        }
        this.fLabel.setName(labelName);
        return this.getThis();
    }

    public ULCLabel getLabel() {
        return this.fLabel;
    }

    public String getPropertyName() {
        return this.fPropertyName;
    }

    public T propertyName(String propertyName) {
        this.fPropertyName = propertyName;
        return this.getThis();
    }

    public String getWidgetName() {
        return ((ULCComponent)this.getWidget()).getName();
    }

    public T widgetName(String widgetName) {
        ((ULCComponent)this.getWidget()).setName(widgetName);
        return this.getThis();
    }

    public T notGrowing(boolean isNotGrowing) {
        this.fNotGrowing = true;
        return this.getThis();
    }

    public T growVertical(boolean isGrowVertical) {
        this.fGrowVertical = true;
        return this.getThis();
    }

    public T append(boolean isAppend) {
        if (this.isStartNewRow()) {
            throw new IllegalStateException("append cannot be set when start new row is set");
        }
        this.fAppend = true;
        return this.getThis();
    }

    public T readOnly(boolean isReadOnly) {
        this.fReadonly = true;
        return this.getThis();
    }

    public T startNewRow(boolean isStartNewRow) {
        if (this.isAppend()) {
            throw new IllegalStateException("start new row cannot be set when append is set");
        }
        this.fStartNewRow = isStartNewRow;
        return this.getThis();
    }

    public T eventDeliveryMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("mode must be one of the UlcEventConstants Mode constants");
        }
        this.fEventDeliveryMode = mode;
        return this.getThis();
    }

    public T syncMode() {
        return this.eventDeliveryMode(0);
    }

    public T asyncMode() {
        return this.eventDeliveryMode(1);
    }

    public T deferredMode() {
        return this.eventDeliveryMode(2);
    }

    public W getWidget() {
        return this.fWidget;
    }

    protected void setWidget(W widget) {
        this.fWidget = widget;
    }

    public T style(String style) {
        ((ULCComponent)this.getWidget()).putClientProperty("ulc.style", style);
        return this.getThis();
    }

    public String getStyle() {
        return (String)((ULCComponent)this.getWidget()).getClientProperty("ulc.style");
    }
}

