/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form.model;

import com.ulcjava.applicationframework.application.AbstractBean;
import com.ulcjava.applicationframework.application.form.model.IMapper;
import com.ulcjava.applicationframework.application.form.model.IValidator;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.shared.ErrorObject;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.Logger;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormModel<T>
extends AbstractBean {
    private static final Logger LOG = Logger.getLogger(FormModel.class.getName());
    public static final String ERROR = "error";
    public static final String ENABLED = "enabled";
    public static final String MANDATORY = "mandatory";
    public static final String ILLEGAL_INPUT = "illegalInput";
    public static final String READONLY = "readonly";
    private final T fBean;
    private final Map<String, ErrorObject> fErrorObjectsByProperty;
    private final Map<String, ErrorObject> fIllegalInput;
    private final List<IValidator> fValidators;
    private final Map<Object, IMapper<?, ?>> fMappers;
    private final List<SetPropertyCommand> fChanges;
    private final BooleanPropertyState fEnabled;
    private final BooleanPropertyState fMandatory;
    private final BooleanPropertyState fReadonly;
    private boolean fDoClear;
    private final Set<String> fChangedProperties;

    public FormModel(T bean) {
        if (bean == null) {
            throw new IllegalArgumentException("bean must not be null");
        }
        this.fBean = bean;
        this.fDoClear = false;
        this.fEnabled = new BooleanPropertyState(true);
        this.fMandatory = new BooleanPropertyState(false);
        this.fReadonly = new BooleanPropertyState(false);
        this.fMappers = new HashMap();
        this.fValidators = new ArrayList<IValidator>();
        this.fChanges = new ArrayList<SetPropertyCommand>();
        this.fErrorObjectsByProperty = new HashMap<String, ErrorObject>();
        this.fIllegalInput = new HashMap<String, ErrorObject>();
        this.fChangedProperties = new HashSet<String>();
        this.initState();
        this.addMappers();
        this.initValidators();
        this.update(false);
    }

    protected void initState() {
    }

    protected void addMappers() {
    }

    protected IValidator[] createValidators() {
        return null;
    }

    private void initValidators() {
        IValidator[] validators = this.createValidators();
        if (validators != null) {
            for (IValidator validator : validators) {
                this.addValidator(validator);
            }
        }
    }

    public T getBean() {
        return this.fBean;
    }

    public void setProperty(SetPropertyCommand command) {
        Object oldValue;
        String propertyName = command.getPropertyName();
        ErrorObject illegalInputError = this.getIllegalInput(propertyName);
        Object object = oldValue = illegalInputError != null ? illegalInputError.getIllegalValue() : this.getProperty(propertyName);
        if (this.areDifferent(oldValue, command.getNewValue())) {
            this.clearChangedProperties();
            command.setOldValue(oldValue);
            this.performSetProperty(propertyName, command.getNewValue(), oldValue);
            this.addChange(command);
            this.update(true);
        }
    }

    protected void setProperty(String propertyName, Object newValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        Object oldValue = this.getProperty(propertyName);
        if (this.areDifferent(oldValue, newValue)) {
            this.performSetProperty(propertyName, newValue, oldValue);
        }
    }

    private void performSetProperty(String propertyName, Object newValue, Object oldValue) {
        try {
            Object modelValue = this.mapToModel(propertyName, newValue);
            try {
                PropertyUtils.setProperty(this.getBean(), (String)propertyName, (Object)modelValue);
            }
            catch (Exception e2) {
                PropertyUtils.setProperty((Object)this, (String)propertyName, (Object)modelValue);
            }
        }
        catch (Exception e3) {
            String message = "Error on setting property " + propertyName + " to ";
            message = newValue != null ? message + newValue.toString() + " (" + newValue.getClass().getName() + ")" : message + "<null>";
            LOG.log(Level.INFO, message);
            this.setIllegalInput(propertyName, new ErrorObject("ERROR_CODE.bad.format", newValue, new Object[]{propertyName}));
            return;
        }
        this.setIllegalInput(propertyName, null);
        PropertyChangeEvent propertyChangeEvent = this.isIndexedProperty(propertyName) ? new IndexedPropertyChangeEvent(this, propertyName, oldValue, newValue, this.getIndex(propertyName)) : new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.fChangedProperties.add(propertyName);
    }

    private boolean areDifferent(Object oldValue, Object newValue) {
        return oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
    }

    public void undo() throws PropertyAccessException {
        SetPropertyCommand propertyChange = this.getChanges().remove(this.getChanges().size() - 1);
        propertyChange.undo(this);
    }

    public void undoAll() throws PropertyAccessException {
        while (!this.getChanges().isEmpty()) {
            this.undo();
        }
    }

    public void resetUndo() {
        this.getChanges().clear();
    }

    public boolean hasChanges() {
        return !this.getChanges().isEmpty();
    }

    private List<SetPropertyCommand> getChanges() {
        return this.fChanges;
    }

    private void addChange(SetPropertyCommand command) {
        this.getChanges().add(command);
    }

    void update(boolean doValidate) {
        this.clearErrors();
        this.calculate();
        if (doValidate) {
            this.validate();
        }
        this.updatePresentationState();
    }

    public boolean canSave() {
        this.checkMandatoryFields();
        return !this.hasErrors();
    }

    private void checkMandatoryFields() {
        List<String> mandatoryProperties = this.getMandatoryProperties();
        for (String propertyName : mandatoryProperties) {
            try {
                Object propertyValue = this.getProperty(propertyName);
                if (propertyValue != null && propertyValue.toString().length() != 0) continue;
                this.setErrorForProperty(propertyName, new ErrorObject("ERROR_CODE.mandatory.field.not.filled", propertyValue));
            }
            catch (PropertyAccessException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public boolean areAllMandatoryFieldsSet() {
        List<String> mandatoryProperties = this.getMandatoryProperties();
        for (String propertyName : mandatoryProperties) {
            try {
                Object propertyValue = this.getProperty(propertyName);
                if (propertyValue != null && propertyValue.toString().length() != 0) continue;
                return false;
            }
            catch (PropertyAccessException e2) {
                throw new RuntimeException(e2);
            }
        }
        return true;
    }

    private List<String> getMandatoryProperties() {
        return new ArrayList<String>(this.fMandatory.getProperties());
    }

    public Object getProperty(String propertyName) throws PropertyAccessException {
        Object propertyValue;
        try {
            propertyValue = PropertyUtils.getProperty(this.getBean(), (String)propertyName);
        }
        catch (Exception e2) {
            if (!(e2 instanceof NoSuchMethodException)) {
                e2.printStackTrace();
            }
            try {
                propertyValue = PropertyUtils.getProperty((Object)this, (String)propertyName);
            }
            catch (Exception e22) {
                throw new PropertyAccessException("Error on getting property " + propertyName, e22);
            }
        }
        return this.mapToForm(propertyName, propertyValue);
    }

    public Class<?> getPropertyType(String propertyName) throws PropertyAccessException {
        try {
            Class propertyType = PropertyUtils.getPropertyType(this.getBean(), (String)propertyName);
            if (propertyType == null && (propertyType = PropertyUtils.getPropertyType((Object)this, (String)propertyName)) == null) {
                throw new PropertyAccessException("Error on getting property type of " + propertyName);
            }
            return propertyType;
        }
        catch (Exception e2) {
            throw new PropertyAccessException("Error on getting property type of " + propertyName, e2);
        }
    }

    public void addMapper(String propertyName, IMapper<?, ?> mapper) {
        this.getMappers().put(propertyName, mapper);
    }

    public void addMapper(Class<?> propertyType, IMapper<?, ?> mapper) {
        this.getMappers().put(propertyType, mapper);
    }

    private Object mapToModel(String propertyName, Object newValue) {
        IMapper<?, ?> mapper = this.getMapper(propertyName);
        if (mapper != null) {
            return mapper.mapToModel(newValue);
        }
        return newValue;
    }

    private Object mapToForm(String propertyName, Object value) {
        IMapper<?, ?> mapper = this.getMapper(propertyName);
        if (mapper != null) {
            return mapper.mapToForm(value);
        }
        return value;
    }

    protected Map<Object, IMapper<?, ?>> getMappers() {
        return this.fMappers;
    }

    protected IMapper<?, ?> getMapper(String propertyName) throws PropertyAccessException {
        IMapper<?, ?> mapper = this.getMappers().get(propertyName);
        if (mapper == null) {
            if (this.isIndexedProperty(propertyName)) {
                mapper = this.getMappers().get(propertyName.substring(0, propertyName.lastIndexOf(91)));
            }
            if (mapper == null) {
                mapper = this.getMappers().get(this.getPropertyType(propertyName));
            }
        }
        return mapper;
    }

    private boolean isIndexedProperty(String propertyName) {
        return propertyName.charAt(propertyName.length() - 1) == ']';
    }

    private int getIndex(String propertyName) {
        int startOfIndex = propertyName.lastIndexOf(91);
        if (startOfIndex < 0) {
            return -1;
        }
        return Integer.parseInt(propertyName.substring(startOfIndex + 1, propertyName.length() - 1));
    }

    public void setErrorForProperty(String propertyName, ErrorObject error) {
        this.setProperty(FormModel.getErrorStatePropertyName(propertyName), error);
    }

    public void setError(String propertyName, ErrorObject error) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        ErrorObject oldError = this.getError(propertyName);
        if (oldError == null && error != null || oldError != null && !oldError.equals(error)) {
            if (error == null) {
                this.getErrorObjectsByPropertyMap().remove(propertyName);
            } else {
                this.getErrorObjectsByPropertyMap().put(propertyName, error);
            }
            this.firePropertyChange(FormModel.getErrorStatePropertyName(propertyName), oldError, error);
        }
    }

    public void clearError(String propertyName) {
        this.setProperty(FormModel.getErrorStatePropertyName(propertyName), null);
    }

    public boolean hasErrors() {
        return this.getErrorObjectsByPropertyMap().size() > 0;
    }

    public ErrorObject getError(String propertyName) {
        return this.getErrorObjectsByPropertyMap().get(propertyName);
    }

    protected Map<String, ErrorObject> getErrorObjectsByPropertyMap() {
        return this.fErrorObjectsByProperty;
    }

    protected void clearErrors() {
        Map<String, ErrorObject> errorMap = this.getErrorObjectsByPropertyMap();
        Set<String> keySet = errorMap.keySet();
        ArrayList<String> keys = new ArrayList<String>(keySet.size());
        for (String propertyName : keySet) {
            keys.add(propertyName);
        }
        for (String propertyName : keys) {
            this.clearError(propertyName);
        }
    }

    private void validate() {
        Set<Map.Entry<String, ErrorObject>> entrySet = this.getIllegalInput().entrySet();
        for (Map.Entry<String, ErrorObject> entry : entrySet) {
            String propertyName = entry.getKey();
            this.setError(propertyName, entry.getValue());
        }
        List<IValidator> validators = this.getValidators();
        for (IValidator validator : validators) {
            validator.validate(this);
        }
    }

    protected void calculate() {
    }

    public void updatePresentationState() {
    }

    protected void setMandatory(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.setMandatory(propertyName, true);
        }
    }

    protected void setReadonly(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.setReadonly(propertyName, true);
        }
    }

    protected void setDisabled(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.setEnabled(propertyName, false);
        }
    }

    public Boolean getEnabled(String propertyName) {
        return this.fEnabled.getState(propertyName);
    }

    protected void setEnabled(String propertyName, Boolean isEnabled) {
        Boolean oldState = this.fEnabled.getState(propertyName);
        if (!oldState.equals(isEnabled)) {
            this.fEnabled.setState(propertyName, isEnabled);
            this.firePropertyChange(FormModel.getEnabledStatePropertyName(propertyName), oldState, isEnabled);
        }
    }

    public Boolean getMandatory(String propertyName) {
        return this.fMandatory.getState(propertyName);
    }

    protected void setMandatory(String propertyName, Boolean isMandatory) {
        Boolean oldState = this.fMandatory.getState(propertyName);
        if (!oldState.equals(isMandatory)) {
            this.fMandatory.setState(propertyName, isMandatory);
            this.firePropertyChange(FormModel.getMandatoryStatePropertyName(propertyName), oldState, isMandatory);
        }
    }

    public Boolean getReadonly(String propertyName) {
        if (!PropertyUtils.isWriteable(this.getBean(), (String)propertyName) && !PropertyUtils.isWriteable((Object)this, (String)propertyName)) {
            return true;
        }
        return this.fReadonly.getState(propertyName);
    }

    protected void setReadonly(String propertyName, Boolean isReadonly) {
        Boolean oldState = this.fReadonly.getState(propertyName);
        if (!oldState.equals(isReadonly)) {
            this.fReadonly.setState(propertyName, isReadonly);
            this.firePropertyChange(FormModel.getReadonlyStatePropertyName(propertyName), oldState, isReadonly);
        }
    }

    public void addEnabledStateListener(String propertyName, PropertyChangeListener enabledStateListener) {
        this.addPropertyChangeListener(FormModel.getEnabledStatePropertyName(propertyName), enabledStateListener);
    }

    public void addReadonlyStateListener(String propertyName, PropertyChangeListener readOnlyStateListener) {
        this.addPropertyChangeListener(FormModel.getReadonlyStatePropertyName(propertyName), readOnlyStateListener);
    }

    public void addMandatoryStateListener(String propertyName, PropertyChangeListener mandatoryStateListener) {
        this.addPropertyChangeListener(FormModel.getMandatoryStatePropertyName(propertyName), mandatoryStateListener);
    }

    public void addErrorStateListener(String propertyName, PropertyChangeListener errorStateListener) {
        this.addPropertyChangeListener(FormModel.getErrorStatePropertyName(propertyName), errorStateListener);
    }

    public void removeEnabledStateListener(String propertyName, PropertyChangeListener enabledStateListener) {
        this.removePropertyChangeListener(FormModel.getEnabledStatePropertyName(propertyName), enabledStateListener);
    }

    public void removeReadonlyStateListener(String propertyName, PropertyChangeListener readOnlyStateListener) {
        this.removePropertyChangeListener(FormModel.getReadonlyStatePropertyName(propertyName), readOnlyStateListener);
    }

    public void removeMandatoryStateListener(String propertyName, PropertyChangeListener mandatoryStateListener) {
        this.removePropertyChangeListener(FormModel.getMandatoryStatePropertyName(propertyName), mandatoryStateListener);
    }

    public void removeErrorStateListener(String propertyName, PropertyChangeListener errorStateListener) {
        this.removePropertyChangeListener(FormModel.getErrorStatePropertyName(propertyName), errorStateListener);
    }

    public static String getErrorStatePropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        return "error(" + propertyName + ")";
    }

    public static String getEnabledStatePropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        return "enabled(" + propertyName + ")";
    }

    public static String getReadonlyStatePropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        return "readonly(" + propertyName + ")";
    }

    public static String getMandatoryStatePropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        return "mandatory(" + propertyName + ")";
    }

    public static String getIllegalInputPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        return "illegalInput(" + propertyName + ")";
    }

    public void addValidator(IValidator validator) {
        this.getValidators().add(validator);
    }

    protected List<IValidator> getValidators() {
        return this.fValidators;
    }

    protected boolean hasChanged(String propertyName) {
        return this.fChangedProperties.contains(propertyName);
    }

    private void clearChangedProperties() {
        this.fChangedProperties.clear();
    }

    public ErrorObject getIllegalInput(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        return this.getIllegalInput().get(propertyName);
    }

    public void setIllegalInput(String propertyName, ErrorObject error) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName must not be null");
        }
        ErrorObject oldError = this.getIllegalInput(propertyName);
        if (oldError == null && error != null || oldError != null && !oldError.equals(error)) {
            if (error == null) {
                this.getIllegalInput().remove(propertyName);
            } else {
                this.getIllegalInput().put(propertyName, error);
            }
            this.firePropertyChange(FormModel.getIllegalInputPropertyName(propertyName), oldError, error);
        }
    }

    protected Map<String, ErrorObject> getIllegalInput() {
        return this.fIllegalInput;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanPropertyState
    implements Serializable {
        private final Boolean fValue;
        private final Set<String> fPropertiesNotInDefaultState;

        public BooleanPropertyState(boolean defaultValue) {
            this.fValue = !defaultValue;
            this.fPropertiesNotInDefaultState = new HashSet<String>();
        }

        public Boolean getState(String propertyName) {
            if (propertyName == null) {
                throw new IllegalArgumentException("propertyName must not be null");
            }
            if (this.fPropertiesNotInDefaultState.contains(propertyName)) {
                return this.fValue;
            }
            return this.fValue == false;
        }

        public void setState(String propertyName, Boolean value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            if (propertyName == null) {
                throw new IllegalArgumentException("propertyName must not be null");
            }
            if (this.fValue.booleanValue() == value.booleanValue()) {
                this.fPropertiesNotInDefaultState.add(propertyName);
            } else {
                this.fPropertiesNotInDefaultState.remove(propertyName);
            }
        }

        public Collection<? extends String> getProperties() {
            return new ArrayList<String>(this.fPropertiesNotInDefaultState);
        }
    }
}

