/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.applicationframework.application.form.model;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.IValidator;
import com.ulcjava.base.shared.ErrorObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyValidator<T>
implements IValidator {
    private final String[] fProperties;

    public PropertyValidator(String ... propertyNames) {
        if (propertyNames == null) {
            throw new IllegalArgumentException("propertyNames must not be null");
        }
        for (String propertyName : propertyNames) {
            if (propertyName != null) continue;
            throw new IllegalArgumentException("propertyName must not be null");
        }
        this.fProperties = propertyNames;
    }

    public String[] getProperties() {
        return this.fProperties;
    }

    @Override
    public void validate(FormModel<?> formModel) {
        String[] properties;
        for (String propertyName : properties = this.getProperties()) {
            this.validate(propertyName, formModel);
        }
    }

    public void validate(String propertyName, FormModel<?> formModel) {
        Object value = formModel.getProperty(propertyName);
        String errorCode = this.validateValue(value);
        if (errorCode != null) {
            formModel.setErrorForProperty(propertyName, this.createError(propertyName, value, errorCode));
        }
    }

    protected ErrorObject createError(String propertyName, T illegalValue, String errorCode) {
        return new ErrorObject(errorCode, illegalValue);
    }

    public abstract String validateValue(T var1);
}

