/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.applicationframework.application.ILocaleProvider;
import com.ulcjava.applicationframework.application.ResourceManager;
import com.ulcjava.applicationframework.application.ResourceMap;
import com.ulcjava.applicationframework.application.StaticLocaleProvider;
import com.ulcjava.base.server.ApplicationConfiguration;
import com.ulcjava.base.shared.internal.ClassUtilities;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.Logger;
import java.util.Locale;

public class DeploymentParameter {
    private static final Logger LOG = Logger.getLogger(DeploymentParameter.class.getName());
    public static final String DEPLOYMENT_PARAMETER_KEY_PREFIX = "Application";
    public static final String DEPLOYMENT_PARAMETER_TITLE = "Application.title";
    public static final String DEPLOYMENT_PARAMETER_VENDOR = "Application.vendor";
    public static final String DEPLOYMENT_PARAMETER_HOMEPAGE = "Application.homepage";
    public static final String DEPLOYMENT_PARAMETER_DESCRIPTION = "Application.description";
    public static final String DEPLOYMENT_PARAMETER_ICON = "Application.icon";
    public static final String DEPLOYMENT_PARAMETER_SPLASH = "Application.splash";
    public static final String DEPLOYMENT_PARAMETER_MENU_GROUP = "Application.menu_group";
    private final Locale fLocale;
    private ResourceMap fResourceMap;

    public DeploymentParameter(Locale locale) {
        this.fLocale = locale;
    }

    public String getTitle() {
        return this.getResourceMap().getString(DEPLOYMENT_PARAMETER_TITLE, new Object[0]);
    }

    public String getVendor() {
        return this.getResourceMap().getString(DEPLOYMENT_PARAMETER_VENDOR, new Object[0]);
    }

    public String getHomepage() {
        return this.getResourceMap().getString(DEPLOYMENT_PARAMETER_HOMEPAGE, new Object[0]);
    }

    public String getDescription() {
        return this.getResourceMap().getString(DEPLOYMENT_PARAMETER_DESCRIPTION, new Object[0]);
    }

    public String getIcon(int size) {
        return this.toResourcePath("Application.icon." + size);
    }

    public String getFavIcon() {
        String icon = this.getIcon(16);
        icon = icon != null ? icon : this.getIcon(32);
        icon = icon != null ? icon : this.getIcon(64);
        return icon;
    }

    private String toResourcePath(String iconKey) {
        ResourceMap resourceMap = this.getResourceMap();
        String iconPath = resourceMap.getString(iconKey, new Object[0]);
        return iconPath != null ? resourceMap.getResourcesDir() + iconPath : null;
    }

    public String getSplash() {
        return this.toResourcePath(DEPLOYMENT_PARAMETER_SPLASH);
    }

    public String getMenuGroup() {
        return this.getResourceMap().getString(DEPLOYMENT_PARAMETER_MENU_GROUP, new Object[0]);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    protected ResourceMap getResourceMap() {
        if (this.fResourceMap == null) {
            this.fResourceMap = this.createResourceMap();
        }
        return this.fResourceMap;
    }

    protected ResourceMap createResourceMap() {
        try {
            Class applicationClass = ClassUtilities.forName(ApplicationConfiguration.getInstance().getApplicationClassName());
            ResourceManager resourceManager = new ResourceManager(applicationClass){

                protected ILocaleProvider getLocaleProvider() {
                    return new StaticLocaleProvider(DeploymentParameter.this.getLocale());
                }
            };
            ResourceMap resourceMap = resourceManager.getResourceMap();
            return resourceMap;
        }
        catch (ClassNotFoundException e2) {
            String msg = "Application class not found";
            LOG.log(Level.SEVERE, msg, e2);
            throw new RuntimeException(msg, e2);
        }
    }
}

