/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.environment.applet.client;

import com.ulcjava.base.client.IConnector;
import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.launcher.ApplicationConfigurationBasedClientConfiguration;
import com.ulcjava.base.client.launcher.LauncherUtilities;
import com.ulcjava.base.client.launcher.ServiceFactory;
import com.ulcjava.base.shared.IClientConfiguration;
import com.ulcjava.base.shared.internal.IllegalArgumentException;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.LogManager;
import com.ulcjava.base.shared.logging.Logger;
import com.ulcjava.base.shared.logging.SimpleLogManager;
import com.ulcjava.base.shared.streamcoder.CoderConfiguration;
import com.ulcjava.container.servlet.client.AppletRequestPropertyStore;
import com.ulcjava.container.servlet.client.ServletConnector;
import com.ulcjava.environment.applet.client.AbstractAppletLauncher;
import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;

public class DefaultAppletLauncher
extends AbstractAppletLauncher {
    private IClientConfiguration fClientConfiguration;
    private static final Logger LOG = Logger.getLogger(DefaultAppletLauncher.class.getName());

    protected IConnector createConnector() {
        String urlString = this.getUrlString();
        int keepAliveInterval = this.getKeepAliveInterval();
        String dataStreamProviderclassName = this.getDataStreamProviderClassName();
        String carrierStreamProviderClassName = this.getCarrierStreamProviderClassName();
        String clientRegistryProviderClassName = this.getClientCoderRegistryProviderClassName();
        try {
            return new ServletConnector(new AppletRequestPropertyStore(), new URL(urlString), keepAliveInterval, dataStreamProviderclassName, carrierStreamProviderClassName, clientRegistryProviderClassName, this.getClientConfiguration());
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException("Malformed URL: " + urlString, e2);
        }
    }

    public void init() {
        super.init();
        try {
            this.fClientConfiguration = new ApplicationConfigurationBasedClientConfiguration(this.getUrlString());
        }
        catch (RuntimeException e1) {
            this.fClientConfiguration = new AppletBasedClientConfiguration();
        }
        String logLevel = this.getLogLevel();
        if (logLevel != null && LogManager.getLogManager() instanceof SimpleLogManager) {
            SimpleLogManager simpleLogManager = (SimpleLogManager)LogManager.getLogManager();
            simpleLogManager.setLevel(Level.parse(logLevel));
        }
        ServiceFactory.configureServices(this.getClientConfiguration());
    }

    public void start() {
        LauncherUtilities.setLookAndFeel(this.getClientConfiguration());
        SwingUtilities.updateComponentTreeUI(this.getRootPane());
        super.start();
        String functionToCall = this.getParameter("callscript");
        if (functionToCall != null) {
            try {
                JSObject jso = JSObject.getWindow((Applet)this);
                jso.call(functionToCall, new Object[0]);
            }
            catch (Throwable ignored) {
                LOG.log(Level.SEVERE, "Calling " + functionToCall + " failed:", ignored);
            }
        }
    }

    protected ISessionStateListener createSessionStateListener() {
        return LauncherUtilities.createSessionStateListener(this.getClientConfiguration());
    }

    protected String getUrlString() {
        return this.getParameter("url-string");
    }

    protected int getKeepAliveInterval() {
        return this.getClientConfiguration().getKeepAliveInterval();
    }

    protected String getLogLevel() {
        return this.getClientConfiguration().getClientLogLevel();
    }

    protected IClientConfiguration getClientConfiguration() {
        return this.fClientConfiguration;
    }

    protected String getDataStreamProviderClassName() {
        return this.getClientConfiguration().getDataStreamProviderClassName();
    }

    protected String getCarrierStreamProviderClassName() {
        return this.getClientConfiguration().getCarrierStreamProviderClassName();
    }

    protected String getClientCoderRegistryProviderClassName() {
        return this.getClientConfiguration().getClientCoderRegistryProviderClassName();
    }

    public String[][] getParameterInfo() {
        String[][] superParameterInfo = super.getParameterInfo();
        String[][] result = new String[superParameterInfo.length + 5][];
        System.arraycopy(superParameterInfo, 0, result, 0, superParameterInfo.length);
        String deprecatedMessage = " (This parameter is deprecated - use the ULCApplicationConfiguration.xml file instead)";
        result[superParameterInfo.length] = new String[]{"url-string", "url", "url identifying the application to connect to" + deprecatedMessage};
        result[superParameterInfo.length + 1] = new String[]{"keep-alive-interval", ">0", "interval in seconds to post keep alive requests" + deprecatedMessage};
        result[superParameterInfo.length + 2] = new String[]{"log-level", "level", "log level for Logger implementation in SimpleLogManager" + deprecatedMessage};
        result[superParameterInfo.length + 3] = new String[]{"carrier-stream-provider", "class name", "the carrier stream provider" + deprecatedMessage};
        result[superParameterInfo.length + 4] = new String[]{"client-coder-registry-provider", "class name", "the client-side coder registry provider" + deprecatedMessage};
        return result;
    }

    private class AppletBasedClientConfiguration
    implements IClientConfiguration {
        private AppletBasedClientConfiguration() {
        }

        public String getBrowserServiceClassName() {
            return null;
        }

        public String getCarrierStreamProviderClassName() {
            return DefaultAppletLauncher.this.getParameter("carrier-stream-provider");
        }

        public String getClientCoderRegistryProviderClassName() {
            return DefaultAppletLauncher.this.getParameter("client-coder-registry-provider");
        }

        public String getDataStreamProviderClassName() {
            return DefaultAppletLauncher.this.getParameter("data-stream-provider");
        }

        public String getClientLogLevel() {
            return DefaultAppletLauncher.this.getParameter("log-level");
        }

        public String getFileServiceClassName() {
            return null;
        }

        public Integer getKeepAliveInterval() {
            try {
                String keepAliveIntervalValue = DefaultAppletLauncher.this.getParameter("keep-alive-interval");
                if (keepAliveIntervalValue == null) {
                    return new Integer(900);
                }
                return new Integer(keepAliveIntervalValue);
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Parameter 'keep-alive-interval' must be an integer.");
            }
        }

        public String getLookAndFeel() {
            return null;
        }

        public String getMessageServiceClassName() {
            return null;
        }

        public String getClientSessionErrorHandlerClassName() {
            return null;
        }

        public CoderConfiguration[] getClientCoderConfigurations() {
            return null;
        }
    }
}

