/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.environment.jnlp.client;

import com.ulcjava.base.client.IBrowserService;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class JnlpBrowserService
implements IBrowserService {
    private static final Logger LOG = Logger.getLogger("com.ulcjava.environment.jnlp.client");

    public void showDocument(String urlString, String target) {
        this.showDocument(urlString);
    }

    public void showDocument(String urlString) {
        try {
            LOG.log(Level.FINEST, "Executing BasicService.showDocument(new URL(\"" + urlString + "\"))");
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            basicService.showDocument(new URL(urlString));
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Invalid url " + urlString, e);
        }
        catch (UnavailableServiceException e) {
            LOG.log(Level.WARNING, "JNLP BasicService not available", e);
        }
    }
}

