/*
 * Decompiled with CFR 0.152.
 */
package com.ulcjava.environment.standalone.client;

import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.launcher.LauncherUtilities;
import com.ulcjava.base.client.launcher.ServiceFactory;
import com.ulcjava.base.shared.IClientConfiguration;
import com.ulcjava.base.shared.internal.IllegalArgumentException;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.LogManager;
import com.ulcjava.base.shared.logging.SimpleLogManager;
import com.ulcjava.container.servlet.client.CookieRequestPropertyStore;
import com.ulcjava.container.servlet.client.ServletConnector;
import com.ulcjava.environment.standalone.client.AbstractStandaloneLauncher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class DefaultStandaloneLauncher
extends AbstractStandaloneLauncher {
    private final IClientConfiguration fClientConfiguration;

    public DefaultStandaloneLauncher() {
        this(null);
    }

    public DefaultStandaloneLauncher(IClientConfiguration clientConfiguration) {
        this.fClientConfiguration = clientConfiguration;
        ServiceFactory.configureServices(clientConfiguration);
    }

    public static void main(String[] args) throws MalformedURLException {
        if (args.length < 1) {
            throw new IllegalArgumentException("Usage: \n\turl-string=<url> the ULC application URL string\n\t[keep-alive-interval=<interval in secs>] the keep alive interval (optional)\n\t[log-level=<log level>] the log level (optional)\n\t[carrier-stream-provider=<class name>] the carrier stream provider (optional)\n\t[client-coder-registry-provider=<class name>] the client-side coder registry provider (optional)\n\t[data-stream-provider=<class name>] the data stream provider (optional)\n\t{<key>=<value>} the user parameters (optional, multiple allowed)\n");
        }
        Properties launcherArguments = LauncherUtilities.parseLauncherArguments(args);
        IClientConfiguration clientConfiguration = LauncherUtilities.getClientConfiguration(launcherArguments);
        String urlString = LauncherUtilities.getUrlString(launcherArguments);
        int keepAliveInterval = clientConfiguration.getKeepAliveInterval();
        String logLevel = clientConfiguration.getClientLogLevel();
        String dataStreamProviderClassName = clientConfiguration.getDataStreamProviderClassName();
        String carrierStreamProviderClassName = clientConfiguration.getCarrierStreamProviderClassName();
        String clientCoderRegistryProviderClassName = clientConfiguration.getClientCoderRegistryProviderClassName();
        LauncherUtilities.setLookAndFeel(clientConfiguration);
        Properties userParameters = LauncherUtilities.getUserParameters(launcherArguments);
        if (logLevel != null && LogManager.getLogManager() instanceof SimpleLogManager) {
            SimpleLogManager simpleLogManager = (SimpleLogManager)LogManager.getLogManager();
            simpleLogManager.setLevel(Level.parse(logLevel));
        }
        DefaultStandaloneLauncher launcher = new DefaultStandaloneLauncher(clientConfiguration);
        URL url = new URL(urlString);
        launcher.start(new ServletConnector(new CookieRequestPropertyStore(url), url, keepAliveInterval, dataStreamProviderClassName, carrierStreamProviderClassName, clientCoderRegistryProviderClassName, clientConfiguration), userParameters);
    }

    public IClientConfiguration getClientConfiguration() {
        return this.fClientConfiguration;
    }

    protected ISessionStateListener createSessionStateListener() {
        return LauncherUtilities.createSessionStateListener(this.getClientConfiguration());
    }
}

