/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application;

import com.ulcjava.base.application.ULCRootPane;
import com.ulcjava.environment.applet.application.ULCAppletPane;

import java.io.Serializable;

/**
 * View that is used as the {@link SingleFrameApplication}'s main view when the {@link Application} runs in an Applet.
 */
public class AppletView extends View implements Serializable {

    private ULCAppletPane fAppletPane;

    /**
     * Creates an {@code AppletView} for the given {@link Application}
     * 
     * @param application the application that is running.
     */
    public AppletView(Application application) {
        super(application);
    }

    /**
     * @see com.ulcjava.applicationframework.application.View#getRootPane()
     */
    @Override
    public ULCRootPane getRootPane() {
        return getAppletPane();
    }
    
    /**
     * Returns the {@link ULCAppletPane} instance. The name of the Applet pane is set to "<b>main.AppletPane</b>". This can be used to
     * inject properties on the pane.
     * 
     * @see ResourceMap#injectComponent(com.ulcjava.base.application.ULCComponent)
     * @return the applet pane that acts as the root pane.
     */
    public ULCAppletPane getAppletPane() {
        if (fAppletPane == null) {
            ULCAppletPane appletPane = ULCAppletPane.getInstance();
            appletPane.setName("main.AppletPane");
            fAppletPane = appletPane;
        }
        return fAppletPane;
    }

}
