/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application;

import java.io.Serializable;
import java.util.Locale;

/**
 * Always returns the locale that is used to create an instance.
 */
public class StaticLocaleProvider implements ILocaleProvider, Serializable {
    
    private Locale fLocale;
    
    /**
     * Creates a LocaleProvider that provides always the given Locale.
     * 
     * @param locale the Locale that is provided.
     */
    public StaticLocaleProvider(Locale locale) {
        fLocale = locale;
    }
    
    public Locale getLocale() {
        return fLocale;
    }
    
}
