/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.application.ULCComboBox;
import com.ulcjava.base.application.event.ActionEvent;
import com.ulcjava.base.application.event.IActionListener;

/**
 * Binds a {@link ULCComboBox} to a {@link FormModel} property.
 */
public class ComboBoxBinder extends AbstractWidgetBinder<ULCComboBox> {
    /**
     * Creates a binding between the given {@link ULCComboBox} and the given property.
     * 
     * @param model that holds the property. Must not be <code>null</code>.
     * @param propertyName name of the property to be bound. Must not be <code>null</code>.
     * @param comboBox to be bound. Must not be <code>null</code>.
     */
    public ComboBoxBinder(FormModel<?> model, String propertyName, ULCComboBox comboBox) {
        super(model, propertyName, comboBox);

        comboBox.addActionListener(new IActionListener() {
            public void actionPerformed(ActionEvent event) {
                try {
                    getModel().setProperty(new SetPropertyCommand(getPropertyName(), getComboBox().getSelectedItem()));
                } catch (PropertyAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /**
     * @return the {@link ULCComboBox} that is bound.
     */
    protected ULCComboBox getComboBox() {
        return getWidget();
    }


    public void updateValueFromModel(FormModel<?> model) {
        try {
            getComboBox().setSelectedItem(model.getProperty(getPropertyName()));
        } catch (PropertyAccessException e) {
            throw new RuntimeException(e);
        }
    }

}
