/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding;

import com.ulcjava.applicationframework.application.form.model.FormModel;
import com.ulcjava.applicationframework.application.form.model.PropertyAccessException;
import com.ulcjava.applicationframework.application.form.model.SetPropertyCommand;
import com.ulcjava.base.application.ULCSpinner;
import com.ulcjava.base.application.event.IValueChangedListener;
import com.ulcjava.base.application.event.ValueChangedEvent;

/**
 * Binds a {@link ULCSpinner} to a {@link FormModel} property.
 */
public class SpinnerBinder extends AbstractWidgetBinder<ULCSpinner> {
    /**
     * Creates a binding between the given {@link ULCSpinner} and the given property.
     * 
     * @param model that holds the property. Must not be <code>null</code>.
     * @param propertyName name of the property to be bound. Must not be <code>null</code>.
     * @param spinner to be bound. Must not be <code>null</code>.
     */
    public SpinnerBinder(FormModel<?> model, String propertyName, ULCSpinner spinner) {
        super(model, propertyName, spinner);
        getULCSpinner().addValueChangedListener(new IValueChangedListener() {

            public void valueChanged(ValueChangedEvent event) {
                try {
                    getModel().setProperty(new SetPropertyCommand(getPropertyName(), getULCSpinner().getValue()));
                } catch (PropertyAccessException e) {
                    throw new RuntimeException(e);
                }
            }

        });
    }

    /**
     * @return the {@link ULCSpinner} that is bound.
     */
    protected ULCSpinner getULCSpinner() {
        return getWidget();
    }

    public void updateValueFromModel(FormModel<?> model) {
        try {
            Object value = model.getProperty(getPropertyName());
            setValueOnSpinner(value);
        } catch (PropertyAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setValueOnSpinner(Object value) {
        if (value != null) {
            getULCSpinner().setValue(value);
        }
    }

}
