/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.binding.table;

import java.util.List;

/**
 * The interface for an observable list. It provides additional functionality to add and remove
 * <code>ObservableListListeners</code>
 * 
 * @param <T> The formal type of the list elements
 */
public interface ObservableList<T> extends List<T> {

    /**
     * Adds a <code>ObservableListListner</code> to the <code>ObservableList</code>.
     * 
     * @param listener the <code>ObservableListListner</code> to be added to the <code>ObservableList</code>
     */
    public void addObservableListListener(ObservableListListener<T> listener);

    /**
     * Removes a <code>ObservableListListner</code> from the <code>ObservableList</code>.
     * 
     * @param listener the <code>ObservableListListner</code> to be removed from the <code>ObservableList</code>
     */
    public void removeObservableListListener(ObservableListListener<T> listener);
}
