/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form.model;

import java.io.Serializable;

/**
 * Defines the interface for classes that can map data between the form and the model by converting the type of the
 * model property into the type the form's widget needs, and vice versa.
 * 
 * @param <ModelType> The generic type that defines data's type in the model
 * @param <FormType> The generic type that defines data's type in the form
 */
public interface IMapper<ModelType, FormType> extends Serializable {
    /**
     * Converts the value from the form's widget into an object that can be set on the model's properties.
     * 
     * @param fromForm object from the form.
     * @return the object to set on the property of the model
     */
    ModelType mapToModel(FormType fromForm);

    /**
     * Converts the value from the model's property into an object that can be set on the form's widget.
     * 
     * @param fromModel object from the model.
     * @return the object to set into the form's widget. Must not be <code>null</code>
     */
    FormType mapToForm(ModelType fromModel);
}
