/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.applicationframework.application.form.model;

import java.io.Serializable;

import com.ulcjava.base.shared.ErrorObject;

/**
 * Defines the interface for classes that can validate a FormModel. The validate method will be called by the FormModel
 * with itself as parameter. If the IValidator detects an error, it should set an appropriate {@link ErrorObject} on the
 * FormModel.
 * 
 * @see FormModel#createValidators()
 * @see FormModel#addValidator(IValidator)
 */
public interface IValidator extends Serializable {
    /**
     * Performs one or several checks on the given FormModel. If a check fails, an appropriate {@link ErrorObject} is
     * created and set on the formModel for the affected properties.
     * 
     * @param formModel the FromModel to validate.
     * @see FormModel#setError(String, ErrorObject)
     */
    public void validate(FormModel<?> formModel);


}
