package com.ulcjava.base.application;


	/**
	* This class provides a default implementation for the <code>IAction</code>
	* interface.
<p>
</p>
<b>Features</b>
<ul>
<li>One or more text strings to
	* describe the action.
<li>One or more icons that visualize the
	* action.
<li>Setting the enabled/disabled state of the action instead of
	* disabling the components individually.
</ul>
<b>Examples</b>
<p>
</p>
The
	* following code snippet shows the implementation of an action

<pre>
private
	* static class OkAction extends AbstractAction {
public OkAction()
	* {
putValue(IAction.NAME, &quot;Ok&quot;);
putValue(IAction.MNEMONIC_KEY, new
	* Integer('O'));
}

public void actionPerformed(ActionEvent event)
	* {
System.out.println(&quot;Ok Action performed&quot;);
}
}
</pre>

The
	* following example shows how the same action is set to a button and to a menu
	* item.

<pre>
ULCButton button = new ULCButton(new OkAction());
ULCMenuItem
	* item = new ULCMenuItem();
item.setAction(new OkAction());
</pre>

<p>
</p>
	*
	* @ulc.application		
	* @see		IAction
	* @see		ULCAbstractButton
	* @see		ULCButton
	* @see		ULCCheckBox
	* @see		ULCCheckBoxMenuItem
	* @see		ULCComboBox
	* @see		ULCMenu
	* @see		ULCMenuItem
	* @see		ULCRadioButton
	* @see		ULCRadioButtonMenuItem
	* @see		ULCTextField
	* @see		ULCToggleButton
	**/
 public  abstract class AbstractAction extends java.lang.Object implements java.io.Serializable, com.ulcjava.base.application.IAction
{


	/**
	* Creates an action with no keys defined. The action is enabled by default.
	*
	**/
	 public AbstractAction()
	{
		 super();
	}


	/**
	* Creates an action with the name set as the value for the Action.NAME key. The
	* action is enabled by default.
	*
	* @param name 		 the name of the action
	**/
	 public AbstractAction(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates an action with the name set as the value for the Action.NAME key and
	* the icon as the value for the Action.SMALL_ICON key. The
action is enabled by
	* default.
	*
	* @param name 		 the name of the action
	* @param icon 		 the icon of the action
	**/
	 public AbstractAction(java.lang.String name, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}

	 public void putValue(java.lang.String key, java.lang.Object value)
	{
	}

	 public java.lang.Object getValue(java.lang.String key)
	{
		return null;
	}

	 public void setEnabled(boolean enabled)
	{
	}

	 public boolean isEnabled()
	{
		return false;
	}

	 public void setEnabler(com.ulcjava.base.application.enabler.IEnabler enabler)
	{
	}

	 public com.ulcjava.base.application.enabler.IEnabler getEnabler()
	{
		return null;
	}

	 public void addPropertyChangeListener(java.beans.PropertyChangeListener listener)
	{
	}

	 public void removePropertyChangeListener(java.beans.PropertyChangeListener listener)
	{
	}


	/**
	* Returns an array containing the keys defined for this action.
	*
	* @return		an <code>String[]</code> array containing the keys defined for this action
	**/
	 public java.lang.String[] getKeys()
	{
		return null;
	}


	/**
	* Returns an array of <code>PropertyChangesListeners</code> currently registered
	* with this action.
	*
	* @return		a <code>PropertyChangeListener[]</code> array containing the currently registered listeners
	**/
	 public java.beans.PropertyChangeListener[] getPropertyChangeListeners()
	{
		return null;
	}


	/**
	* Notifies the attached <code>PropertyChangeListener</code> instances about
	* changes of the value of the corresponding property name.
	*
	* @param propertyName 		 the property name
	* @param oldValue 		 the old property value
	* @param newValue 		 the new property value
	**/
	 protected void firePropertyChange(java.lang.String propertyName, java.lang.Object oldValue, java.lang.Object newValue)
	{
	}


}