package com.ulcjava.base.application;


	/**
	* This is the base class for the concrete column model classes. It defines
	* convenience methods for registering
<code>IColumnModelListener</code>s and
	* firing the listeners on events like add, remove, or move of a column.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.ULCTableColumnModel
	* @see		com.ulcjava.base.application.tabletree.ULCTableTreeColumnModel
	* @see		com.ulcjava.base.application.event.IColumnModelListener
	**/
 public  abstract class AbstractColumnModel extends com.ulcjava.base.application.ULCProxy
{

	 protected AbstractColumnModel()
	{
		 super();
	}

	 protected void updateColumnOrder(int[] columnOids)
	{
	}

	 protected void addAbstractColumn(com.ulcjava.base.application.AbstractColumn column)
	{
	}

	 protected com.ulcjava.base.application.AbstractColumn getAbstractColumn(int columnIndex)
	{
		return null;
	}

	 protected int getAbstractColumnIndex(com.ulcjava.base.application.AbstractColumn column)
	{
		return 0;
	}

	 protected void removeAbstractColumn(com.ulcjava.base.application.AbstractColumn column)
	{
	}


	/**
	* Forwards the column added notification event to all
	* <code>IColumnModelListener</code>s that registered themselves as listeners
	* forthis object.
	*
	* @param event 		 the event to be forwarded
	* @see		AbstractColumnModel#addColumnModelListener
	* @see		com.ulcjava.base.application.event.ColumnModelEvent
	**/
	 protected void fireColumnAdded(com.ulcjava.base.application.event.ColumnModelEvent event)
	{
	}


	/**
	* Forwards the column removed notification event to all
	* <code>IColumnModelListener</code>s that registered themselves as
	* listeners
forthis object.
	*
	* @param event 		 the event to be forwarded
	* @see		AbstractColumnModel#addColumnModelListener
	* @see		com.ulcjava.base.application.event.ColumnModelEvent
	**/
	 protected void fireColumnRemoved(com.ulcjava.base.application.event.ColumnModelEvent event)
	{
	}


	/**
	* Forwards the column moved notification event to all
	* <code>IColumnModelListener</code>s that registered themselves as listeners
	* forthis object.
	*
	* @param event 		 the event to be forwarded
	* @see		AbstractColumnModel#addColumnModelListener
	* @see		com.ulcjava.base.application.event.ColumnModelEvent
	**/
	 protected void fireColumnMoved(com.ulcjava.base.application.event.ColumnModelEvent event)
	{
	}


	/**
	* Creates a column model event.
<p>
</p>
<b>Note:</b> This method will be called
	* as part of a client-initiated event firing.
</p>
	*
	* @param from 		 index of column
	* @param to 		 index of column
	* @return		a column model event with this <code>AbstractColumnModel</code> object as the source, or null if no event should be fired
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.ColumnModelEvent createColumnModelEvent(int from, int to)
	{
		return null;
	}


	/**
	* Dispatches a column model event to registered listeners via {@link
	* #dispatchEvent(String, String, java.util.EventObject)}. Extension
writers may
	* override this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing.
</p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#COLUMN_MODEL_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @ulc.extension		
	* @see		#dispatchEvent(String, String, java.util.EventObject)
	**/
	 protected void processColumnModelEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ColumnModelEvent eventObject)
	{
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#COLUMN_MODEL_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link IColumnModelListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getColumnModelListenerClass()
	{
		return null;
	}

	 protected com.ulcjava.base.application.ULCListSelectionModel createListSelectionModel()
	{
		return null;
	}


	/**
	* Returns the column count.
	*
	* @return		the column count
	**/
	 public int getColumnCount()
	{
		return 0;
	}


	/**
	* Returns the column index of the first column with the specified identifier.
	*
	* @param identifier 		 the identifier
	* @return		the column index of the first column with the specified identifier
	**/
	 public int getColumnIndex(java.lang.Object identifier)
	{
		return 0;
	}


	/**
	* Returns the column margin.
	*
	* @return		the column margin
	**/
	 public int getColumnMargin()
	{
		return 0;
	}


	/**
	* Returns an enumeration of the columns.
	*
	* @return		an enumeration of the columns
	**/
	 public java.util.Enumeration getColumns()
	{
		return null;
	}


	/**
	* Returns true if column selection is allowed, false otherwise.
	*
	* @return		true if column selection is allowed, false otherwise
	**/
	 public boolean getColumnSelectionAllowed()
	{
		return false;
	}


	/**
	* Returns the number of selected columns.
	*
	* @return		the number of selected columns
	**/
	 public int getSelectedColumnCount()
	{
		return 0;
	}


	/**
	* Returns the selected column indices.
	*
	* @return		the selected column indices.
	**/
	 public int[] getSelectedColumns()
	{
		return null;
	}


	/**
	* Returns the column selection model.
	*
	* @return		the column selection model
	**/
	 public com.ulcjava.base.application.ULCListSelectionModel getSelectionModel()
	{
		return null;
	}


	/**
	* Returns the total column width.
	*
	* @return		the total column width
	**/
	 public int getTotalColumnWidth()
	{
		return 0;
	}


	/**
	* Moves a column from the specified old index to the specified new index.
	*
	* @param oldIndex 		 the old index of the column to move
	* @param newIndex 		 the new index of the column to move
	**/
	 public void moveColumn(int oldIndex, int newIndex)
	{
	}


	/**
	* Sets the column margin.
	*
	* @param columnMargin 		 the column margin
	**/
	 public void setColumnMargin(int columnMargin)
	{
	}


	/**
	* Specifies whether column selection is allowed or not.
	*
	* @param columnSelectionAllowed 		 true if column selection is allowed, false otherwise
	**/
	 public void setColumnSelectionAllowed(boolean columnSelectionAllowed)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Adds a listener to the list that's notified each time a change to the column
	* model occurs.
	*
	* @param listener 		 the IColumnModelListener
	**/
	 public void addColumnModelListener(com.ulcjava.base.application.event.IColumnModelListener listener)
	{
	}


	/**
	* Removes a listener from the list that's notified each time a change to the
	* column model occurs.
	*
	* @param listener 		 the IColumnModelListener
	**/
	 public void removeColumnModelListener(com.ulcjava.base.application.event.IColumnModelListener listener)
	{
	}


	/**
	* Returns an array of all the column model listeners registered on this model.
	*
	* @return		all of this model's <code>IColumnModelListener</code>s or an empty array if no column model listeners are currently
registered
	* @see		#addColumnModelListener(IColumnModelListener)
	* @see		#removeColumnModelListener(IColumnModelListener)
	**/
	 public com.ulcjava.base.application.event.IColumnModelListener[] getColumnModelListeners()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class AbstractColumnModelDispatcher extends ULCProxyDispatcher
{

	 public  final void updateColumnOrder(int[] columnOids)
	{
	}

	 public  final com.ulcjava.base.application.event.ColumnModelEvent createColumnModelEvent(int from, int to)
	{
		return null;
	}

	 public  final void processColumnModelEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ColumnModelEvent eventObject)
	{
	}

	 public  final java.lang.Class getColumnModelListenerClass()
	{
		return null;
	}


}
}