package com.ulcjava.base.application;


	/**
	* <code>BorderFactory</code> is a vendor of instances of common
	* <code>ULCAbstractBorder</code>
	* implementations.
<p>
</p>
<b>Feature</b>
<ul>
<li>Provides methods to create
	* instances of: {@link ULCBevelBorder}, {@link ULCCompoundBorder}, {@link
	* ULCEmptyBorder},
{@link ULCEtchedBorder}, {@link ULCLineBorder}, {@link
	* ULCMatteBorder}, {@link
	* ULCTitledBorder}.
</ul>
<p>
</p>
<b>Examples</b>

<pre>
ULCBevelBorder
	* raisedbevel = BorderFactory.createRaisedBevelBorder();
ULCLineBorder line =
	* BorderFactory.createLineBorder(Color.black, 2);
</pre>
	*
	* @ulc.application		
	* @see		ULCBevelBorder
	* @see		ULCCompoundBorder
	* @see		ULCEmptyBorder
	* @see		ULCEtchedBorder
	* @see		ULCLineBorder
	* @see		ULCMatteBorder
	* @see		ULCTitledBorder
	**/
 public class BorderFactory extends java.lang.Object
{

	 private BorderFactory()
	{
		 super();
	}


	/**
	* Constructs a line border with the given color.
	*
	* @param color 		 a <code>Color</code> to use for the line
	* @return		<code>ULCAbstractBorder</code> the line border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createLineBorder(com.ulcjava.base.application.util.Color color)
	{
		return null;
	}


	/**
	* Constructs a line border with the given color and width.
	*
	* @param color 		 a <code>Color</code> to use for the line
	* @param thickness 		 an integer specifying the width in pixels
	* @return		<code>ULCAbstractBorder</code> the line border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createLineBorder(com.ulcjava.base.application.util.Color color, int thickness)
	{
		return null;
	}


	/**
	* Constructs an empty border that takes up no space. (The width of the top,
	* bottom, left, and right sides are all zero.)
	*
	* @return		<code>ULCAbstractBorder</code> the empty border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createEmptyBorder()
	{
		return null;
	}


	/**
	* Constructs an empty border that takes up space but which does no drawing,
	* specifying the width of the top, left, bottom, and right
sides.
	*
	* @param top 		 an integer specifying the width of the top, in pixels
	* @param left 		 an integer specifying the width of the left side, in pixels
	* @param bottom 		 an integer specifying the width of the right side, in pixels
	* @param right 		 an integer specifying the width of the bottom, in pixels
	* @return		<code>ULCAbstractBorder</code> the empty border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createEmptyBorder(int top, int left, int bottom, int right)
	{
		return null;
	}


	/**
	* Constructs a border with a raised beveled edge, using brighter shades of the
	* component's current background color for highlighting,
and darker shading for
	* shadows. (In a raised border, highlights are on top and shadows are
	* underneath.)
	*
	* @return		<code>ULCAbstractBorder</code> the bevel border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createRaisedBevelBorder()
	{
		return null;
	}


	/**
	* Constructs a border with a lowered beveled edge, using brighter shades of the
	* component's current background color for highlighting,
and darker shading for
	* shadows. (In a lowered border, shadows are on top and highlights are
	* underneath.)
	*
	* @return		<code>ULCAbstractBorder</code> the bevel border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createLoweredBevelBorder()
	{
		return null;
	}


	/**
	* Constructs a beveled border of the given type, using brighter shades of the
	* component's current background color for highlighting,
and darker shading for
	* shadows. (In a lowered border, shadows are on top and highlights are
	* underneath.)
	*
	* @param type 		 an integer specifying either <code>ULCBevelBorder.LOWERED</code> or <code>ULCBevelBorder.RAISED</code>
	* @return		<code>ULCAbstractBorder</code> the bevel border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createBevelBorder(int type)
	{
		return null;
	}


	/**
	* Constructs a beveled border of the given type, using the given highlighting
	* andshadowing. The outer edge of the highlighted area
uses a brighter shade of
	* the highlight color. The inner edge of the shadow area uses a brighter shade
	* of the shadow color.
	*
	* @param type 		 an integer specifying either <code>ULCBevelBorder.LOWERED</code> or <code>ULCBevelBorder.RAISED</code>
	* @param highlight 		 a <code>Color</code> object for highlights
	* @param shadow 		 a <code>Color</code> object for shadows
	* @return		<code>ULCAbstractBorder</code> the bevel border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createBevelBorder(int type, com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
		return null;
	}


	/**
	* Constructs a beveled border of the given type, using the given colors for the
	* inner and outer highlight and shadow areas.
	*
	* @param type 		 an integer specifying either <code>ULCBevelBorder.LOWERED</code> or <code>ULCBevelBorder.RAISED</code>
	* @param highlightOuter 		 a <code>Color</code> object for the outer edge of the highlight area
	* @param highlightInner 		 a <code>Color</code> object for the inner edge of the highlight area
	* @param shadowOuter 		 a <code>Color</code> object for the outer edge of the shadow area
	* @param shadowInner 		 a <code>Color</code> object for the inner edge of the shadow area
	* @return		<code>ULCAbstractBorder</code> the bevel border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createBevelBorder(int type, com.ulcjava.base.application.util.Color highlightOuter, com.ulcjava.base.application.util.Color highlightInner, com.ulcjava.base.application.util.Color shadowOuter, com.ulcjava.base.application.util.Color shadowInner)
	{
		return null;
	}


	/**
	* Constructs a border with an "etched" look using the component's current
	* background color for highlighting and shading.
	*
	* @return		<code>ULCAbstractBorder</code> the etched border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createEtchedBorder()
	{
		return null;
	}


	/**
	* Constructs a border with an "etched" look using the given highlighting and
	* shading colors.
	*
	* @param highlight 		 a <code>Color</code> object for the border highlights
	* @param shadow 		 a <code>Color</code> object for the border shadows
	* @return		<code>ULCAbstractBorder</code> the etched border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createEtchedBorder(com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
		return null;
	}


	/**
	* Constructs a border with an "etched" look using the component's current
	* background color for highlighting and shading.
	*
	* @param type 		 one of <code>ULCEtchedBorder.RAISED</code>, or <code>ULCEtchedBorder.LOWERED</code>
	* @return		the <code>ULCAbstractBorder</code> the etched border object
	* @throws		IllegalArgumentException if type is not either <code>ULCEtchedBorder.RAISED</code> or <code>ULCEtchedBorder.LOWERED</code>
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createEtchedBorder(int type)
	{
		return null;
	}


	/**
	* Constructs a border with an "etched" look using the given highlighting and
	* shading colors.
	*
	* @param type 		 one of <code>ULCEtchedBorder.RAISED</code>, or <code>ULCEtchedBorder.LOWERED</code>
	* @param highlight 		 a <code>Color</code> object for the border highlights
	* @param shadow 		 a <code>Color</code> object for the border shadows
	* @return		<code>ULCAbstractBorder</code> the etched border object
	**/
	 public  static com.ulcjava.base.application.border.ULCAbstractBorder createEtchedBorder(int type, com.ulcjava.base.application.util.Color highlight, com.ulcjava.base.application.util.Color shadow)
	{
		return null;
	}


	/**
	* Constructs a new title border specifying the text of the title, using the
	* default border (etched), using the default text position
(sitting on the top
	* line) and default justification (leading) and using the default font and text
	* color determined by the current
look and feel.
	*
	* @param title 		 a <code>String</code> containing the text of the title
	* @return		<code>ULCTitledBorder</code> the titled border object
	**/
	 public  static com.ulcjava.base.application.border.ULCTitledBorder createTitledBorder(java.lang.String title)
	{
		return null;
	}


	/**
	* Constructs a new title border with an empty title specifying the border
	* object,using the default text position (sitting on the top
line) and default
	* justification (leading) and using the default font, and text color.
	*
	* @param border 		 the <code>ULCAbstractBorder</code> object to add the title to, if null the <code>ULCAbstractBorder</code> is
determined by the current look and feel.
	* @return		<code>ULCTitledBorder</code> the titled border object
	**/
	 public  static com.ulcjava.base.application.border.ULCTitledBorder createTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border)
	{
		return null;
	}


	/**
	* Adds a title to an existing border, specifying the text of the title, using
	* thedefault positioning (sitting on the top line) and
default justification
	* (leading) and using the default font and text color determined by the current
	* look and feel.
	*
	* @param border 		 the <code>ULCAbstractBorder</code> object to add the title to
	* @param title 		 a <code>String</code> containing the text of the title
	* @return		<code>ULCTitledBorder</code> the titled border object
	**/
	 public  static com.ulcjava.base.application.border.ULCTitledBorder createTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title)
	{
		return null;
	}


	/**
	* Adds a title to an existing border, specifying the text of the title along
	* withits positioning, using the default font and text
color determined by the
	* current look and feel.
	*
	* @param border 		 the <code>ULCAbstractBorder</code> object to add the title to
	* @param title 		 a <code>String</code> containing the text of the title
	* @param titleJustification 		 an integer specifying the justification of the title -- one of the following:
<ul>
<li><code>ULCTitledBorder.LEFT</code>
<li><code>ULCTitledBorder.CENTER</code>
<li><code>ULCTitledBorder.RIGHT</code>
<li><code>ULCTitledBorder.LEADING</code>
<li><code>ULCTitledBorder.TRAILING<code>
<li><code>ULCTitledBorder.DEFAULT_JUSTIFICATION</code> (leading)
</ul>
	* @param titlePosition 		 an integer specifying the vertical position of
the text in relation to the border -- one of the following:
<ul>
<li><code>ULCTitledBorder.ABOVE_TOP</code>
<li><code>ULCTitledBorder.TOP</code> (sitting on the top line)
<li><code>ULCTitledBorder.BELOW_TOP</code>
<li><code>ULCTitledBorder.ABOVE_BOTTOM</code>
<li><code>ULCTitledBorder.BOTTOM</code> (sitting on the bottom line)
<li><code>ULCTitledBorder.BELOW_BOTTOM</code>
<li><code>ULCTitledBorder.DEFAULT_POSITION</code> (top)
</ul>
	* @return		<code>ULCTitledBorder</code> the titled border object
	**/
	 public  static com.ulcjava.base.application.border.ULCTitledBorder createTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title, int titleJustification, int titlePosition)
	{
		return null;
	}


	/**
	* Adds a title to an existing border, specifying the text of the title along
	* withits positioning and font, using the default text
color determined by the
	* current look and feel.
	*
	* @param border 		 the <code>ULCAbstractBorder</code> object to add the title to
	* @param title 		 a <code>String</code> containing the text of the title
	* @param titleJustification 		 an integer specifying the justification of the title -- one of the following:
<ul>
<li><code>ULCTitledBorder.LEFT</code>
<li><code>ULCTitledBorder.CENTER</code>
<li><code>ULCTitledBorder.RIGHT</code>
<li><code>ULCTitledBorder.LEADING</code>
<li><code>ULCTitledBorder.TRAILING<code>
<li><code>ULCTitledBorder.DEFAULT_JUSTIFICATION</code> (leading)
</ul>
	* @param titlePosition 		 an integer specifying the vertical position of
the text in relation to the border -- one of the following:
<ul>
<li><code>ULCTitledBorder.ABOVE_TOP</code>
<li><code>ULCTitledBorder.TOP</code> (sitting on the top line)
<li><code>ULCTitledBorder.BELOW_TOP</code>
<li><code>ULCTitledBorder.ABOVE_BOTTOM</code>
<li><code>ULCTitledBorder.BOTTOM</code> (sitting on the bottom line)
<li><code>ULCTitledBorder.BELOW_BOTTOM</code>
<li><code>ULCTitledBorder.DEFAULT_POSITION</code> (top)
</ul>
	* @param titleFont 		 a Font object specifying the title font
	* @return		<code>ULCTitledBorder</code> the titled border object
	**/
	 public  static com.ulcjava.base.application.border.ULCTitledBorder createTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title, int titleJustification, int titlePosition, com.ulcjava.base.application.util.Font titleFont)
	{
		return null;
	}


	/**
	* Adds a title to an existing border, specifying the text of the title along
	* withits positioning, font, and color.
	*
	* @param border 		 the <code>ULCAbstractBorder</code> object to add the title to
	* @param title 		 a <code>String</code> containing the text of the title
	* @param titleJustification 		 an integer specifying the justification of the title -- one of the following:
<ul>
<li><code>ULCTitledBorder.LEFT</code>
<li><code>ULCTitledBorder.CENTER</code>
<li><code>ULCTitledBorder.RIGHT</code>
<li><code>ULCTitledBorder.LEADING</code>
<li><code>ULCTitledBorder.TRAILING<code>
<li><code>ULCTitledBorder.DEFAULT_JUSTIFICATION</code> (leading)
</ul>
	* @param titlePosition 		 an integer specifying the vertical position of
the text in relation to the border -- one of the following:
<ul>
<li><code>ULCTitledBorder.ABOVE_TOP</code>
<li><code>ULCTitledBorder.TOP</code> (sitting on the top line)
<li><code>ULCTitledBorder.BELOW_TOP</code>
<li><code>ULCTitledBorder.ABOVE_BOTTOM</code>
<li><code>ULCTitledBorder.BOTTOM</code> (sitting on the bottom line)
<li><code>ULCTitledBorder.BELOW_BOTTOM</code>
<li><code>ULCTitledBorder.DEFAULT_POSITION</code> (top)
</ul>
	* @param titleFont 		 a <code>Font</code> object specifying the title font
	* @param titleColor 		 a <code>Color</code> object specifying the title color
	* @return		<code>ULCTitledBorder</code> the titled border object
	**/
	 public  static com.ulcjava.base.application.border.ULCTitledBorder createTitledBorder(com.ulcjava.base.application.border.ULCAbstractBorder border, java.lang.String title, int titleJustification, int titlePosition, com.ulcjava.base.application.util.Font titleFont, com.ulcjava.base.application.util.Color titleColor)
	{
		return null;
	}


	/**
	* Constructs a compound border with a <code>null</code> inside edge and a
	* <code>null</code> outside edge.
	*
	* @return		<code>ULCCompoundBorder</code> the compound border object
	**/
	 public  static com.ulcjava.base.application.border.ULCCompoundBorder createCompoundBorder()
	{
		return null;
	}


	/**
	* Constructs a compound border specifying the border objects to use for the
	* outside and inside edges.
	*
	* @param outsideBorder 		 a <code>ULCAbstractBorder</code> object for the outer edge of the compound border
	* @param insideBorder 		 a <code>ULCAbstractBorder</code> object for the inner edge of the compound border
	* @return		<code>ULCCompoundBorder</code> the compound border object
	**/
	 public  static com.ulcjava.base.application.border.ULCCompoundBorder createCompoundBorder(com.ulcjava.base.application.border.ULCAbstractBorder outsideBorder, com.ulcjava.base.application.border.ULCAbstractBorder insideBorder)
	{
		return null;
	}


	/**
	* Constructs a matte-look border using a solid color. (The difference between
	* this border and a line border is that you can specify the
individual border
	* dimensions.)
	*
	* @param top 		 an integer specifying the width of the top, in pixels
	* @param left 		 an integer specifying the width of the left side, in pixels
	* @param bottom 		 an integer specifying the width of the right side, in pixels
	* @param right 		 an integer specifying the width of the bottom, in pixels
	* @param color 		 a <code>Color</code> to use for the border
	* @return		<code>ULCMatteBorder</code> the matte border object
	**/
	 public  static com.ulcjava.base.application.border.ULCMatteBorder createMatteBorder(int top, int left, int bottom, int right, com.ulcjava.base.application.util.Color color)
	{
		return null;
	}


	/**
	* Constructs a matte-look border that consists of multiple tiles of a given
	* icon.Multiple copies of the icon are placed side-by-side
to fill up the
	* borderarea.
<p>
</p>
Note: <br>
If the icon doesn't load, the border area is
	* painted gray.
	*
	* @param top 		 an integer specifying the width of the top, in pixels
	* @param left 		 an integer specifying the width of the left side, in pixels
	* @param bottom 		 an integer specifying the width of the right side, in pixels
	* @param right 		 an integer specifying the width of the bottom, in pixels
	* @param tileIcon 		 the <code>Icon</code> object used for the border tiles
	* @return		<code>ULCMatteBorder</code> the matte border object
	**/
	 public  static com.ulcjava.base.application.border.ULCMatteBorder createMatteBorder(int top, int left, int bottom, int right, com.ulcjava.base.application.util.ULCIcon tileIcon)
	{
		return null;
	}


}