package com.ulcjava.base.application;


	/**
	* The <code>DefaultListModel</code> provides a default implementation for the
	* abstract methods in the
	* <code>AbstractListModel</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultListModel</code> provides convenience methods for adding
	* elementsto and removing elements from the list.
Moreover it allows to query
	* the list if a specified object is contained in the list.</li>
<li>It provides
	* a constructor which takes an <code>Object</code> array of elements as initial
	* values for the list.</li>
<li>It keeps track of the listeners of the model,
	* added and removed via <code>addListDataListener</code>
	* and
<code>removeListDataListener</code>. This behavior is inherited from the
	* <code>AbstractListModel</code>.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* example creates a list with a default list model having 3 strings as its
	* values:

<pre>
DefaultListModel model = new
	* DefaultListModel();
model.add(&quot;red&quot;);
model.add(&quot;green&quot;);
m
	* odel.add(&quot;blue&quot;);
ULCList list = new ULCList(model);
</pre>
	*
	* @ulc.application		
	* @see		ULCList
	* @see		AbstractListModel
	* @see		IListModel
	**/
 public class DefaultListModel extends com.ulcjava.base.application.AbstractListModel
{


	/**
	* Creates an empty list model.
	*
	**/
	 public DefaultListModel()
	{
		 super();
	}


	/**
	* Creates a new list model that contains the specified elements.
	*
	* @param elements 		 the elements
	**/
	 public DefaultListModel(java.lang.Object[] elements)
	{
		 super();
	}


	/**
	* Adds the specified element to the list model.
	*
	* @param element 		 the element to add
	**/
	 public void add(java.lang.Object element)
	{
	}


	/**
	* Adds the specified element at the specified index to the list model.
	*
	* @param index 		 the index
	* @param element 		 the element to add
	**/
	 public void add(int index, java.lang.Object element)
	{
	}


	/**
	* Adds all specified elements to the list model.
	*
	* @param elements 		 the elements to add
	**/
	 public void addAll(java.lang.Object[] elements)
	{
	}


	/**
	* Adds all specified elements at the specified index to the list model.
	*
	* @param index 		 the index
	* @param elements 		 the elements to be added
	**/
	 public void addAll(int index, java.lang.Object[] elements)
	{
	}


	/**
	* Clears the list model.
	*
	**/
	 public void clear()
	{
	}


	/**
	* Returns true if the list model contains the specified element, false otherwise.
	*
	* @param element 		 the element
	* @return		true if the list model contains the specified element, false otherwise
	**/
	 public boolean contains(java.lang.Object element)
	{
		return false;
	}


	/**
	* Returns true if the list model contains all specified elements, false otherwise.
	*
	* @param elements 		 the elements
	* @return		true if the list model contains all specified elements, false otherwise
	**/
	 public boolean containsAll(java.lang.Object[] elements)
	{
		return false;
	}

	 public java.lang.Object getElementAt(int index)
	{
		return null;
	}

	 public int getSize()
	{
		return 0;
	}


	/**
	* Returns the index of the specified object.
	*
	* @param object 		 the object
	* @return		the index of the specified object
	**/
	 public int indexOf(java.lang.Object object)
	{
		return 0;
	}


	/**
	* Return true if the list model is empty, false otherwise.
	*
	* @return		true if the list model is empty, false otherwise
	**/
	 public boolean isEmpty()
	{
		return false;
	}


	/**
	* Removes the element at the specified index from the list model.
	*
	* @param index 		 the index
	* @return		the removed element
	**/
	 public java.lang.Object remove(int index)
	{
		return null;
	}


	/**
	* Removes the specified element from the list model.
	*
	* @param element 		 the element to be removed
	* @return		true, if the content of the list model has changed, false otherwise
	**/
	 public boolean remove(java.lang.Object element)
	{
		return false;
	}


	/**
	* Sets the the specified elements at the specified index in the list model.
	*
	* @param index 		 the index
	* @param element 		 the element
	* @return		the replaced element
	**/
	 public java.lang.Object set(int index, java.lang.Object element)
	{
		return null;
	}


}