package com.ulcjava.base.application;


	/**
	* The <code>GridBagConstraints</code> class specifies constraints for components
	* that are laid out using the
<code>ULCGridBagLayoutPane</code> class.
	*
	* @ulc.application		
	* @see		ULCGridBagLayoutPane
	**/
 public class GridBagConstraints extends java.lang.Object implements java.io.Serializable
{

	/**
	* Specify that this component is the next-to-last component in its column or row
	* (<code>fGridWidth</code>, <code>fGridHeight</code>),
or that this component
	* beplaced next to the previously added component (<code>fGridX</code>,
	* <code>fGridY</code>).
	*
	**/
	 public  final  static int RELATIVE = 0;

	/**
	* Specify that this component is the last component in its column or row.
	*
	**/
	 public  final  static int REMAINDER = 0;

	/**
	* Do not resize the component.
	*
	**/
	 public  final  static int NONE = 0;

	/**
	* Resize the component both horizontally and vertically.
	*
	**/
	 public  final  static int BOTH = 0;

	/**
	* Resize the component horizontally but not vertically.
	*
	**/
	 public  final  static int HORIZONTAL = 0;

	/**
	* Resize the component vertically but not horizontally.
	*
	**/
	 public  final  static int VERTICAL = 0;

	/**
	* Put the component in the center of its display area.
	*
	**/
	 public  final  static int CENTER = 0;

	/**
	* Put the component at the top of its display area, centered horizontally.
	*
	**/
	 public  final  static int NORTH = 0;

	/**
	* Put the component at the top-right corner of its display area.
	*
	**/
	 public  final  static int NORTHEAST = 0;

	/**
	* Put the component on the right side of its display area, centered vertically.
	*
	**/
	 public  final  static int EAST = 0;

	/**
	* Put the component at the bottom-right corner of its display area.
	*
	**/
	 public  final  static int SOUTHEAST = 0;

	/**
	* Put the component at the bottom of its display area, centered horizontally.
	*
	**/
	 public  final  static int SOUTH = 0;

	/**
	* Put the component at the bottom-left corner of its display area.
	*
	**/
	 public  final  static int SOUTHWEST = 0;

	/**
	* Put the component on the left side of its display area, centered vertically.
	*
	**/
	 public  final  static int WEST = 0;

	/**
	* Put the component at the top-left corner of its display area.
	*
	**/
	 public  final  static int NORTHWEST = 0;


	/**
	* Creates a new <code>GridBagConstraint</code> object with all of its fields set
	* to their default values.
	*
	**/
	 public GridBagConstraints()
	{
		 super();
	}


	/**
	* Creates a new <code>GridBagConstraints</code> object with all of its fields
	* setto the passed-in arguments.
	*
	* @param gridx 		 The initial gridx value.
	* @param gridy 		 The initial gridy value.
	* @param gridwidth 		 The initial gridwidth value.
	* @param gridheight 		 The initial gridheight value.
	* @param weightx 		 The initial weightx value.
	* @param weighty 		 The initial weighty value.
	* @param anchor 		 The initial anchor value.
	* @param fill 		 The initial fill value.
	* @param insets 		 The initial insets value.
	* @param ipadx 		 The initial ipadx value.
	* @param ipady 		 The initial ipady value.
	**/
	 public GridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, com.ulcjava.base.application.util.Insets insets, int ipadx, int ipady)
	{
		 super();
	}


	/**
	* Creates a new <code>GridBagConstraints</code> object with all of its fields
	* setto the values of the passed in constraints
argument.
	*
	* @param constraints 		 The initial constraints values.
	**/
	 public GridBagConstraints(com.ulcjava.base.application.GridBagConstraints constraints)
	{
		 super();
	}


	/**
	* Returns the cell at the left of the component's display area.
	*
	* @return		the cell at the left of the component's display area
	**/
	 public int getGridX()
	{
		return 0;
	}


	/**
	* Sets the cell at the left of the component's display area, where the leftmost
	* cell has <code>fGridX=0</code>. The value
<code>RELATIVE</code> specifies
	* thatthe component be placed just to the right of the component that was added
	* to the container
just before this component was added.
<p>
</p>
The default
	* value is <code>RELATIVE</code>. fGridX should be a non-negative value.
	*
	* @param gridX 		 the cell at the left of the component's display area
	**/
	 public void setGridX(int gridX)
	{
	}


	/**
	* Returns the cell at the top of the component's display area.
	*
	* @return		the cell at the top of the component's display area
	**/
	 public int getGridY()
	{
		return 0;
	}


	/**
	* Sets the cell at the top of the component's display area, where the topmost
	* cell has <code>fGridY=0</code>. The value
<code>RELATIVE</code> specifies
	* thatthe component be placed just below the component that was added to the
	* container just before
this component was added.
<p>
</p>
The default value is
	* <code>RELATIVE</code>. fGridY should be a non-negative value.
	*
	* @param gridY 		 the cell at the top of the component's display area
	**/
	 public void setGridY(int gridY)
	{
	}


	/**
	* Returns the number of cells in a row for the component's display area.
	*
	* @return		the number of cells in a row for the component's display area
	**/
	 public int getGridWidth()
	{
		return 0;
	}


	/**
	* Sets the number of cells in a row for the component's display
	* area.
<p>
</p>
Use <code>REMAINDER</code> to specify that the component be
	* thelast one in its row. Use <code>RELATIVE</code> to specify that
the
	* component be the next-to-last one in its row.
<p>
</p>
fGridWidth should be
	* non-negative and the default value is <code>1</code>.
	*
	* @param gridWidth 		 the number of cells in a row for the component's display area
	**/
	 public void setGridWidth(int gridWidth)
	{
	}


	/**
	* Returns the number of cells in a column for the component's display area.
	*
	* @return		the number of cells in a column for the component's display area
	**/
	 public int getGridHeight()
	{
		return 0;
	}


	/**
	* Sets the number of cells in a column for the component's display
	* area.
<p>
</p>Use <code>REMAINDER</code> to specify that the component be the
	* last one in its column. Use <code>RELATIVE</code> to specify that
the
	* component be the next-to-last one in its column.
<p>
</p>
fGridHeight should
	* be a non-negative value and the default value is <code>1</code>.
	*
	* @param gridHeight 		 the number of cells in a column for the component's display area
	**/
	 public void setGridHeight(int gridHeight)
	{
	}


	/**
	* Returns the component's horizontal weight.
	*
	* @return		the component's horizontal weight
	**/
	 public double getWeightX()
	{
		return 0.0d;
	}


	/**
	* Specifies how to distribute extra horizontal space.
<p>
</p>
The grid bag
	* layout manager calculates the weight of a column to be the maximum
	* <code>fWeightX</code> of all the components in a
column. If the resulting
	* layout is smaller horizontally than the area it needs to fill, the extra
	* spaceis distributed to each column
in proportion to its weight. A column that
	* has a weight of zero receives no extra space.
<p>
</p>
If all the weights are
	* zero, all the extra space appears between the grids of the cell and the left
	* and right edges.
<p>
</p>
The default value of this field is <code>0</code>.
	* fWeightX should be a non-negative value.
	*
	* @param weightX 		 the component's horizontal weight
	**/
	 public void setWeightX(double weightX)
	{
	}


	/**
	* Returns the component's vertical weight.
	*
	* @return		the component's vertical weight
	**/
	 public double getWeightY()
	{
		return 0.0d;
	}


	/**
	* Specifies how to distribute extra vertical space.
<p>
</p>
The grid bag layout
	* manager calculates the weight of a row to be the maximum
	* <code>fWeightY</code>of all the components in a row.
If the resulting layout
	* is smaller vertically than the area it needs to fill, the extra space is
	* distributed to each row in
proportion to its weight. A row that has a weight
	* of zero receives no extra space.
<p>
</p>
If all the weights are zero, all
	* theextra space appears between the grids of the cell and the top and bottom
	* edges.
<p>
</p>
The default value of this field is <code>0</code>. fWeightY
	* should be a non-negative value.
	*
	* @param weightY 		 the component's vertical weight
	**/
	 public void setWeightY(double weightY)
	{
	}


	/**
	* Returns the component's anchor.
	*
	* @return		the component's anchor
	**/
	 public int getAnchor()
	{
		return 0;
	}


	/**
	* This field is used when the component is smaller than its display area. It
	* determines where, within the display area, to place the
component. Possible
	* values are <code>CENTER</code>, <code>NORTH</code>, <code>NORTHEAST</code>,
	* <code>EAST</code>,
<code>SOUTHEAST</code>, <code>SOUTH</code>,
	* <code>SOUTHWEST</code>, <code>WEST</code>, and <code>NORTHWEST</code>.
	* The
default value is <code>CENTER</code>.
	*
	* @param anchor 		 the component's anchor
	**/
	 public void setAnchor(int anchor)
	{
	}


	/**
	* Returns the component's fill.
	*
	* @return		the component's fill
	**/
	 public int getFill()
	{
		return 0;
	}


	/**
	* This field is used when the component's display area is larger than the
	* component's requested size. It determines whether to resize
the component,
	* andif so, how.
<p>
</p>
The following values are valid for
	* <code>fFill</code>:<p>
</p>
<ul>
<li> <code>NONE</code>: Do not resize the
	* component.
<li> <code>HORIZONTAL</code>: Make the component wide enough to
	* fill its display area horizontally, but do not change its height.
<li>
	* <code>VERTICAL</code>: Make the component tall enough to fill its display
	* areavertically, but do not change its width.
<li> <code>BOTH</code>: Make the
	* component fill its display area entirely.
</ul>
<p>
</p>
The default value is
	* <code>NONE</code>.
	*
	* @param fill 		 the component's fill
	**/
	 public void setFill(int fill)
	{
	}


	/**
	* Returns the component's insets.
	*
	* @return		the component's insets
	**/
	 public com.ulcjava.base.application.util.Insets getInsets()
	{
		return null;
	}


	/**
	* This field specifies the external padding of the component, the minimum amount
	* of space between the component and the edges of its
display
	* area.
<p>
</p>
Thedefault value is <code>new Insets(0, 0, 0, 0)</code>.
	*
	* @param insets 		 the component's insets
	**/
	 public void setInsets(com.ulcjava.base.application.util.Insets insets)
	{
	}


	/**
	* Return the component's internal horizontal padding.
	*
	* @return		the component's internal horizontal padding
	**/
	 public int getIPadX()
	{
		return 0;
	}


	/**
	* This field specifies the internal padding of the component, how much space to
	* add to the minimum width of the component. The width of
the component is at
	* least its minimum width plus <code>(fIPadX&nbsp;*&nbsp;2)</code>
	* pixels.
<p>
</p>
The default value is <code>0</code>.
	*
	* @param IPadX 		 the component's internal horizontal padding
	**/
	 public void setIPadX(int IPadX)
	{
	}


	/**
	* Returns the component's internal vertical padding.
	*
	* @return		the component's internal vertical padding
	**/
	 public int getIPadY()
	{
		return 0;
	}


	/**
	* This field specifies the internal padding, that is, how much space to add to
	* the minimum height of the component. The height of the
component is at least
	* its minimum height plus <code>(fIPadY&nbsp;*&nbsp;2)</code>
	* pixels.
<p>
</p>
The default value is <code>0</code>.
	*
	* @param IPadY 		 the component's internal vertical padding
	**/
	 public void setIPadY(int IPadY)
	{
	}


}