package com.ulcjava.base.application;


	/**
	* The <code>com.ulcjava.base.application.IApplication</code> interface is the
	* central interface that ULC applications must implement. For
every connecting
	* client, a new instance of the class implementing this interface is created by
	* the underlying runtime container adapter
(e.g., servlet container adapter).
	*
	* @ulc.application		
	* @see		AbstractApplication
	**/
 public interface IApplication
{


	/**
	* Called by the ULC framework after the application was started. This is the
	* first call to the application.
<p>
</p>
Normally the user interface is
	* constucted in this method and the first window is made visible.
	*
	* @see		#stop
	**/
	 public void start();

	/**
	* Called by the ULC framework before the application gets stopped. This is the
	* last call to the application before it dies.
<p>
</p>
Normally resource
	* cleanup is done in this method.
	*
	* @see		#start
	**/
	 public void stop();

	/**
	* Called by the ULC framework after the application was activated.
<p>
</p>
This
	* call is originally initiated by the server container ULC is running in.
	* Depending on the server container this method might
never be called.
	*
	* @see		#passivate
	**/
	 public void activate();

	/**
	* Called by the ULC framework before the application gets
	* passivated.
<p>
</p>
This call is originally initiated by the server
	* containerULC is running in. Depending on the server container this method
	* might
never be called.
	*
	* @see		#activate
	**/
	 public void passivate();

	/**
	* Called by the ULC framework upon a message from the UIEngine.
	*
	* @param message 		 the message to be handled by this application
	**/
	 public void handleMessage(java.lang.String message);

	/**
	* Called by the ULC framework when the client side of an application gets
	* paused.In this case the server side of the application
session will remain
	* active to be resumed later.
	*
	**/
	 public void pause();

	/**
	* Called by the ULC framework when a client desires to resume an application
	* session.
	*
	**/
	 public void resume();

}