package com.ulcjava.base.application;


	/**
	* The <code>IComboBoxCellRenderer</code> interface defines the method to be
	* implemented by any object acting as a renderer in a
<code>ULCComboBox</code>.
	* Note that typically the default implementation
	* <code>DefaultComboBoxCellRenderer</code> can be used
instead of implementing
	* the interface.
<p>
<b>Features</b>
<ul>
<li>Defines the method that must be
	* implemented by an object that acts as cell renderer in a
	* <code>ULCComboBox</code>.
</ul>
<b>Examples</b>
<p>
The following code
	* snippetshows how to install a custom renderer on a <code>ULCComboBox</code>.
	* The renderer highlights the selected
item in a special color.

<pre>
Double[]
	* values = getAvailableValues();
ULCComboBox comboBox = new
	* ULCComboBox(values);comboBox.setRenderer(new SampleRenderer());
...
private
	* static class SampleRenderer implements IComboBoxCellRenderer {
private
	* ULCLabel fLabel;
public SampleRenderer() {
fLabel = new
	* ULCLabel();
fLabel.setOpaque(true);
}
public IRendererComponent
	* getComboBoxCellRendererComponent(
ULCComboBox comboBox, Object value,
boolean
	* isSelected, int row) {
fLabel.setBackground(isSelected ? Color.yellow
	* :
comboBox.getBackground());
return fLabel;
}
}
</pre>
	*
	* @ulc.application		
	* @see		ULCComboBox
	* @see		DefaultComboBoxCellRenderer
	**/
 public interface IComboBoxCellRenderer
{


	/**
	* Return a component that has been configured to render the specified row. Note
	* that - for optimization reasons - the value must not be
set by the
	* <code>IComboBoxCellRenderer</code> implementation but will be set on the
	* client side.
	*
	* @param comboBox 		 the ULCComboBox that displays the specified item
	* @param value 		 the value returned by comboBox.getModel().getElementAt(index)
	* @param isSelected 		 true if the specified cell was selected
	* @param row 		 the cell's row index
	* @return		an <code>IRendererComponent</code> that will render the specified value
	* @see		ULCComboBox
	**/
	 public com.ulcjava.base.application.IRendererComponent getComboBoxCellRendererComponent(com.ulcjava.base.application.ULCComboBox comboBox, java.lang.Object value, boolean isSelected, int row);

}