package com.ulcjava.base.application;


	/**
	* The <code>IListCellRenderer</code> interface defines the method to be
	* implemented by any object acting as a renderer for cells in
	* a
<code>ULCList</code>.
<p>
</p>
<b>Features</b>
<ul>
<li>Defines the method
	* to be implemented by any object that would like to be a renderer for cells in
	* a <code>ULCList</code>.
<li>
<li>Normally, developers will not implement
	* <code>IListCellRenderer</code> directly but create a subclass
	* of
<code>DefaultListCellRenderer</code> and add additional rendering
	* behavior.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following example creates a
	* cell renderer which can be used to display all values right-aligned. Note
	* thatthis renderer only changes
the horizontal alignment of the cells but not
	* their selection foreground colors, selection background colors, and fonts.
	* These properties
will be taken from the rendering component which in this
	* example is a <code>ULCLabel</code>. Since <code>ULCLabel</code> does,
	* for
instance, not define a selection background color, the selection
	* background color does not change when a cell is selected. To achieve the
same
	* behavior as in a list without a custom cell renderer, a
	* <code>DefaultListCellRenderer</code> should be used.

<pre>
class
	* RightAlignedCellRenderer implements IListCellRenderer {
ULCLabel
	* fRenderingLabel;

public RightAlignedCellRenderer() {
fRenderingLabel = new
	* ULCLabel();
fRenderingLabel.setHorizontalAlignment(ULCLabel.RIGHT);
}

public
	* IRendererComponent getListCellRendererComponent(ULCList list,
Object value,
	* boolean isSelected, boolean hasFocus, int row) {
return
	* fRenderingLabel;
}
}
</pre>
	*
	* @ulc.application		
	* @see		ULCList
	* @see		DefaultListCellRenderer
	**/
 public interface IListCellRenderer
{


	/**
	* Return a component configured to display the specified value.
	*
	* @param list 		 the <code>ULCList</code> for which this component acts as a renderer
	* @param value 		 the value to be displayed
	* @param isSelected 		 true if the specified cell was selected
	* @param hasFocus 		 true if the specified cell has the focus
	* @param row 		 the row index of the cell to be rendered
	* @return		A component that will render the specified value
	* @see		ULCList
	**/
	 public com.ulcjava.base.application.IRendererComponent getListCellRendererComponent(com.ulcjava.base.application.ULCList list, java.lang.Object value, boolean isSelected, boolean hasFocus, int row);

}