package com.ulcjava.base.application;


	/**
	* This class models a potentially unbounded sequence of object values. It has a
	* read/write property called <code>value</code> which is
the current element of
	* the sequence. When the the <code>value</code> property changes,
	* <code>IValueChangedListener</code>s are
notified. Objects of this type can be
	* used as source of <code>ULCHasChangedEnabler</code>.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCSpinner
	* @see		com.ulcjava.base.application.ULCAbstractSpinnerModel
	* @see		com.ulcjava.base.application.enabler.ULCHasChangedEnabler
	**/
 public interface ISpinnerModel extends com.ulcjava.base.server.IProxy, com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Returns the <i>current element</i> of the sequence which is displayed by the
	* <code>ULCSpinner</code>.
	*
	* @return		the current spinner value
	* @see		#setValue
	**/
	java.lang.Object getValue();

	/**
	* Sets current value of the model that will be displayed by the
	* <code>editor</code> part of a <code>ULCSpinner</code>.
	* An
<code>IllegalArgumentException</code> is thrown in case
	* <code>ISpinnerModel</code> implementation doesn't support the
	* specified
value.For example a <code>ISpinnerModel</code> for numbers will
	* throw an exception if a non <code>Number</code> value is set.
	*
	* @param value 		 the value to set
	* @throws		IllegalArgumentException if <code>value</code> is not valid
	* @see		#getValue
	**/
	void setValue(java.lang.Object value);

	/**
	* Adds a <code>IValueChangedListener</code> to the model that is notified when
	* the model's <code>value</code> changes.
	*
	* @param listener 		 the IValueChangedListener to add
	* @see		#removeValueChangedListener(IValueChangedListener)
	**/
	void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener);

	/**
	* Removes a <code>IValueChangedListener</code> from the listener list.
	*
	* @param listener 		 the ChangeListener to remove
	* @see		#addValueChangedListener(IValueChangedListener)
	**/
	void removeValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener);

}