package com.ulcjava.base.application;


	/**
	* The abstract class <code>ULCAbstractButton</code> provides common behavior for
	* buttons and menu items.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCAbstractButton</code> component inherits all features from
	* <code>ULCComponent</code>.
<li>A <code>ULCAbstractButton</code> displays a
	* text string, an icon, or both. In addition, the developer can define a
	* mnemonic
(keyboard shortcut) on the button.
<li>Horizontal and vertical
	* alignment properties can be used to align text and icon.
<li>The visual
	* appearance of a <code>ULCAbstractButton</code> component can be adapted by
	* changing the following attributes: the
margin, the horizontal and vertical
	* alignment properties to align text and icon.
<li>The
	* <code>ULCAbstractButton</code> component supports different icons for
	* rollover, pressed and selected state.
<li>The application can register
	* listeners (<code>IActionListener</code>) that are notified when the user
	* clicks on the button. The
action command of the corresponding
	* <code>ActionEvent</code> can be configured on the
	* <code>ULCAbstractButton</code>.
<li>The application can read and set the
	* selection state of the <code>ULCAbstractButton</code>s.
<li>An application
	* canregister an <code>IValueChangedListener</code> to be notified about state
	* changes of the button.
<li><code>ULCAbstractButton</code> can act as an
	* enabler and has changed source.
</ul>
<b>Examples</b>
<p>
</p>
To set the
	* icons, the margin, and the alignment properties, see the following
	* examples:

<pre>
abstractButton.setIcon(icon);
abstractButton.setPressedIcon(pr
	* essedIcon);
abstractButton.setRolloverIcon(rolloverIcon);
abstractButton.setSele
	* ctedIcon(selectedIcon);
abstractButton.setMargin(new Insets(10, 10, 10,
	* 10));
abstractButton.setHorizontalAlignment(ULCAbstractButton.LEFT);
abstractBu
	* tton.setHorizontalTextPosition(ULCAbstractButton.RIGHT);
abstractButton.setVerti
	* calAlignment(ULCAbstractButton.TOP);
abstractButton.setVerticalTextPosition(ULCA
	* bstractButton.TOP);
abstractButton.setMnemonic('u');
</pre>

The following
	* example sets the action command and installs an
	* <code>IActionListener</code>.<pre>
abstractButton.setActionCommand(&quot;action
	* &quot;);
abstractButton.addActionListener(new IActionListener() {
public void
	* actionPerformed(ActionEvent event)
	* {
System.out.println(event.getActionCommand());
}
});
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		ULCIcon
	* @see		Insets
	**/
 public  abstract class ULCAbstractButton extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.application.enabler.IEnabler, com.ulcjava.base.shared.IDefaults, com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Creates an abstract button.
	*
	**/
	 public ULCAbstractButton()
	{
		 super();
	}


	/**
	* Creates an abstract button with text.
	*
	* @param text 		 the text of the abstract button
	* @deprecated		use ULCAbstractButton() and setText() instead
	**/
	 public ULCAbstractButton(java.lang.String text)
	{
		 super();
	}

	 protected void initSelected(boolean selected)
	{
	}


	/**
	* Adds an <code>IActionListener</code> to this button.
	*
	* @param l 		 the <code>IActionListener</code> to be added
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener l)
	{
	}


	/**
	* Act as if a user had performed a click.
	*
	**/
	 public void doClick()
	{
	}


	/**
	* Returns the action command for this button.
	*
	* @return		the action command property
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCAbstractButton</code> with
<code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Returns the default icon for this button.
	*
	* @return		the default <code>Icon</code> property
	* @see		#setIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getIcon()
	{
		return null;
	}


	/**
	* Returns the button's text.
	*
	* @return		the buttons text
	* @see		#setText
	**/
	 public java.lang.String getText()
	{
		return null;
	}


	/**
	* Returns the keyboard mnemonic.
	*
	* @return		the keyboard mnemonic
	**/
	 public int getMnemonic()
	{
		return 0;
	}


	/**
	* Returns the pressed icon for this button.
	*
	* @return		the <code>pressedIcon</code> property
	* @see		#setPressedIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getPressedIcon()
	{
		return null;
	}


	/**
	* Returns the rollover icon for this button.
	*
	* @return		the <code>rolloverIcon</code> property
	* @see		#setRolloverIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getRolloverIcon()
	{
		return null;
	}


	/**
	* Returns the selected icon for this button.
	*
	* @return		the <code>selectedIcon</code> property
	* @see		#setSelectedIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getSelectedIcon()
	{
		return null;
	}


	/**
	* Returns the disabled icon for this button. If no disabled icon is set, this
	* method will return <code>null</code> and the client
will create an icon from
	* the default icon (returned by <code>getIcon()</code>).
	*
	* @return		the <code>disabledIcon</code> property
	* @see		#getIcon
	* @see		#setDisabledIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getDisabledIcon()
	{
		return null;
	}


	/**
	* Removes an <code>ActionListener</code> from this button.
	*
	* @param l 		 the listener to be removed
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener l)
	{
	}


	/**
	* Sets the action command property for this button.
	*
	* @param actionCommand 		 the action command for the button
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Sets the icon property for this button. If there is no explicit "pressed" icon
	* the icon property is used as well.
	*
	* @param defaultIcon 		 the icon to be used as the default image
	* @see		#getIcon
	* @see		#setPressedIcon
	**/
	 public void setIcon(com.ulcjava.base.application.util.ULCIcon defaultIcon)
	{
	}


	/**
	* Sets the button's text.
<p>
</p>
<strong>Note: <strong> Use {@link
	* #setMnemonic(char)} instead of '~' character to define a mnemonic.
	*
	* @param text 		 the string to be used as the text
	* @see		#getText
	**/
	 public void setText(java.lang.String text)
	{
	}


	/**
	* Sets the mnemonic value for this button.
	*
	* @param mnemonic 		 the char specifying the mnemonic value
	**/
	 public void setMnemonic(char mnemonic)
	{
	}


	/**
	* Sets the keyboard mnemonic for this button.
	*
	* @param mnemonic 		 the key code representing the mnemonic
	**/
	 public void setMnemonic(int mnemonic)
	{
	}


	/**
	* Sets the pressed icon for this button.
	*
	* @param pressedIcon 		 the icon to be used as the "pressed" image
	* @see		#getPressedIcon
	**/
	 public void setPressedIcon(com.ulcjava.base.application.util.ULCIcon pressedIcon)
	{
	}


	/**
	* Sets the rollover icon for the button.
	*
	* @param rolloverIcon 		 the icon to be used as the "rollover" image
	* @see		#getRolloverIcon
	**/
	 public void setRolloverIcon(com.ulcjava.base.application.util.ULCIcon rolloverIcon)
	{
	}


	/**
	* Sets the selected icon for the button.
	*
	* @param selectedIcon 		 the icon to be used as the "selected" image
	* @see		#getSelectedIcon
	**/
	 public void setSelectedIcon(com.ulcjava.base.application.util.ULCIcon selectedIcon)
	{
	}


	/**
	* Sets the disabled icon for this button. If no disabled icon is set, the client
	* will create an icon from the default icon (returned
	* by
<code>getIcon()</code>).
<p>
</p>
Note that the disabled icon will only be
	* displayed if a default icon is set (through <code>setIcon(ULCIcon)</code>).
	*
	* @param disabledIcon 		 the icon to be used as the "disabled" image
	* @see		#getIcon
	* @see		#getDisabledIcon
	**/
	 public void setDisabledIcon(com.ulcjava.base.application.util.ULCIcon disabledIcon)
	{
	}


	/**
	* Returns the vertical alignment of the text and icon for this button.
	*
	* @return		the <code>verticalAlignment</code> property, one of the following values:
<ul>
<li>CENTER (the default)
<li>TOP
<li>BOTTOM
</ul>
	**/
	 public int getVerticalAlignment()
	{
		return 0;
	}


	/**
	* Sets the vertical alignment of the text and icon for this button.
	*
	* @param verticalAlignment 		 one of the following values:
<ul>
<li>CENTER (the default)
<li>TOP
<li>BOTTOM
</ul>
	**/
	 public void setVerticalAlignment(int verticalAlignment)
	{
	}


	/**
	* Returns the horizontal alignment of the text and icon for this button.
	*
	* @return		the <code>horizontalAlignment</code> property, one of the following values:
<ul>
<li>RIGHT (the default)
<li>LEFT
<li>CENTER
<li>LEADING
<li>TRAILING
</ul>
	**/
	 public int getHorizontalAlignment()
	{
		return 0;
	}


	/**
	* Sets the horizontal alignment of the text and icon for this button.
	*
	* @param horizontalAlignment 		 one of the following values:
<ul>
<li>RIGHT
<li>LEFT
<li>CENTER (the default)
<li>LEADING
<li>TRAILING
</ul>
	**/
	 public void setHorizontalAlignment(int horizontalAlignment)
	{
	}


	/**
	* Returns the vertical position of the text relative to the icon.
	*
	* @return		the <code>verticalTextPosition</code> property, one of the following values:
<ul>
<li>CENTER (the default)
<li>TOP
<li>BOTTOM
</ul>
	**/
	 public int getVerticalTextPosition()
	{
		return 0;
	}


	/**
	* Sets the vertical position of the text relative to the icon.
	*
	* @param verticalTextPosition 		 one of the following values:
<ul>
<li>CENTER (the default)
<li>TOP
<li>BOTTOM
</ul>
	**/
	 public void setVerticalTextPosition(int verticalTextPosition)
	{
	}


	/**
	* Returns the horizontal position of the text relative to the icon.
	*
	* @return		the <code>horizontalTextPosition</code> property, one of the following values:
<ul>
<li>RIGHT (the default)
<li>LEFT
<li>CENTER
<li>LEADING
<li>TRAILING
</ul>
	**/
	 public int getHorizontalTextPosition()
	{
		return 0;
	}


	/**
	* Sets the horizontal position of the text relative to the icon.
	*
	* @param horizontalTextPosition 		 one of the following values:
<ul>
<li>RIGHT
<li>LEFT
<li>CENTER
<li>LEADING
<li>TRAILING (the default)
</ul>
	**/
	 public void setHorizontalTextPosition(int horizontalTextPosition)
	{
	}


	/**
	* Returns the margin space between the button's border and its label.
	*
	* @return		the margin
	**/
	 public com.ulcjava.base.application.util.Insets getMargin()
	{
		return null;
	}


	/**
	* Sets the margin space between the button's border and its text.
	*
	* @param margin 		 the margin
	**/
	 public void setMargin(com.ulcjava.base.application.util.Insets margin)
	{
	}


	/**
	* Returns the space between the text and the icon of this button.
	*
	* @return		the number of pixels between the text and the icon.
	**/
	 public int getIconTextGap()
	{
		return 0;
	}


	/**
	* Sets the space between the text and the icon of this button (if both are set).
	*
	* @param iconTextGap 		 the space between text and icon in pixels
	**/
	 public void setIconTextGap(int iconTextGap)
	{
	}


	/**
	* Returns whether the border is painted.
	*
	* @return		true if the border is painted, false otherwise
	**/
	 public boolean isBorderPainted()
	{
		return false;
	}


	/**
	* Sets whether the focus should be painted.
	*
	* @param borderPainted 		 if true, the border will be painted.
	**/
	 public void setBorderPainted(boolean borderPainted)
	{
	}


	/**
	* Returns whether the focus is painted.
	*
	* @return		true if the focus is painted, false otherwise
	**/
	 public boolean isFocusPainted()
	{
		return false;
	}


	/**
	* Sets whether the focus should be painted.
	*
	* @param paintFocus 		 if true, the focus will be painted.
	**/
	 public void setFocusPainted(boolean paintFocus)
	{
	}


	/**
	* Sets the action. Any previously set action is removed first. In addition, the
	* component uses the properties defined in the action
object to adapt the
	* visualrepresentation (text, icon, tooltip text, ...). The action is
	* registeredas action listener with the
component.
<p>
</p>
Action listeners
	* registered using <code>addActionListener()</code> are not affected by this
	* operation.
	*
	* @param action 		 the action to be set
	**/
	 public void setAction(com.ulcjava.base.application.IAction action)
	{
	}


	/**
	* Returns the action set for this component.
	*
	* @return		an <code>IAction</code> object or null
	**/
	 public com.ulcjava.base.application.IAction getAction()
	{
		return null;
	}


	/**
	* Returns whether the content area is filled.
	*
	* @return		true if the content area is filled, false otherwise
	**/
	 public boolean isContentAreaFilled()
	{
		return false;
	}


	/**
	* Sets whether the button should paint the content area or leave it transparent.
	* For a transparent button (e.g. with icon only) you
should set this property
	* to<code>false</code> and do not call <code>setOpaque(false)</code>. The
	* default value is
<code>true</code>. Note: This function may cause the
	* component's opaque property to change dependeing on look and feel.
	*
	* @param contentAreaFilled 		 true to fill content area, false otherwise
	* @see		#isContentAreaFilled
	* @see		ULCComponent#setOpaque
	**/
	 public void setContentAreaFilled(boolean contentAreaFilled)
	{
	}


	/**
	* Returns index of the character that should be decorated by look and feel as a
	* mnemonic.
	*
	* @return		index corresponding to the mnemonic character
	* @see		#setDisplayedMnemonicIndex
	**/
	 public int getDisplayedMnemonicIndex()
	{
		return 0;
	}


	/**
	* Sets the index of the character from the button text that should be decorated
	* by look and feel as the mnemonic. This property is look
and feel dependent.
	* Use this method when the default character should not be underlined. A value
	* of -1 indicates one of the
following:
<ul>
<li> there is no mnemonic
<li> the
	* mnemonic character is not part of button text
<li> do not display the
	* mnemonic.
</ul>
	*
	* @param mnemonicIndex 		 Index of the char in button text that should be underlined
	* @exception		IllegalArgumentException when <code>index</code> is out of bounds of the button text
	**/
	 public void setDisplayedMnemonicIndex(int mnemonicIndex)
	{
	}


	/**
	* Returns the time duration (in milliseconds) required between mouse click on
	* thebutton to generate the corresponding action events.
	*
	* @see		#setMultiClickThreshhold
	* @return		the time duration (in milliseconds) required between mouse clicks to generate corresponding action events
	**/
	 public long getMultiClickThreshhold()
	{
		return 0L;
	}


	/**
	* Sets the time duration (in milliseconds) required between mouse click on the
	* button to generate the corresponding action events.
	*
	* @see		#getMultiClickThreshhold
	* @param multiClickThreshhold 		 the time duration (in milliseconds) between mouse clicks to generate corresponding action events
	* @exception		IllegalArgumentException if threshhold < 0
	**/
	 public void setMultiClickThreshhold(long multiClickThreshhold)
	{
	}


	/**
	* Returns whether the rollover effect is enabled.
	*
	* @return		true if the rollover effect is enabled, false otherwise
	**/
	 public boolean isRolloverEnabled()
	{
		return false;
	}


	/**
	* Sets whether the rollover effects should be enabled. The default value is
	* <code>false</code>.
	*
	* @param rolloverEnabled 		 true enable rollover effects, false otherwise
	* @see		#isRolloverEnabled()
	**/
	 public void setRolloverEnabled(boolean rolloverEnabled)
	{
	}


	/**
	* Returns the rollover selection icon for the button.
	*
	* @return		the <code>rolloverSelectedIcon</code>
	* @see		#setRolloverSelectedIcon
	**/
	 public com.ulcjava.base.application.util.ULCIcon getRolloverSelectedIcon()
	{
		return null;
	}


	/**
	* Sets the rollover selected icon for the button.
	*
	* @param rolloverSelectedIcon 		 the icon used as the "selected rollover" image
	* @see		#getRolloverSelectedIcon
	**/
	 public void setRolloverSelectedIcon(com.ulcjava.base.application.util.ULCIcon rolloverSelectedIcon)
	{
	}

	 public com.ulcjava.base.application.util.ULCIcon getDisabledSelectedIcon()
	{
		return null;
	}


	/**
	* Sets the disabled selected icon for the button.
	*
	* @param disabledSelectedIcon 		 the icon used in the disabled selected state
	* @see		#getDisabledSelectedIcon
	**/
	 public void setDisabledSelectedIcon(com.ulcjava.base.application.util.ULCIcon disabledSelectedIcon)
	{
	}


	/**
	* Returns whether this button is selected.
	*
	* @return		true if the button is selected
	**/
	 public boolean isSelected()
	{
		return false;
	}


	/**
	* Selects or deselects the button as specified by <code>selected</code>.
	*
	* @param selected 		 true selects the button, false deselects the button.
	**/
	 public void setSelected(boolean selected)
	{
	}


	/**
	* Adds an <code>ValueChangedListener</code> to this button.
	*
	* @param l 		 the <code>ValueChangedListener</code> to be added
	**/
	 public void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener l)
	{
	}


	/**
	* Returns an array of all the <code>IValueChangedListener</code>s added to this
	* button with <code>addValueChangedListener()</code>.
	*
	* @return		all <code>IValueChangedListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IValueChangedListener[] getValueChangedListeners()
	{
		return null;
	}


	/**
	* Removes an <code>ValueChangedListener</code> from this button.
	*
	* @param l 		 the listener to be removed
	**/
	 public void removeValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener l)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}

	 protected  final void configureDefaultPropertiesFromAction(com.ulcjava.base.application.IAction action, java.util.List actionPropertyKeys)
	{
	}

	 protected  final java.beans.PropertyChangeListener createDefaultPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}

	 protected void updateSelected(boolean selected)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCAbstractButtonDispatcher extends ULCComponentDispatcher
{

	 public  final void updateSelected(boolean selected)
	{
	}


}
}