package com.ulcjava.base.application;


	/**
	* This class implements the <code>IValueChangedListener</code> part of the
	* <code>ISpinnerModel</code> interface. Subclasses must
provide an
	* implementation of the value property.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCProxy
	* @see		com.ulcjava.base.application.ULCSpinner
	* @see		com.ulcjava.base.application.ISpinnerModel
	**/
 public  abstract class ULCAbstractSpinnerModel extends com.ulcjava.base.application.ULCProxy implements com.ulcjava.base.application.ISpinnerModel
{


	/**
	* Adds a <code>IValueChangedListener</code> to the list that is notified when
	* themodel's value changes.
	*
	* @param listener 		 the IValueChangedListener to add
	* @see		#removeValueChangedListener(IValueChangedListener)
	**/
	 public void addValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}


	/**
	* Removes a <code>IValueChangedListener</code> from the list that is notified
	* when the model's value changes.
	*
	* @param listener 		 the IValueChangedListener to remove
	* @see		#addValueChangedListener
	**/
	 public void removeValueChangedListener(com.ulcjava.base.application.event.IValueChangedListener listener)
	{
	}


	/**
	* Returns an array of all the <code>IValueChangedListener</code>s registered on
	* this model.
	*
	* @return		all of this model's <code>IValueChangedListener</code>s, or an empty array if no listeners are currently registered
	* @see		#addValueChangedListener(IValueChangedListener)
	* @see		#removeValueChangedListener(IValueChangedListener)
	**/
	 public com.ulcjava.base.application.event.IValueChangedListener[] getValueChangedListeners()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCAbstractSpinnerModelDispatcher extends ULCProxyDispatcher
{


}
}