package com.ulcjava.base.application;


	/**
	* <code>ULCCheckBoxMenuItems</code> can be used to define check box behavior for
	* menu items.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCCheckBoxMenuItem</code> component inherits all features from
	* <code>ULCToggleMenuItem</code>,
<code>ULCMenuItem</code>,
	* <code>ULCAbstractButton</code> and
	* <code>ULCComponent</code>.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* example shows how to create a
	* <code>ULCCheckBoxMenuItem</code>.

<pre>
ULCCheckBoxMenuItem one = new
	* ULCCheckBoxMenuItem(&quot;One&quot;,
	* true);
one.setMnemonic('o');
one.addValueChangedListener(valueChangedListener);
	* </pre>
	*
	* @ulc.application		
	* @see		ULCToggleMenuItem
	* @see		ULCMenuItem
	* @see		ULCAbstractButton
	* @see		ULCComponent
	**/
 public class ULCCheckBoxMenuItem extends com.ulcjava.base.application.ULCToggleMenuItem
{


	/**
	* Constructs a check box menu item, initially unselected with no text or image.
	*
	**/
	 public ULCCheckBoxMenuItem()
	{
		 super();
	}


	/**
	* Constructs a check box menu item, initially unselected with no text and with a
	* given image.
	*
	* @param icon 		 the icon to be displayed
	**/
	 public ULCCheckBoxMenuItem(com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs a check box menu item, initially unselected with given text.
	*
	* @param text 		 the label to be shown on this item
	**/
	 public ULCCheckBoxMenuItem(java.lang.String text)
	{
		 super();
	}


	/**
	* Constructs a check box menu item, initially unselected with given text and icon.
	*
	* @param text 		 the label to be shown on this item
	* @param icon 		 the icon to be displayed
	**/
	 public ULCCheckBoxMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon)
	{
		 super();
	}


	/**
	* Constructs a check box menu item, in a given state with given text.
	*
	* @param text 		 the label to be shown on this item
	* @param b 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCCheckBoxMenuItem(java.lang.String text, boolean b)
	{
		 super();
	}


	/**
	* Constructs a check box menu item, with given text, icon and selection state.
	*
	* @param text 		 the label to be shown on this item
	* @param icon 		 the icon to be displayed
	* @param b 		 if true, the menu item is initially selected; otherwise, the menu item is initially unselected
	**/
	 public ULCCheckBoxMenuItem(java.lang.String text, com.ulcjava.base.application.util.ULCIcon icon, boolean b)
	{
		 super();
	}


	/**
	* Create a check box menu item with the properties defined in the action object.
	* The action is registered as action listener with the
check box menu item.
	*
	* @param action 		 the action containing the check box menu item properties
	**/
	 public ULCCheckBoxMenuItem(com.ulcjava.base.application.IAction action)
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCCheckBoxMenuItemDispatcher extends ULCToggleMenuItemDispatcher
{


}
}