package com.ulcjava.base.application;


	/**
	* The <code>ULCComboBox</code> component presents a drop-down list from which a
	* user can choose an item. Additionally, the user can also
type in a custom
	* value.
<p>
<b>Features</b>
<ul>
<li>The <code>ULCComboBox</code> component
	* inherits all features of <code>ULCComponent</code>.
<li>An
	* <code>IComboBoxModel</code> provides the list of items presented by the combo
	* box and keeps track of the currently selected item.
<li>Typing in a custom
	* value can be allowed or disallowed by setting the editable property
	* accordingly.
<li>The application can register <code>IActionListener</code>s,
	* which are notified whenever the user finishes making a selection or
	* the
application changes the selection programmatically.
<li>A combo box can
	* beused as an enabler, enabling the target component if the current selection
	* is not null.
<li>A custom cell renderer can be specified to specially render
	* the items in the list. Moreover, a custom combo box editor can be
specified
	* toedit the selected item in the combo box field.
<li>The
	* <code>ULCComboBox</code> supports selecting items through keystrokes
	* (wheneverthe keyboard focus is on the combo box). The
default implementation
	* toggles the selection over all items starting with the typed character. The
	* application can install a custom
<code>IKeySelectionManager</code> that is
	* called for every typed character and returns the index that should be
	* selected.
<li>Actions can be set on <code>ULCComboBox</code>.
<li>The
	* application can register <code>IPopupMenuListener</code>s, which are notified
	* whenever the combobox's popup list is about to
become visible or invisible or
	* when it is canceled.
</ul>
<b>Examples</b>
<p>
The following code snippet
	* shows how to use a <code>ULCComboBox</code>. The combo box is configured to
	* beeditable. The snippet installs
an <code>IActionListener</code> that gets
	* informed whenever the user finishes a selection (i.e., chooses a new value or
	* finishes entering
a custom value).

<pre>
ULCComboBox comboBox = new
	* ULCComboBox(new String[] {&quot;One&quot;,
	* &quot;Two&quot;,
&quot;Three&quot;,&quot;Four&quot;,
	* &quot;Five&quot;});
comboBox.setEditable(true);
comboBox.setMaximumRowCount(3);
	* comboBox.setSelectedItem(&quot;Custom
	* Value&quot;);
comboBox.addActionListener(new IActionListener() {
public void
	* actionPerformed(ActionEvent event) {
ULCComboBox source =
	* (ULCComboBox)event.getSource();
System.out.println(&quot;new item chosen:
	* &quot; + source.getSelectedItem());
}
});
</pre>
The following code snippet
	* shows how to install a custom <code>IKeySelectionManager</code> on a
	* <code>ULCComboBox</code>. The given
implementation will take into account all
	* key strokes within a given time interval when determining what item to
	* select.
<pre>
comboBox.setKeySelectionManager(new
	* SampleKeySelectionManager());
...
private static class
	* SampleKeySelectionManager
implements ULCComboBox.IKeySelectionManager
	* {
private static final int MAX_DELAY = 1000;
private long
	* fLastMillis;
privateStringBuffer fLastEnteredChars;
public
	* SampleKeySelectionManager() {
fLastMillis = 0;
fLastEnteredChars = new
	* StringBuffer();
}
public int selectionForKey(char keyChar, IComboBoxModel
	* model) {
if (System.currentTimeMillis() - fLastMillis &gt; MAX_DELAY)
	* {
fLastEnteredChars.setLength(0);
}
fLastMillis =
	* System.currentTimeMillis();
fLastEnteredChars.append(keyChar);
for (int i =
	* 0;i &lt; model.getSize(); i++) {
String item =
	* model.getElementAt(i).toString().toLowerCase();
String typedKeys =
	* fLastEnteredChars.toString().toLowerCase();
if (item.startsWith(typedKeys))
	* {
return i;
}
}
return -1;
}
}
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComponent
	* @see		com.ulcjava.base.application.IComboBoxModel
	* @see		com.ulcjava.base.application.DefaultComboBoxModel
	* @see		com.ulcjava.base.application.event.IPopupMenuListener
	**/
 public class ULCComboBox extends com.ulcjava.base.application.ULCComponent implements com.ulcjava.base.application.IRendererComponent, com.ulcjava.base.application.enabler.IEnabler, com.ulcjava.base.application.event.IListDataListener, com.ulcjava.base.application.IEditorComponent
{

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void processActionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ActionEvent actionEvent)
	{
	}

	 protected void updateSelectionForKey(char key)
	{
	}

	 protected java.lang.String getPropertyPrefix()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public void copyAttributes(com.ulcjava.base.server.ICellComponent source)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 public boolean areAttributesEqual(com.ulcjava.base.server.ICellComponent component)
	{
		return false;
	}

	 public int attributesHashCode()
	{
		return 0;
	}

	 protected void uploadStateUI()
	{
	}

	 public void intervalAdded(com.ulcjava.base.application.event.ListDataEvent e)
	{
	}

	 public void intervalRemoved(com.ulcjava.base.application.event.ListDataEvent e)
	{
	}

	 public void contentsChanged(com.ulcjava.base.application.event.ListDataEvent e)
	{
	}


	/**
	* Creates a <code>ULCComboBox</code> with an empty model.
	*
	**/
	 public ULCComboBox()
	{
		 super();
	}


	/**
	* Creates a <code>ULCComboBox</code> with the given <code>IComboBoxModel</code>.
	*
	* @param model 		 the <code>IComboBoxModel</code> that provides the displayed list of items
	**/
	 public ULCComboBox(com.ulcjava.base.application.IComboBoxModel model)
	{
		 super();
	}


	/**
	* Creates a <code>ULCComboBox</code> that contains the elements in the specified
	* <code>List</code>. By default the first item in the
list becomes selected.
	*
	* @param items 		 a list of items to insert into the combo box
	**/
	 public ULCComboBox(java.util.List items)
	{
		 super();
	}


	/**
	* Creates a <code>ULCComboBox</code> that contains the elements in the specified
	* array. By default the first item in the array becomes
selected.
	*
	* @param items 		 an array of objects to insert into the combo box
	**/
	 public ULCComboBox(java.lang.Object[] items)
	{
		 super();
	}


	/**
	* Adds an <code>IActionListener</code>. The listener will receive an action
	* eventwhen the user finishes making a selection or the
application sets the
	* selection programmatically.
	*
	* @param listener 		 the <code>IActionListener</code> that is to be notified
	**/
	 public void addActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Adds an item to the list. This method works only if the
	* <code>ULCComboBox</code> uses an <code>IMutableComboBoxModel</code>
	* (e.g.,
the<code>DefaultComboBoxModel</code>). <code>ULCComboBox</code> uses
	* the <code>DefaultComboBoxModel</code> data model when created
with the empty
	* constructor and no other model has been set.
	*
	* @param item 		 the item to add to the list
	**/
	 public void addItem(java.lang.Object item)
	{
	}


	/**
	* Returns the action command that is included in the event sent to action
	* listeners.
	*
	* @return		the string containing the "command" that is sent to action listeners.
	**/
	 public java.lang.String getActionCommand()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IActionListener</code>s added to this
	* <code>ULCComboBox</code> with
<code>addActionListener()</code>.
	*
	* @return		all <code>IActionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IActionListener[] getActionListeners()
	{
		return null;
	}


	/**
	* Returns the editor used to paint and edit the selected item in the ULCComboBox
	* field. Returns <code>null</code> if the default is
used.
	*
	* @return		the IComboBoxEditor that displays the selected item
	**/
	 public com.ulcjava.base.application.IComboBoxEditor getEditor()
	{
		return null;
	}


	/**
	* Returns the item at the specified index.
	*
	* @param index 		 an integer indicating the position
	* @return		the item at the specified position
	**/
	 public java.lang.Object getItemAt(int index)
	{
		return null;
	}


	/**
	* Returns the number of items in the list.
	*
	* @return		the number of items in the list
	**/
	 public int getItemCount()
	{
		return 0;
	}


	/**
	* Returns the combo box's <code>IKeySelectionManager</code>.
	*
	* @return		the currently installed <code>IKeySelectionManager</code>
	**/
	 public com.ulcjava.base.application.ULCComboBox$IKeySelectionManager getKeySelectionManager()
	{
		return null;
	}


	/**
	* Returns the maximum number of items the combo box can display without a
	* scrollbar.
	*
	* @return		the maximum number of items that are displayed in the combo box before using a scrollbar
	**/
	 public int getMaximumRowCount()
	{
		return 0;
	}


	/**
	* Returns the data model currently used by the <code>ULCComboBox</code>.
	*
	* @return		the <code>IComboBoxModel</code> that provides the displayed list of items
	**/
	 public com.ulcjava.base.application.IComboBoxModel getModel()
	{
		return null;
	}


	/**
	* Returns the renderer used to display the items in the
	* <code>ULCComboBox</code>.Returns <code>null</code> if the default is used.
	*
	* @return		the <code>IComboBoxCellRenderer</code> that renderers the items
	**/
	 public com.ulcjava.base.application.IComboBoxCellRenderer getRenderer()
	{
		return null;
	}


	/**
	* Returns the first item in the list that matches the selected item. Returns -1
	* if there is no selected item or if the combo box is
editable and the user
	* specified an item which is not in the list.
	*
	* @return		an integer specifying the currently selected list item, or -1 if no item is selected or if the currently selected item is not
in the list
	**/
	 public int getSelectedIndex()
	{
		return 0;
	}


	/**
	* Returns the currently selected item.
	*
	* @return		the currently selected item in the list
	**/
	 public java.lang.Object getSelectedItem()
	{
		return null;
	}


	/**
	* Causes the combo box to close its popup window.
	*
	**/
	 public void hidePopup()
	{
	}


	/**
	* Inserts an item into the list at a given index. This method works only if the
	* <code>ULCComboBox</code> uses an
<code>IMutableComboBoxModel</code> (e.g.,
	* the<code>DefaultComboBoxModel</code>). <code>ULCComboBox</code> uses
	* the
<code>DefaultComboBoxModel</code> data model when created with the empty
	* constructor and no other model has been set.
	*
	* @param item 		 the item to add to the list
	* @param index 		 an int specifying the position at which to add the item
	**/
	 public void insertItemAt(java.lang.Object item, int index)
	{
	}


	/**
	* Returns true if the <code>ULCComboBox</code> is editable. By default, a combo
	* box is not editable.
	*
	* @return		true if the <code>ULCComboBox</code> is editable, else false
	**/
	 public boolean isEditable()
	{
		return false;
	}


	/**
	* Removes an <code>IActionListener</code>.
	*
	* @param listener 		 the <code>IActionListener</code> to remove
	**/
	 public void removeActionListener(com.ulcjava.base.application.event.IActionListener listener)
	{
	}


	/**
	* Removes all items from the list. This method works only if the
	* <code>ULCComboBox</code> uses an <code>IMutableComboBoxModel</code>
(e.g.,
	* the<code>DefaultComboBoxModel</code>). <code>ULCComboBox</code> uses the
	* <code>DefaultComboBoxModel</code> data model when
created with the empty
	* constructor and no other model has been set.
	*
	**/
	 public void removeAllItems()
	{
	}


	/**
	* Removes an item from the list. This method works only if the
	* <code>ULCComboBox</code> uses an <code>IMutableComboBoxModel</code>
(e.g.,
	* the<code>DefaultComboBoxModel</code>). <code>ULCComboBox</code> uses the
	* <code>DefaultComboBoxModel</code> data model when
created with the empty
	* constructor and no other model has been set.
	*
	* @param item 		 the item to remove from the list
	**/
	 public void removeItem(java.lang.Object item)
	{
	}


	/**
	* Removes the item at <code>index</code>. This method works only if the
	* <code>ULCComboBox</code> uses an
<code>IMutableComboBoxModel</code> (e.g.,
	* the<code>DefaultComboBoxModel</code>). <code>ULCComboBox</code> uses
	* the
<code>DefaultComboBoxModel</code> data model when created with the empty
	* constructor and no other model has been set.
	*
	* @param index 		 the index of the item to remove
	**/
	 public void removeItemAt(int index)
	{
	}


	/**
	* Sets the action commnand that should be included in the event sent to action
	* listeners.
	*
	* @param actionCommand 		 a string containing the "command" that is sent to action listeners
	**/
	 public void setActionCommand(java.lang.String actionCommand)
	{
	}


	/**
	* Determines whether the <code>ULCComboBox</code> field is editable. An editable
	* <code>ULCComboBox</code> allows the user to type into
the field or select an
	* item from the list to initialize the field, after which it can be edited.
	* (Theediting affects only the field,
the list item remains intact.) A
	* non-editable <code>ULCComboBox</code> displays the selected item in the field
	* but the selection
cannot be modified.
	*
	* @param editable 		 a boolean value where true indicates that the field is editable
	**/
	 public void setEditable(boolean editable)
	{
	}


	/**
	* Sets the editor used to paint and edit the selected item in the ULCComboBox
	* field. The editor is used only if the receiving
ULCComboBox is editable. If
	* not editable, the combo box uses the renderer to paint the selected item.
	*
	* @param editor 		 the IComboBoxEditor that displays the selected item
	**/
	 public void setEditor(com.ulcjava.base.application.IComboBoxEditor editor)
	{
	}


	/**
	* Sets the <code>IKeySelectionManager</code> that translates a keyboard
	* characterinto a list selection. The default selects the first
item with a
	* matching first character. <br>
<br>
<b>Note:</b> key selection manager is
	* invoked asynchronoulsy
	*
	* @param keySelectionManager 		 the key selection manager
	**/
	 public void setKeySelectionManager(com.ulcjava.base.application.ULCComboBox$IKeySelectionManager keySelectionManager)
	{
	}


	/**
	* Sets the maximum number of rows the <code>ULCComboBox</code> displays. If the
	* number of objects in the model is greater than count,
the combo box uses a
	* scrollbar.
	*
	* @param count 		 the maximum number of items to display in the combo box before using a scrollbar
	**/
	 public void setMaximumRowCount(int count)
	{
	}


	/**
	* Sets the data model that the <code>ULCComboBox</code> uses to obtain the list
	* of items.
	*
	* @param dataModel 		 the <code>IComboBoxModel</code> that provides the displayed list of items
	**/
	 public void setModel(com.ulcjava.base.application.IComboBoxModel dataModel)
	{
	}


	/**
	* Sets the visibility of the popup.
	*
	* @param visible 		 if <code>true</code>, show the popup; otherwise, hide the popup.
	**/
	 public void setPopupVisible(boolean visible)
	{
	}


	/**
	* Sets the renderer that paints the items in the combo box as well as the
	* selected item. The renderer is used for the selected item
only if the
	* ULCComboBox is not editable. If it is editable, the editor is used to render
	* and edit the selected item. Note that for
the selected item, the visual
	* attributes such as font etc. are copied from the ULCComboBox
	* itself.
<p>
</p>
To display the selected item,
	* <code>IComboBoxCellRenderer.getComboBoxCellRendererComponent()</code> is
	* called, passing the list
object and an index of -1.
	*
	* @param renderer 		 the <code>IComboBoxCellRenderer</code> that renders the items
	**/
	 public void setRenderer(com.ulcjava.base.application.IComboBoxCellRenderer renderer)
	{
	}


	/**
	* Selects the item at the given <code>index</code>. When passing -1 as index,
	* thecombo box will display an empty selection
	* and
<code>getSelectedItem()</code> will return <code>null</code> as the
	* selection.
	*
	* @param index 		 an integer specifying the list item to select
	**/
	 public void setSelectedIndex(int index)
	{
	}


	/**
	* Sets the selected item in the <code>ULCComboBox</code>.
	*
	* @param item 		 the list object to select
	**/
	 public void setSelectedItem(java.lang.Object item)
	{
	}


	/**
	* Causes the combo box to display its popup window.
	*
	**/
	 public void showPopup()
	{
	}


	/**
	* Sets the action. Any previously set action is removed first. In addition, the
	* combo box uses the enabled and enabler properties
defined in the action
	* objectto adapt the enabling state. The action is registered as action
	* listenerwith the combo box.
<p>
</p>
Action listeners registered using
	* <code>addActionListener()</code> are not affected by this operation.
	*
	* @param action 		 the action to be set
	**/
	 public void setAction(com.ulcjava.base.application.IAction action)
	{
	}


	/**
	* Returns the action set for this component.
	*
	* @return		an <code>IAction</code> object or null
	**/
	 public com.ulcjava.base.application.IAction getAction()
	{
		return null;
	}


	/**
	* Returns the object that acts as a prototype for display value.
	*
	* @return		the prototype display value object
	* @see		#setPrototypeDisplayValue
	**/
	 public java.lang.Object getPrototypeDisplayValue()
	{
		return null;
	}


	/**
	* Sets the object that acts as a prototype for display value and that is used
	* forthe calculation of the display height and width.
<p>
When specified, the
	* combo box's preferred size is computed by configuring the renderer with the
	* prototype display value and obtaining
its preferred size. Set this property
	* when the como box is displaying large amount of data. Note: For a custom
	* object a
<code>com.ulcjava.base.shared.IStreamCoder</code> needs to be
	* registered.
	*
	* @param		prototypeDisplayValue
	* @see		#getPrototypeDisplayValue
	**/
	 public void setPrototypeDisplayValue(java.lang.Object prototypeDisplayValue)
	{
	}


	/**
	* Add a popup menu listener.
	*
	* @param listener 		 the listener to be added
	**/
	 public void addPopupMenuListener(com.ulcjava.base.application.event.IPopupMenuListener listener)
	{
	}


	/**
	* Remove a popup menu listener.
	*
	* @param listener 		 the listener to be removed
	**/
	 public void removePopupMenuListener(com.ulcjava.base.application.event.IPopupMenuListener listener)
	{
	}


	/**
	* Returns an array of all popup menu listeners registered on this model.
	*
	* @return		all of this objects's <code>IPopupMenuListener</code>s or an empty array if no popup menu listeners are currently registered
	* @see		#addPopupMenuListener(IPopupMenuListener)
	* @see		#removePopupMenuListener(IPopupMenuListener)
	**/
	 public com.ulcjava.base.application.event.IPopupMenuListener[] getPopupMenuListeners()
	{
		return null;
	}

	 protected void configurePropertiesFromAction(com.ulcjava.base.application.IAction action)
	{
	}

	 protected java.beans.PropertyChangeListener createActionPropertyChangeListener(com.ulcjava.base.application.IAction action)
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* The interface that defines an <code>IKeySelectionManager</code> which
	* identifies the list index to be selected after a key stroke,
given the
	* character and the combo box data model.
	*
	* @ulc.application		
	**/
 public interface IKeySelectionManager
{


	/**
	* Given <code>keyChar</code> and the model, returns the row that should become
	* selected. Return -1 if no match was found.
	*
	* @param keyChar 		 a char value indicating a keyboard key that was pressed
	* @param model 		 the data model of the combo box
	* @return		the row to be selected, -1 is none
	**/
	 public int selectionForKey(char keyChar, com.ulcjava.base.application.IComboBoxModel model);

}
	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCComboBoxDispatcher extends ULCComponentDispatcher
{

	 public  final void updateSelectionForKey(char key)
	{
	}


}
}