package com.ulcjava.base.application;


	/**
	* <code>ULCComponent</code> is the abstract base class for all visual ULC
	* components. It comprises attributes and features that are
common to all
	* visualcomponents.
<p>
</p>
<b>Features</b>
<ul>
<li>The basic visual
	* attributes are foreground color, background color, cursor, font, enabled
	* state, and visibility state.
<li>The opaque property can be set. The default
	* value is dependent on the look and feel.
<li>A border can be set on a
	* component to provide specialized edges, title and empty spaces around
	* it.
<li>For each component a tool tip text can be set. This text is displayed
	* when the mouse cursor rests on the component for a while.
	* Use
<code>HtmlUtilities</code> to create multiline tool tip texts.
<li>A
	* pop-up menu can be defined that is brought up when the user requests the
	* context menu on the component.
<li>The application can register listeners
	* (<code>IFocusListener</code>) that are notified when the component gains or
	* loses focus.
<li>An application can register an <code>IKeyListener</code> to
	* be notified about keystrokes that occurred in
	* the
<code>ULCTextComponent</code>.
<li>An application can register keyboard
	* actions.
<li>All components offer the possibility to programmatically request
	* the focus and to specify a custom focus order.
<li>All components support the
	* enabler concept. Enablers can be used to automatically enable a component
	* uponcertain conditions
(without server roundtrip).
<li>Arbitrary client
	* properties can be set as key/value pairs. This feature can be used to disable
	* the lazy loading for
<code>ULCList</code>, <code>ULCTable</code>,
	* <code>ULCTree</code> and <code>ULCTableTree</code>
	* (<code>"disableLazyLoading"/Boolean.TRUE</code>).
</ul>
<p>
</p>
<b>Examples</b
	* >
<p>
</p>
To set the visual attributes, see the following
	* examples:

<pre>
component.setBackground(Color.red);
component.setOpaque(true);
	* component.setForeground(Color.green);
component.setCursor(Cursor.CROSSHAIR_CURS
	* OR);
component.setFont(new Font(&quot;serif&quot;, Font.BOLD,
	* 18));
component.setEnabled(true);
component.setVisible(true);
component.setBord
	* er(BorderFactory.createLineBorder(Color.red, 5);
</pre>

Tool tip text can
	* consist of multiple lines of
	* text.

<pre>
component.setToolTipText(HTMLUtilities.convertToHtml(&quot;First
	* line\n&quot;
+ &quot;Second line\n&quot; + &quot;Third
	* line&quot;));
</pre>

Apop-up menu is first constructed, and then installed
	* onthe component.

<pre>
ULCPopupMenu menu = new
	* ULCPopupMenu();
menu.add(&quot;One&quot;).addActionListener(new
	* IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
System.out.println(&quot;One
	* selected&quot;);
}
});
menu.addSeparator();
menu.add(&quot;Two&quot;).addAction
	* Listener(new IActionListener() {
public void actionPerformed(ActionEvent
	* event){
System.out.println(&quot;Two
	* selected&quot;);
}
});
component.setComponentPopupMenu(menu);
</pre>

The
	* following example installs an <code>IFocusListener</code> and requests the
	* focus.

<pre>
component.addFocusListener(new IFocusListener() {
public void
	* focusGained(FocusEvent event) {
System.out.println(&quot;gained
	* focus&quot;);
}

public void focusLost(FocusEvent event)
	* {
System.out.println(&quot;lost
	* focus&quot;);
}
});
component.requestFocus();
</pre>

To register a keyboard
	* action:

<pre>
component.registerKeyboardAction(new IActionListener()
	* {
publicvoid actionPerformed(ActionEvent event) {
System.out.println(&quot;F2
	* pressed&quot;);
}
}, KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0,
	* true),
ULCComponent.WHEN_FOCUSED);
</pre>
	*
	* @ulc.application		
	* @see		Color
	* @see		Cursor
	* @see		Font
	* @see		ULCMenu
	* @see		ULCAbstractBorder
	**/
 public  abstract class ULCComponent extends com.ulcjava.base.application.ULCProxy
{

	/**
	* Keyboard action is invoked only when component has focus.
	*
	**/
	 public  final  static int WHEN_FOCUSED = 0;

	/**
	* Keyboard action is invoked when component or ancestor of component has focus.
	*
	**/
	 public  final  static int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 0;

	/**
	* Keyboard action is invoked only when the window containing the component has
	* focus.
	*
	**/
	 public  final  static int WHEN_IN_FOCUSED_WINDOW = 0;

	/**
	* Undefined condition for keyboard action.
	*
	**/
	 public  final  static int UNDEFINED_CONDITION = 0;

	/**
	* Constant for <code>getAlignmentY()</code>. Specifies an alignment to the top
	* ofthe component.
	*
	**/
	 public  final  static float TOP_ALIGNMENT = 0.0f;

	/**
	* Constant for <code>getAlignmentY</code> and <code>getAlignmentX</code>.
	* Specifies an alignment to the center of the component
	*
	**/
	 public  final  static float CENTER_ALIGNMENT = 0.0f;

	/**
	* Constant for <code>getAlignmentY</code>. Specifies an alignment to the bottom
	* of the component.
	*
	**/
	 public  final  static float BOTTOM_ALIGNMENT = 0.0f;

	/**
	* Constant for <code>getAlignmentX</code>. Specifies an alignment to the left
	* side of the component.
	*
	**/
	 public  final  static float LEFT_ALIGNMENT = 0.0f;

	/**
	* Constant for <code>getAlignmentX</code>. Specifies an alignment to the right
	* side of the component.
	*
	**/
	 public  final  static float RIGHT_ALIGNMENT = 0.0f;


	/**
	* Defines the base key for the L&F properties of the component. For instance,
	* ULCLabel returns "Label" which is used in a property such
as Label.border.
	*
	* @return		the base key for the L&F properties of the component
	**/
	 abstract  protected java.lang.String getPropertyPrefix();

	/**
	* Default ULCComponent constructor.
	*
	**/
	 public ULCComponent()
	{
		 super();
	}


	/**
	* Returns the name of this component.
	*
	* @return		the name string
	**/
	 public java.lang.String getName()
	{
		return null;
	}


	/**
	* Sets the name for this component.
	*
	* @param name 		 the name string
	**/
	 public void setName(java.lang.String name)
	{
	}


	/**
	* Sets the name property on the server side and synchronizes a changed property
	* value to the client side. Use this method from
constructors in subclasses in
	* order to set the property value without side effects (as {@link
	* #setName(String)} might be overridden
in subclasses).
<p>
</p>
{@link
	* #setName(String)} delegates to this method.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetName(java.lang.String name)
	{
	}


	/**
	* Returns the parent of this component.
	*
	* @return		parent component
	**/
	 public com.ulcjava.base.application.ULCContainer getParent()
	{
		return null;
	}


	/**
	* Returns the root pane for this component. Note that this method starts the
	* search with the component, not with the ancestor.
	*
	* @return		the root pane for this component
	**/
	 public com.ulcjava.base.application.ULCRootPane getRootPane()
	{
		return null;
	}


	/**
	* Internal method only for setting the parent reference.
	*
	* @param parent 		 the parent ULCContainer
	**/
	 protected void setParent(com.ulcjava.base.application.ULCContainer parent)
	{
	}


	/**
	* Returns the window or applet pane for this component. Note that this method
	* starts the search with the component, not with the
ancestor.
	*
	* @return		the window or applet pane for this component.
	**/
	 public com.ulcjava.base.application.ULCComponent getTopLevelAncestor()
	{
		return null;
	}


	/**
	* Adds the specified focus listener for receiving focus events from this
	* component when this component gains input focus. If l is null,
no exception
	* isthrown and no action is performed.
	*
	* @param l 		 the focus listener.
	* @see		FocusEvent
	* @see		IFocusListener
	* @see		#removeFocusListener
	**/
	 public void addFocusListener(com.ulcjava.base.application.event.IFocusListener l)
	{
	}


	/**
	* Gets the background color of this component.
	*
	* @return		The background color of this component. If no background color has been specified for this component, the background color of
the component's parent is returned
	* @see		#setBackground
	**/
	 public com.ulcjava.base.application.util.Color getBackground()
	{
		return null;
	}


	/**
	* Gets the cursor specified for this component.
	*
	* @return		int representing the cursor value
	* @see		#setCursor
	**/
	 public int getCursor()
	{
		return 0;
	}


	/**
	* Gets the component that will enable/disable this widget.
	*
	* @return		IEnabler The component that will enable/disable this widget.
	* @see		#setEnabler
	**/
	 public com.ulcjava.base.application.enabler.IEnabler getEnabler()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IFocusListener</code>s added to this
	* <code>ULCComponent</code> with
<code>addFocusListener()</code>.
	*
	* @return		all <code>IFocusListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IFocusListener[] getFocusListeners()
	{
		return null;
	}


	/**
	* Gets the font of this component.
	*
	* @return		The font of this component. If no font has been specified for this component, the font of the component's parent is returned
	* @see		#setFont
	**/
	 public com.ulcjava.base.application.util.Font getFont()
	{
		return null;
	}


	/**
	* Gets the foreground color of this component.
	*
	* @return		the foreground color of this component. If no foreground color has been set for this component, the foreground color of the
component's parent is returned
	* @see		#setForeground
	**/
	 public com.ulcjava.base.application.util.Color getForeground()
	{
		return null;
	}


	/**
	* Gets the URL string of the help document for this component.
	*
	* @return		the URL string of the help document for this component.
	* @see		#setHelpDocument
	* @deprecated		Use instead the ULCComponent.registerKeyboardAction() method with a F1 key stroke and the
WHEN_ANCESTOR_OF_FOCUSED_COMPONENT condition as arguments.
	**/
	 public java.lang.String getHelpUrlString()
	{
		return null;
	}


	/**
	* Gets the target of the help document for this component.
<p>
</p>
The target
	* indicates the HTML frame the help document is to be displayed in. The target
	* argument is interpreted as follows:
<ul>
<li><code>"_self"</code>: Show in
	* thewindow and frame that contains the UI engine.
<li><code>"_parent"</code>:
	* Show in the UI engine's parent frame. If the UI engine's frame has no parent
	* frame, acts the same as
"_self".
<li><code>"_top"</code>: Show in the
	* top-level frame of the UI engine's window. If the UI engine's frame is the
	* top-level frame,
acts the same as "_self".
<li><code>"_blank"</code>: Show in
	* a new, unnamed top-level window.
<li><code>name</code>: Show in the frame or
	* window named <code>name</code>. If a target named <code>name</code> does
	* not
already exist, a new top-level window with the specified name is created,
	* and the document is shown there.
</ul>
	*
	* @return		The target of the help document for this widget
	* @see		#setHelpDocument
	* @deprecated		Use instead the ULCComponent.registerKeyboardAction() method with a F1 key stroke and the
WHEN_ANCESTOR_OF_FOCUSED_COMPONENT condition as arguments.
	**/
	 public java.lang.String getHelpTarget()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>IKeyListener</code>s added to this
	* <code>ULCComponent</code> with
<code>addKeyListener()</code>.
	*
	* @return		all <code>IKeyListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.IKeyListener[] getKeyListeners()
	{
		return null;
	}


	/**
	* Get the text to display in a tool tip.
	*
	* @return		The text to display in a tool tip
	* @see		#setToolTipText
	**/
	 public java.lang.String getToolTipText()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected void processKeyboardActionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ActionEvent eventObject)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.ActionEvent createKeyboardActionEvent()
	{
		return null;
	}


	/**
	* Scrolls the component until it is displayed. The minimum of amount of
	* scrollingnecessary to bring the component into view is
performed.
	*
	**/
	 public void scrollToVisible()
	{
	}


	/**
	* Returns whether this component is enabled or disabled. By default components
	* are enabled. An enabled component reacts to user input
and generates events.
	* The method <code>setEnabled</code> changes the enabled state accordingly.
	* Thisvalue only reflects the state
when the widget was uploaded. If the state
	* is changed after the upload using an enabler directly in the UI then this
	* value will not
return the correct state.
	*
	* @return		<code>true</code> if the component is enabled; <code>false</code> otherwise.
	* @see		#setEnabled
	**/
	 public boolean isEnabled()
	{
		return false;
	}


	/**
	* Returns whether this component is visible (provided its parent is visible as
	* well). By default components are visible, except
top-level components such as
	* <code>ULCFrame</code>.
	*
	* @return		<code>true</code> if the component is visible; <code>false</code> otherwise.
	* @see		#setVisible
	**/
	 public boolean isVisible()
	{
		return false;
	}


	/**
	* Registers a keyboard action. <br>
<br>
<b>Note:</b> action is invoked
	* asynchronously
	*
	* @param action 		 the action to be performed
	* @param keyStroke 		 the key stroke that triggers the action
	* @param condition 		 the condition for the action being triggered
	* @see		#WHEN_FOCUSED
	* @see		#WHEN_ANCESTOR_OF_FOCUSED_COMPONENT
	* @see		#WHEN_IN_FOCUSED_WINDOW
	**/
	 public void registerKeyboardAction(com.ulcjava.base.application.event.IActionListener action, com.ulcjava.base.application.util.KeyStroke keyStroke, int condition)
	{
	}


	/**
	* Registers a keyboard action.
	*
	* @param action 		 the action to be performed
	* @param command 		 the command for the action event
	* @param keyStroke 		 the key stroke that triggers the action
	* @param condition 		 the condition for the keyboard action
	* @see		#WHEN_FOCUSED
	* @see		#WHEN_ANCESTOR_OF_FOCUSED_COMPONENT
	* @see		#WHEN_IN_FOCUSED_WINDOW
	**/
	 public void registerKeyboardAction(com.ulcjava.base.application.event.IActionListener action, java.lang.String command, com.ulcjava.base.application.util.KeyStroke keyStroke, int condition)
	{
	}


	/**
	* Unregisters a keyboard action.
	*
	* @param keyStroke 		 the key stroke
	**/
	 public void unregisterKeyboardAction(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
	}


	/**
	* Resets all keyboard actions.
	*
	**/
	 public void resetKeyboardActions()
	{
	}


	/**
	* Returns the key strokes for all registered keyboard actions.
	*
	* @return		the key strokes for all registered keyboard actions
	**/
	 public com.ulcjava.base.application.util.KeyStroke[] getRegisteredKeyStrokes()
	{
		return null;
	}


	/**
	* Returns the value of the property with the specified key, if the property was
	* set with the <code>putClientProperty</code> method.
Otherwise it will return
	* <code>null</code>.
	*
	* @param key 		 being queried
	* @return		the value of the property with this key or <code>null</code>
	* @see		#putClientProperty
	**/
	 public  final java.lang.Object getClientProperty(java.lang.Object key)
	{
		return null;
	}


	/**
	* This method adds an arbitrary key/value "client property" to this ulc
	* component.
<p>
</p>
This method can be used to disable the lazy loading for
	* ULCList, ULCTable, UlCTree and ULCTableTree by setting the client
	* property
key= "disableLazyLoading" value = Boolean.TRUE.
<p>
</p>
If value is
	* <code>null</code> this method will remove the property. The name of the
	* property is <code>key.toString()</code>.
	*
	* @param key 		 the new client property key
	* @param value 		 the new client property value; if <code>null</code> this method will remove the property
	* @see		#getClientProperty
	**/
	 public  final void putClientProperty(java.lang.Object key, java.lang.Object value)
	{
	}


	/**
	* Returns the condition for the keyboard action.
	*
	* @param keyStroke 		 the key stroke
	* @return		the condition for the keyboard action
	**/
	 public int getConditionForKeyStroke(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
		return 0;
	}


	/**
	* Returns the keyboard action.
	*
	* @param keyStroke 		 the key stroke
	* @return		the keyboard action
	**/
	 public com.ulcjava.base.application.event.IActionListener getActionForKeyStroke(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
		return null;
	}


	/**
	* Remove the specified focus listener from the component. The listener no longer
	* receives focus events from this component. Specifying
a not previously added
	* listener or null has no effect and no exception is thrown.
	*
	* @param listener 		 the focus listener.
	* @see		FocusEvent
	* @see		IFocusListener
	* @see		#addFocusListener
	**/
	 public void removeFocusListener(com.ulcjava.base.application.event.IFocusListener listener)
	{
	}


	/**
	* Requests the input focus for this component. Only visible components may
	* request the focus. An invisible component cannot gain focus.
This behavior is
	* same as in Swing where an unrealized component cannot request and get
	* focus.
<p>
</p>
<b>Note:</b> Calling this method before the widget has been
	* uploaded has no effect.
	*
	* @see		FocusEvent
	* @see		#addFocusListener
	**/
	 public void requestFocus()
	{
	}


	/**
	* Requests the input focus for this component, if this component's top-level
	* ancestor is already the focused Window. (If the
corresponding Window does not
	* yet have the focus, it does not get it.) Only visible components may request
	* the focus. Developers must
never assume that this component is the focus
	* owneruntil this component receives a focus gained
	* event.
<p>
</p>
<b>Note:</b>Calling this method before the widget has been
	* uploaded has no effect.
	*
	* @see		FocusEvent
	* @see		#addFocusListener
	**/
	 public void requestFocusInWindow()
	{
	}


	/**
	* Sets the background color of this component.
	*
	* @param c 		 the color to become this component's background color. If null is passed the component inherits the background color of its
parent.
	* @see		#getBackground
	**/
	 public void setBackground(com.ulcjava.base.application.util.Color c)
	{
	}


	/**
	* Sets the cursor to the specified cursor.
	*
	* @param cursor 		 one of the constants defined by the <code>Cursor</code> class.
	* @see		#getCursor
	* @see		Cursor
	**/
	 public void setCursor(int cursor)
	{
	}


	/**
	* Enables or disables this component, as specified by <code>b</code>. An enabled
	* component reacts to user input and generates
events. By default components
	* areenabled.
	*
	* @param enabled 		 if <code>true</code>, this component is enabled; otherwise this component is disabled.
	* @see		#isEnabled
	**/
	 public void setEnabled(boolean enabled)
	{
	}


	/**
	* Sets the component or model that will enable/disable this widget.
	*
	* @param enabler 		 the component or model that will enable/disable this widget
	* @see		#getEnabler
	**/
	 public void setEnabler(com.ulcjava.base.application.enabler.IEnabler enabler)
	{
	}


	/**
	* Sets the font of this component.
	*
	* @param f 		 the font to be set for this component. If null is passed the component inherits the font of its parent.
	* @see		#getFont
	**/
	 public void setFont(com.ulcjava.base.application.util.Font f)
	{
	}


	/**
	* Sets the foreground color of this component.
	*
	* @param c 		 the color to set as foreground for this component. If null is passed the component inherits the foreground color of its
parent.
	* @see		#getForeground
	**/
	 public void setForeground(com.ulcjava.base.application.util.Color c)
	{
	}


	/**
	* Sets the help document as specified by <code>urlString</code> and
	* <code>target</code>.
<p>
</p>
The target indicates the HTML frame the help
	* document is to be displayed in. The target argument is interpreted as
	* follows:<ul>
<li><code>"_self"</code>: Show in the window and frame that
	* contains the UI engine.
<li><code>"_parent"</code>: Show in the UI engine's
	* parent frame. If the UI engine's frame has no parent frame, acts the same
	* as
"_self".
<li><code>"_top"</code>: Show in the top-level frame of the UI
	* engine's window. If the UI engine's frame is the top-level frame,
acts the
	* same as "_self".
<li><code>"_blank"</code>: Show in a new, unnamed top-level
	* window.
<li><code>name</code>: Show in the frame or window named
	* <code>name</code>. If a target named <code>name</code> does not
already
	* exist,a new top-level window with the specified name is created, and the
	* document is shown there.
</ul>
<p>
</p>
The client environment may ignore the
	* <code>target</code> parameter.
	*
	* @param helpUrlString 		 the URL string of the document
	* @param helpTarget 		 the target where the document has to be displayed in
	* @see		#getHelpUrlString
	* @see		#getHelpTarget
	* @deprecated		Use instead the ULCComponent.registerKeyboardAction() method with a F1 key stroke and the
WHEN_ANCESTOR_OF_FOCUSED_COMPONENT condition as arguments.
	**/
	 public void setHelpDocument(java.lang.String helpUrlString, java.lang.String helpTarget)
	{
	}


	/**
	* Sets the help document as specified by <code>urlString</code>.
	*
	* @param helpUrlString 		 the URL string of the document
	* @see		#getHelpUrlString
	* @see		#getHelpTarget
	* @deprecated		Use instead the ULCComponent.registerKeyboardAction() method with a F1 key stroke and the
WHEN_ANCESTOR_OF_FOCUSED_COMPONENT condition as arguments.
	**/
	 public void setHelpDocument(java.lang.String helpUrlString)
	{
	}


	/**
	* Sets the help target as specified by <code>helpTarget</code>.
<p>
</p>
The
	* target indicates the HTML frame the help document is to be displayed in. The
	* target argument is interpreted as follows:
<ul>
<li><code>"_self"</code>:
	* Showin the window and frame that contains the UI
	* engine.
<li><code>"_parent"</code>: Show in the UI engine's parent frame. If
	* the UI engine's frame has no parent frame, acts the same
	* as
"_self".
<li><code>"_top"</code>: Show in the top-level frame of the UI
	* engine's window. If the UI engine's frame is the top-level frame,
acts the
	* same as "_self".
<li><code>"_blank"</code>: Show in a new, unnamed top-level
	* window.
<li><code>name</code>: Show in the frame or window named
	* <code>name</code>. If a target named <code>name</code> does not
already
	* exist,a new top-level window with the specified name is created, and the
	* document is shown there.
</ul>
<p>
</p>
The client environment may ignore the
	* <code>target</code> parameter.
	*
	* @param helpTarget 		 the target where the document has to be displayed in
	* @see		#getHelpTarget
	* @deprecated		Use instead the ULCComponent.registerKeyboardAction() method with a F1 key stroke and the
WHEN_ANCESTOR_OF_FOCUSED_COMPONENT condition as arguments.
	**/
	 public void setHelpTarget(java.lang.String helpTarget)
	{
	}


	/**
	* Sets the help help URL string as specified by <code>helpUrlString</code>.
	*
	* @param helpUrlString 		 the URL string of the document
	* @see		#getHelpUrlString
	* @deprecated		Use instead the ULCComponent.registerKeyboardAction() method with a F1 key stroke and the
WHEN_ANCESTOR_OF_FOCUSED_COMPONENT condition as arguments.
	**/
	 public void setHelpUrlString(java.lang.String helpUrlString)
	{
	}


	/**
	* Sets a <code>ULCPopupMenu</code> on this component.
	*
	* @param componentPopupMenu 		 the popup menu set on this component
	**/
	 public void setComponentPopupMenu(com.ulcjava.base.application.ULCPopupMenu componentPopupMenu)
	{
	}


	/**
	* Returns the <code>ULCPopupMenu</code> component popup menu for this component
	* or a <code>ULCPopupMenu</code> defined by a
predecessor if the inherit popup
	* menu is set to <code>true</code>. Returns <code>null</code> if no popup menu
	* is set on the
applicable menu.
	*
	* @return		a <code>ULCPopupMenu</code> or an inherited one, or null if the corresponding popup menu is undefined
	**/
	 public com.ulcjava.base.application.ULCPopupMenu getComponentPopupMenu()
	{
		return null;
	}


	/**
	* Sets this component to inherit a popup menu from a predecessor where the popup
	* menu is not <code>null</code>. The hierarchy will
be traversed until a
	* component is found that has a popup menu or that has set the
	* inheritsPopoup-flag to false.
	*
	* @param value 		 if true inherits a popup menu from a predecessor
	**/
	 public void setInheritsPopupMenu(boolean value)
	{
	}


	/**
	* Sets this component to inherit a popup menu from a predecessor where the popup
	* menu is not <code>null</code>. The hierarchy will
be traversed until a
	* component is found that has a popup menu or that has set the
	* inheritsPopoup-flag to false. Use this method from
constructors in subclasses
	* in order to set the property value without side effects (as {@link
	* #setInheritsPopupMenu(boolean)} might
be overridden in
	* subclasses).
<p>
</p>
{@link #setInheritsPopupMenu(boolean)} delegates to
	* thismethod.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetInheritsPopupMenu(boolean value)
	{
	}


	/**
	* Returns true if this component inherits a popup menu from a predecessor.
	*
	* @return		true if this component inherits a popup menu from a predecessor
	**/
	 public boolean getInheritsPopupMenu()
	{
		return false;
	}


	/**
	* Returns whether this component can be focused.
	*
	* @return		<code>true</code> if this component is focusable, <code>false</code> otherwise.
	**/
	 public boolean isFocusable()
	{
		return false;
	}


	/**
	* Sets whether this component is focusable. This value overrides the component's
	* default focusability.
	*
	* @param focusable 		 <code>true</code> if this component should be focusable, <code>false</code> otherwise.
	**/
	 public void setFocusable(boolean focusable)
	{
	}


	/**
	* Sets the focusable property on the server side and synchronizes a changed
	* property value to the client side. Use this method from
constructors in
	* subclasses in order to set the property value without side effects (as {@link
	* #setFocusable(boolean)} might be
overridden in subclasses).
<p>
</p>
{@link
	* #setFocusable(boolean)} delegates to this method.
	*
	* @param focusable 		 true if the componet should be focusable, false otherwise
	* @ulc.extension		
	**/
	 protected  final void internalSetFocusable(boolean focusable)
	{
	}


	/**
	* Sets the text to be displayed in a tool tip.
	*
	* @param text 		 the string to display in the tool tip; if null is passed the tool tip is turned off.
	* @see		#getToolTipText
	**/
	 public void setToolTipText(java.lang.String text)
	{
	}


	/**
	* Shows or hides this component as specified by <code>b</code>. By default
	* components are visible, except top-level components such
as
	* <code>Frame</code>. If the parent is invisible this method has no effect.
	*
	* @param b 		 if <code>true</code>, show this component; otherwise, hide this component.
	* @see		#isVisible
	**/
	 public void setVisible(boolean b)
	{
	}


	/**
	* Sets the visible property on the server side and synchronizes a changed
	* property value to the client side. Use this method from
constructors in
	* subclasses in order to set the property value without side effects (as {@link
	* #setVisible(boolean)} might be
overridden in subclasses).
<p>
</p>
{@link
	* #setVisible(boolean)} delegates to this method.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetVisible(boolean b)
	{
	}


	/**
	* Sets the preferred size of the component. If <code>preferredSize</code> is
	* null, the preferred size is computed on the client-side.
	*
	* @param preferredSize 		 the preferred size
	**/
	 public void setPreferredSize(com.ulcjava.base.application.util.Dimension preferredSize)
	{
	}


	/**
	* Returns the preferred size of the component, if set on the server-side.
	*
	* @return		the preferred size
	**/
	 public com.ulcjava.base.application.util.Dimension getPreferredSize()
	{
		return null;
	}


	/**
	* Sets the maximum size of the component. If <code>maximumSize</code> is null,
	* the maximum size is computed on the client-side.
	*
	* @param maximumSize 		 the maximum size
	**/
	 public void setMaximumSize(com.ulcjava.base.application.util.Dimension maximumSize)
	{
	}


	/**
	* Returns the maximum size of the component.
<p>
</p>
<b>Note:</b> Returns null
	* if no custom maximum size is set.
	*
	* @return		the maximum size of the component
	**/
	 public com.ulcjava.base.application.util.Dimension getMaximumSize()
	{
		return null;
	}


	/**
	* Sets the minimum size of the component. If <code>minimumSize</code> is null,
	* the minimum size is computed on the client-side.
	*
	* @param minimumSize 		 the minimum size
	**/
	 public void setMinimumSize(com.ulcjava.base.application.util.Dimension minimumSize)
	{
	}


	/**
	* Returns the minimum size of the component.
<p>
</p>
<b>Note:</b> Returns null
	* if no custom minimum size is set.
	*
	* @return		the minimum size of the component
	**/
	 public com.ulcjava.base.application.util.Dimension getMinimumSize()
	{
		return null;
	}


	/**
	* Returns the component that will gain focus next by pressing the tab-key.
	* Returns null if not set explicit.
	*
	* @return		the next focusable component or null if not set
	**/
	 public com.ulcjava.base.application.ULCComponent getNextFocusableComponent()
	{
		return null;
	}


	/**
	* Sets the ULCComponent that will receive focus after this component by pressing
	* the tab-key.
<p>
</p>
Note: As per Swing an invisible component cannot gain
	* focus even if it is the nextFocusableElement. A component in an
	* invisible
container can get focus by virtue of being the nextFocusableElement
	* but subsequently the focus cannot be transfered out from it.
	*
	* @param nextFocusableComponent 		 the component to gain focus after this component.
	**/
	 public void setNextFocusableComponent(com.ulcjava.base.application.ULCComponent nextFocusableComponent)
	{
	}


	/**
	* Returns <i>true</i> if this component automatically scrolls its contents when
	* dragged (when contained in a component that supports
scrolling, like
	* ULCScrollPane).
	*
	* @return		true (boolean value) if autoscrolls content when dragged
	**/
	 public boolean getAutoscrolls()
	{
		return false;
	}


	/**
	* If <i>true</i> this component will automatically scroll its contents when
	* dragged, if contained in a component that supports
scrolling, such as
	* ULCScrollPane.
	*
	* @param autoscrolls 		 true if component should automatically scroll
	**/
	 public void setAutoscrolls(boolean autoscrolls)
	{
	}


	/**
	* Registers the key listener <code>listener</code>. The listener will receive
	* keyevents from this text component. If l is null, no
exception is thrown and
	* no action is performed.
	*
	* @param listener 		 the key listener.
	* @see		KeyEvent
	* @see		IKeyListener
	* @see		#removeKeyListener
	**/
	 public void addKeyListener(com.ulcjava.base.application.event.IKeyListener listener)
	{
	}


	/**
	* Removes the key listener <code>listener</code> from the text component. The
	* listener does not receive key events from this
component anymore. If the
	* listener has not previously been added to this text component this method has
	* no effect. If
<code>listener</code> is null, no exception is thrown and no
	* action is performed.
	*
	* @param listener 		 the key listener.
	* @see		KeyEvent
	* @see		IKeyListener
	* @see		#addKeyListener
	**/
	 public void removeKeyListener(com.ulcjava.base.application.event.IKeyListener listener)
	{
	}


	/**
	* Validates the first validateRoot (if any) found when walking up the
	* containmenthierarchy of this component.
<p>
</p>
It is only necessary to call
	* this method explicitly when the layout of the component is not updated
	* correctly.
	*
	**/
	 public void revalidate()
	{
	}


	/**
	* Repaints this component. The layout is not recalculated.
<p>
</p>
It is only
	* necessary to call this method explicitly when setting attributes that affect
	* the visual representation of the component
but do not modify the layout and
	* the client-side does not take care of it.
	*
	**/
	 public void repaint()
	{
	}


	/**
	* Gets the border of this component.
	*
	* @return		<code>ULCAbstractBorder</code> - the border of this component.
	* @see		#setBorder
	**/
	 public com.ulcjava.base.application.border.ULCAbstractBorder getBorder()
	{
		return null;
	}


	/**
	* Sets the border of this component. The <code>ULCAbstractBorder</code> object
	* isresponsible for defining the insets for the
component (overriding any
	* insetsset directly on the component) and for optionally rendering any border
	* decorations within the bounds
of those insets. Borders should be used (rather
	* than insets) for creating both decorative and non-decorative (such as margins
	* and
padding) regions for a ULC component. Compound borders can be used to
	* nestmultiple borders within a single component.
	*
	* @param border 		 the border to be set for this component.
	* @see		#getBorder
	**/
	 public void setBorder(com.ulcjava.base.application.border.ULCAbstractBorder border)
	{
	}


	/**
	* Opaque property when true makes the component paint every pixel within its
	* bounds. Otherwise, the component may not paint some or all
of its pixels,
	* allowing the underlying pixels to show through.
<p>
</p>
The default value of
	* this property is false for <code>ULCComponent</code>. However, the default
	* value for this property on most
standard <code>ULCComponent</code> subclasses
	* (such as <code>ULCButton</code> and <code>ULCTree</code>) is
	* look-and-feel
dependent. The value of this property is initialised with the
	* value available from LAF.
	*
	* @param opaque 		 true if this component should be opaque
	* @see		#isOpaque
	**/
	 public void setOpaque(boolean opaque)
	{
	}


	/**
	* Returns true if this component is completely opaque.
<p>
</p>
An opaque
	* component paints every pixel within its rectangular bounds. A non-opaque
	* component paints only a subset of its pixels or
none at all, allowing the
	* pixels underneath it to "show through". Therefore, a component that does not
	* fully paint its pixels
provides a degree of transparency.
	*
	* @return		true if this component is completely opaque
	* @see		#setOpaque
	**/
	 public boolean isOpaque()
	{
		return false;
	}


	/**
	* Returns the alignment along the x axis. This specifies how the component
	* shouldbe aligned relative to other components.
<p>
</p>
The value must be a
	* number between 0 and 1:
<ul>
<li>0 represents alignment along the
	* origin
<li>1represents alignment furthest away from the origin
<li>0.5
	* represents centered alignment
<li>etc.
</ul>
	*
	* @return		the alignment of the component along the x axis
	**/
	 public float getAlignmentX()
	{
		return 0.0f;
	}


	/**
	* Sets the alignment along the x axis. This specifies how the component should
	* bealigned relative to other components.
<p>
</p>
The value must be a number
	* between 0 and 1:
<ul>
<li>0 represents alignment along the origin
<li>1
	* represents alignment furthest away from the origin
<li>0.5 represents
	* centeredalignment
<li>etc.
</ul>
	*
	* @param alignmentX 		 the alignment of the component along the x axis
	**/
	 public void setAlignmentX(float alignmentX)
	{
	}


	/**
	* Sets the alignmentX property on the server side and synchronizes a changed
	* property value to the client side. Use this method from
constructors in
	* subclasses in order to set the property value without side effects (as {@link
	* #setAlignmentX(float)} might be
overridden in subclasses).
<p>
</p>
{@link
	* #setAlignmentX(float)} delegates to this method.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetAlignmentX(float alignmentX)
	{
	}


	/**
	* Returns the alignment along the y axis. This specifies how the component
	* shouldbe aligned relative to other components.
<p>
</p>
The value must be a
	* number between 0 and 1:
<ul>
<li>0 represents alignment along the
	* origin
<li>1represents alignment farthest away from the origin
<li>0.5
	* represents centered alignment
<li>etc.
</ul>
	*
	* @return		the alignment of the component along the y axis
	**/
	 public float getAlignmentY()
	{
		return 0.0f;
	}


	/**
	* Sets the alignment along the y axis. This specifies how the component should
	* bealigned relative to other components.
<p>
</p>
The value must be a number
	* between 0 and 1:
<ul>
<li>0 represents alignment along the origin
<li>1
	* represents alignment furthest away from the origin
<li>0.5 represents
	* centeredalignment
<li>etc.
</ul>
	*
	* @param alignmentY 		 the alignment of the component along the y axis
	**/
	 public void setAlignmentY(float alignmentY)
	{
	}


	/**
	* Determines whether or not this <code>ULCComponent</code> should get focus.
	* Thisproperty is a hint to the look and feel. It
typically applies to mouse
	* operations, but not keyboard operations. For instance, it can be used in the
	* case when a mouse press on a
<code>ULCComponent</code> should not steal focus
	* and yet the component should be traversable via the keyboard.
	*
	* @param requestFocusEnabled 		 true if this component should be focusable, false otherwise
	* @see		#setFocusable
	**/
	 public void setRequestFocusEnabled(boolean requestFocusEnabled)
	{
	}


	/**
	* Returns true if this component should get focus, false otherwise.
	*
	* @return		true if this component should get focus, false otherwise
	* @see		#setRequestFocusEnabled
	* @see		#isFocusable
	**/
	 public boolean isRequestFocusEnabled()
	{
		return false;
	}


	/**
	* Determines whether this <code>ULCComponent</code> is the root of a focus
	* traversal cycle.
	*
	* @param focusCycleRoot 		 true if this component should be the root of a focus traversal cycle, false otherwise
	**/
	 public void setFocusCycleRoot(boolean focusCycleRoot)
	{
	}


	/**
	* Returns true if this component is the root of a focus traversal cycle, false
	* otherwise.
	*
	* @return		true if this component is the root of a focus traversal cycle, false otherwise
	* @see		#setFocusCycleRoot
	**/
	 public boolean isFocusCycleRoot()
	{
		return false;
	}


	/**
	* Transfers the focus to the next component.
	*
	* @see		#requestFocus()
	**/
	 public void transferFocus()
	{
	}


	/**
	* Transfers the focus to the previous component.
	*
	* @see		#requestFocus()
	**/
	 public void transferFocusBackward()
	{
	}


	/**
	* Transfers the focus up one focus traversal cycle.
	*
	* @see		#requestFocus()
	**/
	 public void transferFocusUpCycle()
	{
	}


	/**
	* Transfers the focus down one focus traversal cycle.
	*
	* @see		#requestFocus()
	**/
	 public void transferFocusDownCycle()
	{
	}


	/**
	* Sets the language-sensitive orientation that is to be used to order the
	* elements or text within this component. The default value of
orientation is
	* <code>ComponentOrientation.UNKNOWN</code> which is same as
	* <code>ComponentOrientation.LEFT_TO_RIGHT</code>.
	*
	* @param componentOrientation 		 ComponentOrientation to set
	* @see		ComponentOrientation
	**/
	 public void setComponentOrientation(com.ulcjava.base.application.util.ComponentOrientation componentOrientation)
	{
	}


	/**
	* Returns the ComponentOrientation that determines the language-sensitive
	* ordering of the elements or text within this component.
	*
	* @return		ComponentOrientation used for language sensitive ordering of elements and text
	* @see		ComponentOrientation
	**/
	 public com.ulcjava.base.application.util.ComponentOrientation getComponentOrientation()
	{
		return null;
	}


	/**
	* Sets the <code>ComponentOrientation</code> for this component and all its
	* contained components.
	*
	* @param componentOrientation 		 the new component orientation to set on this component and its contained components
	* @exception		NullPointerException if <code>componentOrientation</code> is null.
	* @see		#setComponentOrientation
	* @see		#getComponentOrientation
	**/
	 public void applyComponentOrientation(com.ulcjava.base.application.util.ComponentOrientation componentOrientation)
	{
	}


	/**
	* Returns if the component is contained in the component hierarchy of a window
	* that is displayable.
	*
	* @return		true if the component is in the component hierarchy of a window that is displayable, false otherwise
	**/
	 public boolean isDisplayable()
	{
		return false;
	}


	/**
	* Sets the alignmentY property on the server side and synchronizes a changed
	* property value to the client side. Use this method from
constructors in
	* subclasses in order to set the property value without side effects (as {@link
	* #setAlignmentY(float)} might be
overridden in subclasses).
<p>
</p>
{@link
	* #setAlignmentY(float)} delegates to this method.
	*
	* @ulc.extension		
	**/
	 protected  final void internalSetAlignmentY(float alignmentY)
	{
	}

	 protected void uploadStateUI()
	{
	}

	 protected void localSetVisible(boolean visible)
	{
	}

	 protected void addNotify()
	{
	}

	 protected void removeNotify()
	{
	}

	 protected void updateEnabled(boolean enabled)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected java.lang.Class getKeyboardActionListenerClass()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCComponentDispatcher extends ULCProxyDispatcher
{

	 public  final void lastKeyStroke(com.ulcjava.base.application.util.KeyStroke keyStroke)
	{
	}

	 public  final com.ulcjava.base.application.event.ActionEvent createKeyboardActionEvent()
	{
		return null;
	}

	 public  final void processKeyboardActionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.ActionEvent eventObject)
	{
	}

	 public  final java.lang.Class getKeyboardActionListenerClass()
	{
		return null;
	}

	 public  final void updateEnabled(boolean enabled)
	{
	}


}
}